/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.dom.DomDatabaseWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomGroupWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomHelper;
import org.linguafranca.pwdb.kdbx.dom.DomIconWrapper;
import org.w3c.dom.Element;

public class DomEntryWrapper
extends AbstractEntry<DomDatabaseWrapper, DomGroupWrapper, DomEntryWrapper, DomIconWrapper> {
    private static Map<String, DomHelper.ValueCreator> mandatoryEntryElements = new HashMap<String, DomHelper.ValueCreator>(){
        {
            this.put("UUID", new DomHelper.UuidValueCreator());
            this.put("IconID", new DomHelper.ConstantValueCreator("2"));
            this.put("Times", new DomHelper.ConstantValueCreator(""));
            this.put("Times/LastModificationTime", new DomHelper.DateValueCreator());
            this.put("Times/CreationTime", new DomHelper.DateValueCreator());
            this.put("Times/LastAccessTime", new DomHelper.DateValueCreator());
            this.put("Times/ExpiryTime", new DomHelper.DateValueCreator());
            this.put("Times/Expires", new DomHelper.ConstantValueCreator("False"));
            this.put("Times/UsageCount", new DomHelper.ConstantValueCreator("0"));
            this.put("Times/LocationChanged", new DomHelper.DateValueCreator());
        }
    };
    final Element element;
    private final DomDatabaseWrapper database;

    public DomEntryWrapper(Element element, DomDatabaseWrapper database, boolean newElement) {
        this.element = element;
        this.database = database;
        if (newElement) {
            DomHelper.ensureElements(element, mandatoryEntryElements);
            this.ensureProperty("Notes");
            this.ensureProperty("Title");
            this.ensureProperty("URL");
            this.ensureProperty("UserName");
            this.ensureProperty("Password");
        }
    }

    @Override
    public String getProperty(String name) {
        Element property = DomHelper.getElement(String.format("String[Key/text()='%s']", name), this.element, false);
        if (property == null) {
            return null;
        }
        return DomHelper.getElementContent("Value", property);
    }

    @Override
    public void setProperty(String name, String value) {
        Element property = DomHelper.getElement(String.format("String[Key/text()='%s']", name), this.element, false);
        if (property == null) {
            property = DomHelper.newElement("String", this.element);
            DomHelper.setElementContent("Key", property, name);
        }
        DomHelper.setElementContent("Value", property, value);
        DomHelper.touchElement("Times/LastModificationTime", this.element);
        this.database.setDirty(true);
    }

    @Override
    public boolean removeProperty(String name) throws IllegalArgumentException {
        if (STANDARD_PROPERTY_NAMES.contains(name)) {
            throw new IllegalArgumentException("may not remove property: " + name);
        }
        boolean wasRemoved = DomHelper.removeElement(String.format("String[Key/text()='%s']", name), this.element);
        if (wasRemoved) {
            this.database.setDirty(true);
        }
        return wasRemoved;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> list = DomHelper.getElements("String", this.element);
        for (Element listElement : list) {
            result.add(DomHelper.getElementContent("Key", listElement));
        }
        return result;
    }

    @Override
    public byte[] getBinaryProperty(String name) {
        Element property = DomHelper.getElement(String.format("Binary[Key/text()='%s']", name), this.element, false);
        if (property == null) {
            return null;
        }
        return DomHelper.getBinaryElementContent("Value", property);
    }

    @Override
    public void setBinaryProperty(String name, byte[] value) {
        Element property = DomHelper.getElement(String.format("Binary[Key/text()='%s']", name), this.element, false);
        if (property == null) {
            property = DomHelper.newElement("Binary", this.element);
            DomHelper.setElementContent("Key", property, name);
        }
        DomHelper.setBinaryElementContent("Value", property, value);
        DomHelper.touchElement("Times/LastModificationTime", this.element);
        this.database.setDirty(true);
    }

    @Override
    public boolean removeBinaryProperty(String name) {
        boolean wasRemoved = DomHelper.removeElement(String.format("Binary[Key/text()='%s']", name), this.element);
        if (wasRemoved) {
            this.database.setDirty(true);
        }
        return wasRemoved;
    }

    @Override
    public List<String> getBinaryPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> list = DomHelper.getElements("Binary", this.element);
        for (Element listElement : list) {
            result.add(DomHelper.getElementContent("Key", listElement));
        }
        return result;
    }

    private void ensureProperty(String name) {
        Element property = DomHelper.getElement(String.format("String[Key/text()='%s']", name), this.element, false);
        if (property == null) {
            Element container = DomHelper.newElement("String", this.element);
            DomHelper.setElementContent("Key", container, name);
            DomHelper.getElement("Value", container, true);
        }
    }

    @Override
    public DomGroupWrapper getParent() {
        if (this.element.getParentNode() == null) {
            return null;
        }
        return new DomGroupWrapper((Element)this.element.getParentNode(), this.database, false);
    }

    @Override
    public UUID getUuid() {
        return Helpers.uuidFromBase64(DomHelper.getElementContent("UUID", this.element));
    }

    @Override
    public DomIconWrapper getIcon() {
        return new DomIconWrapper(DomHelper.getElement("IconID", this.element, false));
    }

    @Override
    public void setIcon(DomIconWrapper icon) {
        DomHelper.getElement("IconID", this.element, true).setTextContent(String.valueOf(icon.getIndex()));
        DomHelper.touchElement("Times/LastModificationTime", this.element);
        this.database.setDirty(true);
    }

    @Override
    public Date getLastAccessTime() {
        try {
            return DomHelper.dateFormatter.parse(DomHelper.getElementContent("Times/LastAccessTime", this.element));
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    public Date getCreationTime() {
        try {
            return DomHelper.dateFormatter.parse(DomHelper.getElementContent("Times/CreationTime", this.element));
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    public boolean getExpires() {
        String content = DomHelper.getElementContent("Times/Expires", this.element);
        return content != null && content.equalsIgnoreCase("true");
    }

    @Override
    public void setExpires(boolean expires) {
        DomHelper.setElementContent("Times/Expires", this.element, expires ? "True" : "False");
    }

    @Override
    public Date getExpiryTime() {
        try {
            return DomHelper.dateFormatter.parse(DomHelper.getElementContent("Times/ExpiryTime", this.element));
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    public void setExpiryTime(Date expiryTime) throws IllegalArgumentException {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        String formatted = DomHelper.dateFormatter.format(expiryTime);
        DomHelper.setElementContent("Times/ExpiryTime", this.element, formatted);
    }

    @Override
    public Date getLastModificationTime() {
        try {
            return DomHelper.dateFormatter.parse(DomHelper.getElementContent("Times/LastModificationTime", this.element));
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    @Override
    protected void touch() {
        DomHelper.setElementContent("Times/LastModificationTime", this.element, DomHelper.dateFormatter.format(new Date()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomEntryWrapper that = (DomEntryWrapper)o;
        return this.element.equals(that.element) && this.database.equals(that.database);
    }
}

