/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.StreamFormat;
import org.linguafranca.pwdb.kdbx.dom.DomEntryWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomGroupWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomHelper;
import org.linguafranca.pwdb.kdbx.dom.DomIconWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomSerializableDatabase;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxStreamFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomDatabaseWrapper
extends AbstractDatabase<DomDatabaseWrapper, DomGroupWrapper, DomEntryWrapper, DomIconWrapper> {
    private Document document;
    private Element dbRootGroup;
    Element dbMeta;
    private DomSerializableDatabase domDatabase = DomSerializableDatabase.createEmptyDatabase();

    public DomDatabaseWrapper() throws IOException {
        this.init();
    }

    public DomDatabaseWrapper(StreamFormat streamFormat, Credentials credentials, InputStream inputStream2) throws IOException {
        streamFormat.load(this.domDatabase, credentials, inputStream2);
        this.init();
    }

    public static DomDatabaseWrapper load(Credentials credentials, InputStream inputStream2) throws IOException {
        return new DomDatabaseWrapper(new KdbxStreamFormat(), credentials, inputStream2);
    }

    private void init() {
        this.document = this.domDatabase.getDoc();
        try {
            this.dbRootGroup = (Element)DomHelper.xpath.evaluate("/KeePassFile/Root/Group", this.document, XPathConstants.NODE);
            this.dbMeta = (Element)DomHelper.xpath.evaluate("/KeePassFile/Meta", this.document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void save(Credentials credentials, OutputStream outputStream2) throws IOException {
        new KdbxStreamFormat().save(this.domDatabase, credentials, outputStream2);
        this.setDirty(false);
    }

    public void save(StreamFormat streamFormat, Credentials credentials, OutputStream outputStream2) throws IOException {
        streamFormat.save(this.domDatabase, credentials, outputStream2);
        this.setDirty(false);
    }

    @Override
    public boolean shouldProtect(String name) {
        Element protectionElement = DomHelper.getElement("MemoryProtection/Protect" + name, this.dbMeta, false);
        if (protectionElement == null) {
            return false;
        }
        return Boolean.valueOf(protectionElement.getTextContent());
    }

    @Override
    public DomGroupWrapper getRootGroup() {
        return new DomGroupWrapper(this.dbRootGroup, this, false);
    }

    @Override
    public DomGroupWrapper newGroup() {
        return new DomGroupWrapper(this.document.createElement("Group"), this, true);
    }

    @Override
    public DomEntryWrapper newEntry() {
        return new DomEntryWrapper(this.document.createElement("Entry"), this, true);
    }

    @Override
    public DomIconWrapper newIcon() {
        return new DomIconWrapper(this.document.createElement("IconID"));
    }

    @Override
    public DomIconWrapper newIcon(Integer i) {
        DomIconWrapper icon = this.newIcon();
        icon.setIndex(i);
        return icon;
    }

    @Override
    public DomGroupWrapper getRecycleBin() {
        UUID uuid;
        String UUIDcontent = DomHelper.getElementContent("RecycleBinUuid", this.dbMeta);
        if (UUIDcontent != null && (uuid = Helpers.uuidFromBase64(UUIDcontent)).getLeastSignificantBits() != 0L && uuid.getMostSignificantBits() != 0L) {
            for (DomGroupWrapper g2 : this.getRootGroup().getGroups()) {
                if (!g2.getUuid().equals(uuid)) continue;
                return g2;
            }
        }
        if (!this.isRecycleBinEnabled()) {
            return null;
        }
        DomGroupWrapper g3 = this.newGroup();
        g3.setName("Recycle Bin");
        this.getRootGroup().addGroup(g3);
        DomHelper.ensureElementContent("RecycleBinUuid", this.dbMeta, Helpers.base64FromUuid(g3.getUuid()));
        DomHelper.touchElement("RecycleBinChanged", this.dbMeta);
        return g3;
    }

    @Override
    public boolean isRecycleBinEnabled() {
        return Boolean.valueOf(DomHelper.getElementContent("RecycleBinEnabled", this.dbMeta));
    }

    @Override
    public void enableRecycleBin(boolean enable) {
        DomHelper.setElementContent("RecycleBinEnabled", this.dbMeta, Boolean.valueOf(enable).toString());
    }

    @Override
    public String getName() {
        return DomHelper.getElementContent("DatabaseName", this.dbMeta);
    }

    @Override
    public void setName(String name) {
        DomHelper.setElementContent("DatabaseName", this.dbMeta, name);
        DomHelper.touchElement("DatabaseNameChanged", this.dbMeta);
        this.setDirty(true);
    }

    @Override
    public String getDescription() {
        return DomHelper.getElementContent("DatabaseDescription", this.dbMeta);
    }

    @Override
    public void setDescription(String description) {
        DomHelper.setElementContent("DatabaseDescription", this.dbMeta, description);
        DomHelper.touchElement("DatabaseDescriptionChanged", this.dbMeta);
        this.setDirty(true);
    }
}

