/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Helpers {
    private static SimpleDateFormat inFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static String base64FromUuid(UUID uuid) {
        byte[] buffer = new byte[16];
        ByteBuffer b = ByteBuffer.wrap(buffer);
        b.putLong(uuid.getMostSignificantBits());
        b.putLong(8, uuid.getLeastSignificantBits());
        return new String(Base64.encodeBase64(buffer));
    }

    public static String hexStringFromUuid(UUID uuid) {
        byte[] buffer = new byte[16];
        ByteBuffer b = ByteBuffer.wrap(buffer);
        b.putLong(uuid.getMostSignificantBits());
        b.putLong(8, uuid.getLeastSignificantBits());
        return new String(Hex.encodeHex(buffer));
    }

    public static String hexStringFromBase64(String base64) {
        byte[] buffer = Base64.decodeBase64(base64.getBytes());
        return new String(Hex.encodeHex(buffer));
    }

    public static UUID uuidFromBase64(String base64) {
        byte[] buffer = Base64.decodeBase64(base64.getBytes());
        ByteBuffer b = ByteBuffer.wrap(buffer);
        return new UUID(b.getLong(), b.getLong(8));
    }

    public static Boolean toBoolean(String value) {
        return value.toLowerCase().equals("true") || value.toLowerCase().equals("Yes") || value.equals("1");
    }

    public static String fromBoolean(Boolean value) {
        return value == null ? "False" : (value != false ? "True" : "False");
    }

    public static Date toDate(String value) {
        try {
            return inFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String fromDate(Date value) {
        return inFormat.format(value);
    }

    public static byte[] decodeBase64Content(byte[] content) {
        return Helpers.decodeBase64Content(content, false);
    }

    public static byte[] decodeBase64Content(byte[] content, boolean isCompressed) {
        byte[] value = Base64.decodeBase64(content);
        if (isCompressed) {
            return Helpers.unzipBinaryContent(value);
        }
        return value;
    }

    public static byte[] unzipBinaryContent(byte[] content) {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        try {
            GZIPInputStream g2 = new GZIPInputStream(bais);
            return ByteStreams.toByteArray(g2);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encodeBase64Content(byte[] value) {
        return Helpers.encodeBase64Content(value, false);
    }

    public static String encodeBase64Content(byte[] value, boolean isCompressed) {
        if (!isCompressed) {
            return Base64.encodeBase64String(value);
        }
        return Base64.encodeBase64String(Helpers.zipBinaryContent(value));
    }

    public static byte[] zipBinaryContent(byte[] value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream g2 = new GZIPOutputStream(baos);
            g2.write(value, 0, value.length);
            g2.flush();
            g2.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }
}

