/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdb.KdbDatabase;
import org.linguafranca.pwdb.kdb.KdbGroup;
import org.linguafranca.pwdb.kdb.KdbIcon;

public class KdbEntry
extends AbstractEntry<KdbDatabase, KdbGroup, KdbEntry, KdbIcon> {
    KdbGroup parent;
    private UUID uuid = UUID.randomUUID();
    private String title = "";
    private String url = "";
    private String notes = "";
    private KdbIcon icon = new KdbIcon(0);
    private String username = "";
    private String password = "";
    private Date creationTime;
    private Date lastModificationTime = this.creationTime = new Date(System.currentTimeMillis() / 1000L * 1000L);
    private Date lastAccessTime = this.creationTime;
    private boolean expires = false;
    private Date expiryTime = new Date(Long.MAX_VALUE);
    private String binaryDescription = "";
    private byte[] binaryData = new byte[0];

    @Override
    public String getProperty(String name) {
        switch (name) {
            case "UserName": {
                return this.getUsername();
            }
            case "Password": {
                return this.getPassword();
            }
            case "URL": {
                return this.getUrl();
            }
            case "Title": {
                return this.getTitle();
            }
            case "Notes": {
                return this.getNotes();
            }
        }
        return null;
    }

    @Override
    public void setProperty(String name, String value) {
        switch (name) {
            case "UserName": {
                this.setUsername(value);
                break;
            }
            case "Password": {
                this.setPassword(value);
                break;
            }
            case "URL": {
                this.setUrl(value);
                break;
            }
            case "Title": {
                this.setTitle(value);
                break;
            }
            case "Notes": {
                this.setNotes(value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot set non-standard properties in KDB format");
            }
        }
    }

    @Override
    public boolean removeProperty(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove non-standard properties in KDB format");
    }

    @Override
    public boolean removeBinaryProperty(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove binary properties in KDB format");
    }

    @Override
    public List<String> getPropertyNames() {
        return new ArrayList<String>(Entry.STANDARD_PROPERTY_NAMES);
    }

    @Override
    public KdbGroup getParent() {
        return this.parent;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String pass) {
        this.password = pass;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public KdbIcon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(KdbIcon icon) {
        this.icon = icon;
    }

    void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    @Override
    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setExpiryTime(Date expiryTime) {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        this.expiryTime = expiryTime;
    }

    @Override
    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public String getBinaryDescription() {
        return this.binaryDescription;
    }

    void setBinaryDescription(String binaryDescription) {
        this.binaryDescription = binaryDescription;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    @Override
    public String toString() {
        String time = KdbDatabase.isoDateFormat.format(this.creationTime);
        return this.getPath() + String.format(" (%s, %s, %s) %s [%s]", this.url, this.username, this.notes.substring(0, Math.min(this.notes.length(), 24)), time, this.binaryDescription);
    }

    @Override
    public boolean match(String text) {
        return super.match(text) || this.getBinaryDescription().toLowerCase().contains(text.toLowerCase());
    }

    @Override
    public byte[] getBinaryProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryProperty(String name, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getBinaryPropertyNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExpires(boolean expires) {
        this.expires = expires;
    }

    @Override
    public boolean getExpires() {
        return this.expires;
    }

    @Override
    protected void touch() {
        this.lastModificationTime = new Date();
    }
}

