/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Visitor;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdb.KdbEntry;
import org.linguafranca.pwdb.kdb.KdbGroup;
import org.linguafranca.pwdb.kdb.KdbHeader;
import org.linguafranca.pwdb.kdb.KdbIcon;
import org.linguafranca.pwdb.kdb.KdbSerializer;

public class KdbDatabase
extends AbstractDatabase<KdbDatabase, KdbGroup, KdbEntry, KdbIcon> {
    private String description;
    private KdbGroup rootGroup = new KdbGroup();
    static SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public KdbDatabase() {
        this.rootGroup.setRoot(true);
        this.rootGroup.setName("Root");
        this.rootGroup.setIcon(new KdbIcon(1));
        this.rootGroup.setUuid(UUID.randomUUID());
    }

    public static KdbDatabase load(Credentials credentials, InputStream inputStream2) throws IOException {
        return KdbSerializer.createKdbDatabase(credentials, new KdbHeader(), inputStream2);
    }

    @Override
    public KdbGroup findGroup(UUID uuid) {
        GroupFinder groupFinder = new GroupFinder(uuid);
        this.visit(groupFinder);
        return (KdbGroup)groupFinder.foundGroup;
    }

    @Override
    public KdbGroup getRootGroup() {
        return this.rootGroup;
    }

    @Override
    public KdbGroup newGroup() {
        return new KdbGroup();
    }

    @Override
    public KdbEntry newEntry() {
        return new KdbEntry();
    }

    @Override
    public KdbIcon newIcon() {
        return new KdbIcon(0);
    }

    @Override
    public KdbIcon newIcon(Integer i) {
        return new KdbIcon(i);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void save(Credentials credentials, OutputStream outputStream2) throws IOException {
        throw new UnsupportedOperationException("Cannot save KDB files in this implementation");
    }

    @Override
    public boolean shouldProtect(String propertyName) {
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String s2) {
    }

    @Override
    public boolean isRecycleBinEnabled() {
        return false;
    }

    @Override
    public void enableRecycleBin(boolean enable) {
        if (enable) {
            throw new UnsupportedOperationException("KDB files don't have a recycle bin");
        }
    }

    @Override
    public KdbGroup getRecycleBin() {
        return null;
    }

    @Override
    public boolean supportsNonStandardPropertyNames() {
        return false;
    }

    @Override
    public boolean supportsBinaryProperties() {
        return false;
    }

    @Override
    public boolean supportsRecycleBin() {
        return false;
    }

    private static class GroupFinder
    extends Visitor.Default {
        Group foundGroup = null;
        UUID uuid;

        GroupFinder(UUID uuid) {
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null");
            }
            this.uuid = uuid;
        }

        @Override
        public void startVisit(Group group) {
            if (group != null && this.uuid.equals(group.getUuid())) {
                this.foundGroup = group;
            }
        }
    }
}

