/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.security.Encryption;
import org.spongycastle.util.encoders.Hex;

public interface KdbCredentials
extends Credentials {

    public static class KeyFile
    implements KdbCredentials {
        private final byte[] key;

        public KeyFile(byte[] password, InputStream inputStream2) {
            MessageDigest md = Encryption.getMessageDigestInstance();
            byte[] pwKey = md.digest(password);
            md.update(pwKey);
            try {
                byte[] keyFileData = ByteStreams.toByteArray(inputStream2);
                if (keyFileData.length == 64) {
                    keyFileData = Hex.decode(keyFileData);
                }
                this.key = md.digest(keyFileData);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read key file", e);
            }
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }
    }

    public static class Password
    implements KdbCredentials {
        private final byte[] key;

        public Password(byte[] password) {
            MessageDigest md = Encryption.getMessageDigestInstance();
            this.key = md.digest(password);
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }
    }
}

