/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.hashedblock;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;

public class HashedBlockOutputStream
extends OutputStream {
    private static MessageDigest md5;
    private static final int BLOCK_SIZE = 8192;
    private static final int HASH_SIZE = 32;
    private static final byte[] ZERO_HASH;
    private int nextSequenceNumber = 0;
    private boolean littleEndian = false;
    private OutputStream outputStream;
    private ByteArrayOutputStream blockOutputStream = new ByteArrayOutputStream();
    private boolean isClosed = false;

    public HashedBlockOutputStream(OutputStream outputStream2) {
        this(outputStream2, false);
    }

    public HashedBlockOutputStream(OutputStream outputStream2, boolean littleEndian) {
        this.outputStream = outputStream2;
        this.littleEndian = littleEndian;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] buf = new byte[]{(byte)i};
        this.put(buf, 0, 1);
    }

    @Override
    public void write(@NotNull byte[] b, int offset, int count) throws IOException {
        this.put(b, offset, count);
    }

    @Override
    public void flush() throws IOException {
        this.save();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        this.flush();
        this.writeInt(this.nextSequenceNumber);
        this.outputStream.write(ZERO_HASH);
        this.writeInt(0);
        this.isClosed = true;
        this.outputStream.flush();
        this.outputStream.close();
    }

    protected void put(byte[] b, int offset, int length) throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        while (length > 0) {
            int bytesToWrite = Math.min(8192 - this.blockOutputStream.size(), length);
            this.blockOutputStream.write(b, offset, bytesToWrite);
            if (this.blockOutputStream.size() >= 8192) {
                this.save();
            }
            offset += bytesToWrite;
            length -= bytesToWrite;
        }
    }

    protected void save() throws IOException {
        if (this.blockOutputStream.size() == 0) {
            return;
        }
        this.writeInt(this.nextSequenceNumber++);
        byte[] buffer = this.blockOutputStream.toByteArray();
        md5.update(buffer);
        this.outputStream.write(md5.digest());
        this.writeInt(buffer.length);
        this.outputStream.write(buffer);
        this.outputStream.flush();
        this.blockOutputStream.reset();
    }

    protected void writeInt(int value) throws IOException {
        int output = value;
        if (this.littleEndian) {
            output = Integer.reverseBytes(value);
        }
        this.outputStream.write(new byte[]{(byte)(output >> 24), (byte)(output >> 16), (byte)(output >> 8), (byte)output});
    }

    static {
        try {
            md5 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        ZERO_HASH = new byte[32];
    }
}

