/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.termstore.models.Group;
import com.microsoft.graph.termstore.requests.GroupCollectionPage;
import com.microsoft.graph.termstore.requests.GroupCollectionRequestBuilder;
import com.microsoft.graph.termstore.requests.GroupCollectionResponse;
import com.microsoft.graph.termstore.requests.GroupRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupCollectionRequest
extends BaseEntityCollectionRequest<Group, GroupCollectionResponse, GroupCollectionPage> {
    public GroupCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupCollectionResponse.class, GroupCollectionPage.class, GroupCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Group> postAsync(@Nonnull Group newGroup) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newGroup);
    }

    @Override
    @Nonnull
    public Group post(@Nonnull Group newGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroup);
    }

    @Nonnull
    public GroupCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public GroupCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

