/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.UserSource;
import com.microsoft.graph.security.requests.UserSourceCollectionPage;
import com.microsoft.graph.security.requests.UserSourceCollectionRequestBuilder;
import com.microsoft.graph.security.requests.UserSourceCollectionResponse;
import com.microsoft.graph.security.requests.UserSourceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserSourceCollectionRequest
extends BaseEntityCollectionRequest<UserSource, UserSourceCollectionResponse, UserSourceCollectionPage> {
    public UserSourceCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserSourceCollectionResponse.class, UserSourceCollectionPage.class, UserSourceCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<UserSource> postAsync(@Nonnull UserSource newUserSource) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserSourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newUserSource);
    }

    @Override
    @Nonnull
    public UserSource post(@Nonnull UserSource newUserSource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserSourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUserSource);
    }

    @Nonnull
    public UserSourceCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public UserSourceCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

