/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.VppToken;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.VppTokenCollectionPage;
import com.microsoft.graph.requests.VppTokenCollectionRequestBuilder;
import com.microsoft.graph.requests.VppTokenCollectionResponse;
import com.microsoft.graph.requests.VppTokenRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VppTokenCollectionRequest
extends BaseEntityCollectionRequest<VppToken, VppTokenCollectionResponse, VppTokenCollectionPage> {
    public VppTokenCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, VppTokenCollectionResponse.class, VppTokenCollectionPage.class, VppTokenCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<VppToken> postAsync(@Nonnull VppToken newVppToken) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new VppTokenRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newVppToken);
    }

    @Override
    @Nonnull
    public VppToken post(@Nonnull VppToken newVppToken) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new VppTokenRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newVppToken);
    }

    @Nonnull
    public VppTokenCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public VppTokenCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

