/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Subscription;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SubscriptionCollectionPage;
import com.microsoft.graph.requests.SubscriptionCollectionRequestBuilder;
import com.microsoft.graph.requests.SubscriptionCollectionResponse;
import com.microsoft.graph.requests.SubscriptionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubscriptionCollectionRequest
extends BaseEntityCollectionRequest<Subscription, SubscriptionCollectionResponse, SubscriptionCollectionPage> {
    public SubscriptionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubscriptionCollectionResponse.class, SubscriptionCollectionPage.class, SubscriptionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Subscription> postAsync(@Nonnull Subscription newSubscription) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscriptionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSubscription);
    }

    @Override
    @Nonnull
    public Subscription post(@Nonnull Subscription newSubscription) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscriptionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSubscription);
    }

    @Nonnull
    public SubscriptionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SubscriptionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

