/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.SubscribedSku;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SubscribedSkuCollectionPage;
import com.microsoft.graph.requests.SubscribedSkuCollectionRequestBuilder;
import com.microsoft.graph.requests.SubscribedSkuCollectionResponse;
import com.microsoft.graph.requests.SubscribedSkuRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubscribedSkuCollectionRequest
extends BaseEntityCollectionRequest<SubscribedSku, SubscribedSkuCollectionResponse, SubscribedSkuCollectionPage> {
    public SubscribedSkuCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubscribedSkuCollectionResponse.class, SubscribedSkuCollectionPage.class, SubscribedSkuCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<SubscribedSku> postAsync(@Nonnull SubscribedSku newSubscribedSku) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSubscribedSku);
    }

    @Override
    @Nonnull
    public SubscribedSku post(@Nonnull SubscribedSku newSubscribedSku) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSubscribedSku);
    }

    @Nonnull
    public SubscribedSkuCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SubscribedSkuCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

