/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ServiceHealth;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ServiceHealthCollectionPage;
import com.microsoft.graph.requests.ServiceHealthCollectionRequestBuilder;
import com.microsoft.graph.requests.ServiceHealthCollectionResponse;
import com.microsoft.graph.requests.ServiceHealthRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceHealthCollectionRequest
extends BaseEntityCollectionRequest<ServiceHealth, ServiceHealthCollectionResponse, ServiceHealthCollectionPage> {
    public ServiceHealthCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServiceHealthCollectionResponse.class, ServiceHealthCollectionPage.class, ServiceHealthCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ServiceHealth> postAsync(@Nonnull ServiceHealth newServiceHealth) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ServiceHealthRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newServiceHealth);
    }

    @Override
    @Nonnull
    public ServiceHealth post(@Nonnull ServiceHealth newServiceHealth) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ServiceHealthRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newServiceHealth);
    }

    @Nonnull
    public ServiceHealthCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ServiceHealthCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

