/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.SecureScore;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SecureScoreCollectionPage;
import com.microsoft.graph.requests.SecureScoreCollectionRequestBuilder;
import com.microsoft.graph.requests.SecureScoreCollectionResponse;
import com.microsoft.graph.requests.SecureScoreRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SecureScoreCollectionRequest
extends BaseEntityCollectionRequest<SecureScore, SecureScoreCollectionResponse, SecureScoreCollectionPage> {
    public SecureScoreCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecureScoreCollectionResponse.class, SecureScoreCollectionPage.class, SecureScoreCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<SecureScore> postAsync(@Nonnull SecureScore newSecureScore) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SecureScoreRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSecureScore);
    }

    @Override
    @Nonnull
    public SecureScore post(@Nonnull SecureScore newSecureScore) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SecureScoreRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSecureScore);
    }

    @Nonnull
    public SecureScoreCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SecureScoreCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

