/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Room;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.RoomCollectionPage;
import com.microsoft.graph.requests.RoomCollectionRequestBuilder;
import com.microsoft.graph.requests.RoomCollectionResponse;
import com.microsoft.graph.requests.RoomRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RoomCollectionRequest
extends BaseEntityCollectionRequest<Room, RoomCollectionResponse, RoomCollectionPage> {
    public RoomCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoomCollectionResponse.class, RoomCollectionPage.class, RoomCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Room> postAsync(@Nonnull Room newRoom) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoomRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newRoom);
    }

    @Override
    @Nonnull
    public Room post(@Nonnull Room newRoom) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoomRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newRoom);
    }

    @Nonnull
    public RoomCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public RoomCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

