/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.RoleDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.RoleDefinitionCollectionPage;
import com.microsoft.graph.requests.RoleDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.RoleDefinitionCollectionResponse;
import com.microsoft.graph.requests.RoleDefinitionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RoleDefinitionCollectionRequest
extends BaseEntityCollectionRequest<RoleDefinition, RoleDefinitionCollectionResponse, RoleDefinitionCollectionPage> {
    public RoleDefinitionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleDefinitionCollectionResponse.class, RoleDefinitionCollectionPage.class, RoleDefinitionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<RoleDefinition> postAsync(@Nonnull RoleDefinition newRoleDefinition) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoleDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newRoleDefinition);
    }

    @Override
    @Nonnull
    public RoleDefinition post(@Nonnull RoleDefinition newRoleDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoleDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newRoleDefinition);
    }

    @Nonnull
    public RoleDefinitionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public RoleDefinitionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

