/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.PrintConnector;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PrintConnectorCollectionResponse;
import com.microsoft.graph.requests.PrintConnectorCollectionWithReferencesPage;
import com.microsoft.graph.requests.PrintConnectorCollectionWithReferencesRequest;
import com.microsoft.graph.requests.PrintConnectorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.PrintConnectorReferenceRequestBuilder;
import com.microsoft.graph.requests.PrintConnectorWithReferenceRequest;
import com.microsoft.graph.requests.PrintConnectorWithReferenceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrintConnectorCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<PrintConnector, PrintConnectorWithReferenceRequest, PrintConnectorReferenceRequestBuilder, PrintConnectorWithReferenceRequestBuilder, PrintConnectorCollectionResponse, PrintConnectorCollectionWithReferencesPage, PrintConnectorCollectionWithReferencesRequest> {
    public PrintConnectorCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintConnectorCollectionResponse.class, PrintConnectorCollectionWithReferencesPage.class, PrintConnectorCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<PrintConnector> postAsync(@Nonnull PrintConnector newPrintConnector) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/print/connectors/" + newPrintConnector.id);
        return ((PrintConnectorWithReferenceRequest)new PrintConnectorWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newPrintConnector, body);
    }

    @Override
    @Nonnull
    public PrintConnector post(@Nonnull PrintConnector newPrintConnector) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/print/connectors/" + newPrintConnector.id);
        return ((PrintConnectorWithReferenceRequest)new PrintConnectorWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newPrintConnector, body);
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PrintConnectorCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

