/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.PlannerTask;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PlannerTaskCollectionPage;
import com.microsoft.graph.requests.PlannerTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.PlannerTaskCollectionResponse;
import com.microsoft.graph.requests.PlannerTaskRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlannerTaskCollectionRequest
extends BaseEntityCollectionRequest<PlannerTask, PlannerTaskCollectionResponse, PlannerTaskCollectionPage> {
    public PlannerTaskCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerTaskCollectionResponse.class, PlannerTaskCollectionPage.class, PlannerTaskCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<PlannerTask> postAsync(@Nonnull PlannerTask newPlannerTask) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPlannerTask);
    }

    @Override
    @Nonnull
    public PlannerTask post(@Nonnull PlannerTask newPlannerTask) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPlannerTask);
    }

    @Nonnull
    public PlannerTaskCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PlannerTaskCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

