/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.MobileAppContentFile;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.MobileAppContentFileCollectionPage;
import com.microsoft.graph.requests.MobileAppContentFileCollectionRequestBuilder;
import com.microsoft.graph.requests.MobileAppContentFileCollectionResponse;
import com.microsoft.graph.requests.MobileAppContentFileRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MobileAppContentFileCollectionRequest
extends BaseEntityCollectionRequest<MobileAppContentFile, MobileAppContentFileCollectionResponse, MobileAppContentFileCollectionPage> {
    public MobileAppContentFileCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppContentFileCollectionResponse.class, MobileAppContentFileCollectionPage.class, MobileAppContentFileCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<MobileAppContentFile> postAsync(@Nonnull MobileAppContentFile newMobileAppContentFile) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newMobileAppContentFile);
    }

    @Override
    @Nonnull
    public MobileAppContentFile post(@Nonnull MobileAppContentFile newMobileAppContentFile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileAppContentFile);
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentFileCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

