/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.MobileAppContent;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.MobileAppContentCollectionPage;
import com.microsoft.graph.requests.MobileAppContentCollectionRequestBuilder;
import com.microsoft.graph.requests.MobileAppContentCollectionResponse;
import com.microsoft.graph.requests.MobileAppContentRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MobileAppContentCollectionRequest
extends BaseEntityCollectionRequest<MobileAppContent, MobileAppContentCollectionResponse, MobileAppContentCollectionPage> {
    public MobileAppContentCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppContentCollectionResponse.class, MobileAppContentCollectionPage.class, MobileAppContentCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<MobileAppContent> postAsync(@Nonnull MobileAppContent newMobileAppContent) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newMobileAppContent);
    }

    @Override
    @Nonnull
    public MobileAppContent post(@Nonnull MobileAppContent newMobileAppContent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileAppContent);
    }

    @Nonnull
    public MobileAppContentCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public MobileAppContentCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

