/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ManagedEBook;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ManagedEBookCollectionPage;
import com.microsoft.graph.requests.ManagedEBookCollectionRequestBuilder;
import com.microsoft.graph.requests.ManagedEBookCollectionResponse;
import com.microsoft.graph.requests.ManagedEBookRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ManagedEBookCollectionRequest
extends BaseEntityCollectionRequest<ManagedEBook, ManagedEBookCollectionResponse, ManagedEBookCollectionPage> {
    public ManagedEBookCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedEBookCollectionResponse.class, ManagedEBookCollectionPage.class, ManagedEBookCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ManagedEBook> postAsync(@Nonnull ManagedEBook newManagedEBook) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedEBookRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newManagedEBook);
    }

    @Override
    @Nonnull
    public ManagedEBook post(@Nonnull ManagedEBook newManagedEBook) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedEBookRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedEBook);
    }

    @Nonnull
    public ManagedEBookCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ManagedEBookCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

