/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.LocalizedNotificationMessage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.LocalizedNotificationMessageCollectionPage;
import com.microsoft.graph.requests.LocalizedNotificationMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.LocalizedNotificationMessageCollectionResponse;
import com.microsoft.graph.requests.LocalizedNotificationMessageRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalizedNotificationMessageCollectionRequest
extends BaseEntityCollectionRequest<LocalizedNotificationMessage, LocalizedNotificationMessageCollectionResponse, LocalizedNotificationMessageCollectionPage> {
    public LocalizedNotificationMessageCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, LocalizedNotificationMessageCollectionResponse.class, LocalizedNotificationMessageCollectionPage.class, LocalizedNotificationMessageCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<LocalizedNotificationMessage> postAsync(@Nonnull LocalizedNotificationMessage newLocalizedNotificationMessage) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LocalizedNotificationMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newLocalizedNotificationMessage);
    }

    @Override
    @Nonnull
    public LocalizedNotificationMessage post(@Nonnull LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LocalizedNotificationMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newLocalizedNotificationMessage);
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public LocalizedNotificationMessageCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

