/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Invitation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.InvitationCollectionPage;
import com.microsoft.graph.requests.InvitationCollectionRequestBuilder;
import com.microsoft.graph.requests.InvitationCollectionResponse;
import com.microsoft.graph.requests.InvitationRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InvitationCollectionRequest
extends BaseEntityCollectionRequest<Invitation, InvitationCollectionResponse, InvitationCollectionPage> {
    public InvitationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, InvitationCollectionResponse.class, InvitationCollectionPage.class, InvitationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Invitation> postAsync(@Nonnull Invitation newInvitation) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new InvitationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newInvitation);
    }

    @Override
    @Nonnull
    public Invitation post(@Nonnull Invitation newInvitation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new InvitationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newInvitation);
    }

    @Nonnull
    public InvitationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public InvitationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

