/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.EventCollectionPage;
import com.microsoft.graph.requests.EventCollectionRequestBuilder;
import com.microsoft.graph.requests.EventCollectionResponse;
import com.microsoft.graph.requests.EventRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EventCollectionRequest
extends BaseEntityCollectionRequest<Event, EventCollectionResponse, EventCollectionPage> {
    public EventCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EventCollectionResponse.class, EventCollectionPage.class, EventCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Event> postAsync(@Nonnull Event newEvent) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newEvent);
    }

    @Override
    @Nonnull
    public Event post(@Nonnull Event newEvent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEvent);
    }

    @Nonnull
    public EventCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public EventCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public EventCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

