/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.EducationUser;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EducationUserReferenceRequest
extends BaseReferenceRequest<EducationUser> {
    public EducationUserReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationUser.class);
    }

    @Nonnull
    public EducationUserReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public EducationUserReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<EducationUser> putAsync(@Nonnull EducationUser srcEducationUser) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", new JsonPrimitive(this.getClient().getServiceRoot() + "/education/users/" + srcEducationUser.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public EducationUser put(@Nonnull EducationUser srcEducationUser) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", new JsonPrimitive(this.getClient().getServiceRoot() + "/education/users/" + srcEducationUser.id));
        return (EducationUser)this.send(HttpMethod.PUT, payload);
    }
}

