/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.DirectoryRole;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DirectoryRoleCollectionPage;
import com.microsoft.graph.requests.DirectoryRoleCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryRoleCollectionResponse;
import com.microsoft.graph.requests.DirectoryRoleRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryRoleCollectionRequest
extends BaseEntityCollectionRequest<DirectoryRole, DirectoryRoleCollectionResponse, DirectoryRoleCollectionPage> {
    public DirectoryRoleCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryRoleCollectionResponse.class, DirectoryRoleCollectionPage.class, DirectoryRoleCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DirectoryRole> postAsync(@Nonnull DirectoryRole newDirectoryRole) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryRoleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDirectoryRole);
    }

    @Override
    @Nonnull
    public DirectoryRole post(@Nonnull DirectoryRole newDirectoryRole) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryRoleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryRole);
    }

    @Nonnull
    public DirectoryRoleCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

