/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.DetectedApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DetectedAppCollectionPage;
import com.microsoft.graph.requests.DetectedAppCollectionRequestBuilder;
import com.microsoft.graph.requests.DetectedAppCollectionResponse;
import com.microsoft.graph.requests.DetectedAppRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DetectedAppCollectionRequest
extends BaseEntityCollectionRequest<DetectedApp, DetectedAppCollectionResponse, DetectedAppCollectionPage> {
    public DetectedAppCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DetectedAppCollectionResponse.class, DetectedAppCollectionPage.class, DetectedAppCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DetectedApp> postAsync(@Nonnull DetectedApp newDetectedApp) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DetectedAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDetectedApp);
    }

    @Override
    @Nonnull
    public DetectedApp post(@Nonnull DetectedApp newDetectedApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DetectedAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDetectedApp);
    }

    @Nonnull
    public DetectedAppCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DetectedAppCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

