/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConversationMemberReferenceRequest
extends BaseReferenceRequest<ConversationMember> {
    public ConversationMemberReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConversationMember.class);
    }

    @Nonnull
    public ConversationMemberReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ConversationMemberReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<ConversationMember> putAsync(@Nonnull ConversationMember srcConversationMember) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", new JsonPrimitive(this.getClient().getServiceRoot() + "/directory/deletedItemsAsUser/{id}/chats/{id}/members/" + srcConversationMember.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public ConversationMember put(@Nonnull ConversationMember srcConversationMember) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", new JsonPrimitive(this.getClient().getServiceRoot() + "/directory/deletedItemsAsUser/{id}/chats/{id}/members/" + srcConversationMember.id));
        return (ConversationMember)this.send(HttpMethod.PUT, payload);
    }
}

