/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ClaimsMappingPolicy;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClaimsMappingPolicyReferenceRequest
extends BaseReferenceRequest<ClaimsMappingPolicy> {
    public ClaimsMappingPolicyReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ClaimsMappingPolicy.class);
    }

    @Nonnull
    public ClaimsMappingPolicyReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ClaimsMappingPolicyReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<ClaimsMappingPolicy> putAsync(@Nonnull ClaimsMappingPolicy srcClaimsMappingPolicy) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", new JsonPrimitive(this.getClient().getServiceRoot() + "/policies/claimsMappingPolicies/" + srcClaimsMappingPolicy.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public ClaimsMappingPolicy put(@Nonnull ClaimsMappingPolicy srcClaimsMappingPolicy) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", new JsonPrimitive(this.getClient().getServiceRoot() + "/policies/claimsMappingPolicies/" + srcClaimsMappingPolicy.id));
        return (ClaimsMappingPolicy)this.send(HttpMethod.PUT, payload);
    }
}

