/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ChecklistItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChecklistItemCollectionPage;
import com.microsoft.graph.requests.ChecklistItemCollectionRequestBuilder;
import com.microsoft.graph.requests.ChecklistItemCollectionResponse;
import com.microsoft.graph.requests.ChecklistItemRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChecklistItemCollectionRequest
extends BaseEntityCollectionRequest<ChecklistItem, ChecklistItemCollectionResponse, ChecklistItemCollectionPage> {
    public ChecklistItemCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChecklistItemCollectionResponse.class, ChecklistItemCollectionPage.class, ChecklistItemCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ChecklistItem> postAsync(@Nonnull ChecklistItem newChecklistItem) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChecklistItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newChecklistItem);
    }

    @Override
    @Nonnull
    public ChecklistItem post(@Nonnull ChecklistItem newChecklistItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChecklistItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChecklistItem);
    }

    @Nonnull
    public ChecklistItemCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

