/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ActivityHistoryItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ActivityHistoryItemCollectionPage;
import com.microsoft.graph.requests.ActivityHistoryItemCollectionRequestBuilder;
import com.microsoft.graph.requests.ActivityHistoryItemCollectionResponse;
import com.microsoft.graph.requests.ActivityHistoryItemRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ActivityHistoryItemCollectionRequest
extends BaseEntityCollectionRequest<ActivityHistoryItem, ActivityHistoryItemCollectionResponse, ActivityHistoryItemCollectionPage> {
    public ActivityHistoryItemCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ActivityHistoryItemCollectionResponse.class, ActivityHistoryItemCollectionPage.class, ActivityHistoryItemCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ActivityHistoryItem> postAsync(@Nonnull ActivityHistoryItem newActivityHistoryItem) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ActivityHistoryItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newActivityHistoryItem);
    }

    @Override
    @Nonnull
    public ActivityHistoryItem post(@Nonnull ActivityHistoryItem newActivityHistoryItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ActivityHistoryItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newActivityHistoryItem);
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ActivityHistoryItemCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

