/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.logger;

import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultLogger
implements ILogger {
    private LoggerLevel level = LoggerLevel.ERROR;
    private static final Logger LOGGER = Logger.getLogger("global");

    @Override
    public void setLoggingLevel(@Nonnull LoggerLevel level) {
        LOGGER.info("Setting logging level to " + (Object)((Object)level));
        this.level = Objects.requireNonNull(level, "parameter level cannot be null");
    }

    @Override
    @Nonnull
    public LoggerLevel getLoggingLevel() {
        return this.level;
    }

    @Nullable
    private String getTag() {
        try {
            StringBuilder sb = new StringBuilder();
            int callerStackDepth = 4;
            String className = Thread.currentThread().getStackTrace()[4].getClassName();
            sb.append(className.substring(className.lastIndexOf(46) + 1));
            sb.append("[");
            sb.append(Thread.currentThread().getStackTrace()[4].getMethodName());
            sb.append("] - ");
            sb.append(Thread.currentThread().getStackTrace()[4].getLineNumber());
            return sb.toString();
        }
        catch (Exception ex) {
            LOGGER.warning(ex.getMessage());
            return null;
        }
    }

    @Override
    public void logDebug(@Nonnull String message) {
        Objects.requireNonNull(message, "parameter message cannot be null");
        if (this.level == LoggerLevel.DEBUG) {
            for (String line : message.split("\n")) {
                LOGGER.info(line);
            }
        }
    }

    @Override
    public void logError(@Nonnull String message, @Nonnull Throwable throwable) {
        Objects.requireNonNull(message, "parameter message cannot be null");
        Objects.requireNonNull(throwable, "parameter throwable cannot be null");
        switch (this.level) {
            default: 
        }
        for (String line : message.split("\n")) {
            LOGGER.severe(this.getTag() + line);
        }
        LOGGER.severe("Throwable detail: " + throwable);
    }
}

