/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.CoreHttpCallbackFutureWrapper;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IStatefulResponseHandler;
import com.microsoft.graph.httpcore.middlewareoption.RedirectOptions;
import com.microsoft.graph.httpcore.middlewareoption.RetryOptions;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.serializer.ISerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;

public class CoreHttpProvider
implements IHttpProvider<Request> {
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final Charset JSON_ENCODING = StandardCharsets.UTF_8;
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    private final ISerializer serializer;
    private final ILogger logger;
    private OkHttpClient corehttpClient;

    @SuppressFBWarnings
    public CoreHttpProvider(@Nonnull ISerializer serializer, @Nonnull ILogger logger, @Nonnull OkHttpClient httpClient) {
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        Objects.requireNonNull(serializer, "parameter serializer cannot be null");
        Objects.requireNonNull(httpClient, "parameter httpClient cannot be null");
        this.serializer = serializer;
        this.logger = logger;
        this.corehttpClient = httpClient;
    }

    @Override
    @Nullable
    public ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    @Nonnull
    public <Result, Body> CompletableFuture<Result> sendAsync(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable Body serializable) {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(resultClass, "parameter resultClass cannot be null");
        return this.sendAsync(request, resultClass, serializable, null);
    }

    @Override
    @Nonnull
    public <Result, BodyType, DeserializeType> CompletableFuture<Result> sendAsync(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable BodyType serializable, @Nullable IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(resultClass, "parameter resultClass cannot be null");
        return this.sendRequestAsyncInternal(request, resultClass, serializable, handler);
    }

    @Override
    @Nullable
    public <Result, Body> Result send(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable Body serializable) throws ClientException {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(resultClass, "parameter resultClass cannot be null");
        return this.send(request, resultClass, serializable, (IStatefulResponseHandler<Result, DeserializeType>)null);
    }

    @Override
    @Nullable
    public <Result, Body, DeserializeType> Result send(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable Body serializable, @Nullable IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(resultClass, "parameter resultClass cannot be null");
        return this.sendRequestInternal(request, resultClass, serializable, handler);
    }

    @Override
    @Nullable
    public <Result, Body> Request getHttpRequest(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable Body serializable) throws ClientException {
        byte[] bytesToWrite;
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(resultClass, "parameter resultClass cannot be null");
        int defaultBufferSize = 4096;
        URL requestUrl = request.getRequestUrl();
        this.logger.logDebug("Starting to send request, URL " + requestUrl.toString());
        RedirectOptions redirectOptions = request.getMaxRedirects() == 5 && request.getShouldRedirect().equals(RedirectOptions.DEFAULT_SHOULD_REDIRECT) ? null : new RedirectOptions(request.getMaxRedirects(), request.getShouldRedirect());
        RetryOptions retryOptions = request.getMaxRetries() == 3 && request.getDelay() == 3L && request.getShouldRetry().equals(RetryOptions.DEFAULT_SHOULD_RETRY) ? null : new RetryOptions(request.getShouldRetry(), request.getMaxRetries(), request.getDelay());
        Request coreHttpRequest = this.convertIHttpRequestToOkHttpRequest(request);
        Request.Builder corehttpRequestBuilder = coreHttpRequest.newBuilder();
        if (redirectOptions != null) {
            corehttpRequestBuilder = corehttpRequestBuilder.tag(RedirectOptions.class, redirectOptions);
        }
        if (retryOptions != null) {
            corehttpRequestBuilder = corehttpRequestBuilder.tag(RetryOptions.class, retryOptions);
        }
        String contenttype = null;
        this.logger.logDebug("Request Method " + request.getHttpMethod().toString());
        List<HeaderOption> requestHeaders = request.getHeaders();
        for (HeaderOption headerOption : requestHeaders) {
            if (!headerOption.getName().equalsIgnoreCase(CONTENT_TYPE_HEADER_NAME)) continue;
            contenttype = headerOption.getValue().toString();
            break;
        }
        corehttpRequestBuilder.addHeader("Accept", "*/*");
        if (serializable == null) {
            bytesToWrite = request.getHttpMethod() == HttpMethod.POST ? new byte[]{} : null;
        } else if (serializable instanceof byte[]) {
            this.logger.logDebug("Sending byte[] as request body");
            bytesToWrite = (byte[])serializable;
            if (!CoreHttpProvider.hasHeader(requestHeaders, CONTENT_TYPE_HEADER_NAME)) {
                corehttpRequestBuilder.addHeader(CONTENT_TYPE_HEADER_NAME, BINARY_CONTENT_TYPE);
                contenttype = BINARY_CONTENT_TYPE;
            }
        } else {
            this.logger.logDebug("Sending " + serializable.getClass().getName() + " as request body");
            String serializeObject = null;
            serializeObject = "text/plain".equals(contenttype) && serializable instanceof String ? (String)serializable : this.serializer.serializeObject(serializable);
            if (serializeObject == null) {
                throw new ClientException("Error during serialization of request body, the result was null", null);
            }
            bytesToWrite = serializeObject.getBytes(JSON_ENCODING);
            if (!CoreHttpProvider.hasHeader(requestHeaders, CONTENT_TYPE_HEADER_NAME)) {
                corehttpRequestBuilder.addHeader(CONTENT_TYPE_HEADER_NAME, JSON_CONTENT_TYPE);
                contenttype = JSON_CONTENT_TYPE;
            }
        }
        RequestBody requestBody = null;
        if (bytesToWrite != null) {
            final String mediaContentType = contenttype;
            requestBody = new RequestBody(){

                @Override
                public long contentLength() throws IOException {
                    return bytesToWrite.length;
                }

                @Override
                public void writeTo(BufferedSink sink2) throws IOException {
                    int writtenSoFar = 0;
                    try (OutputStream out = sink2.outputStream();
                         BufferedOutputStream bos = new BufferedOutputStream(out);){
                        int toWrite;
                        do {
                            toWrite = Math.min(4096, bytesToWrite.length - writtenSoFar);
                            bos.write(bytesToWrite, writtenSoFar, toWrite);
                            writtenSoFar += toWrite;
                        } while (toWrite > 0);
                    }
                }

                @Override
                public MediaType contentType() {
                    if (mediaContentType == null || mediaContentType.isEmpty()) {
                        return null;
                    }
                    return MediaType.parse(mediaContentType);
                }
            };
        }
        corehttpRequestBuilder.method(request.getHttpMethod().toString(), requestBody);
        return corehttpRequestBuilder.build();
    }

    @Nonnull
    private <Result, Body, DeserializeType> CompletableFuture<Result> sendRequestAsyncInternal(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable Body serializable, @Nullable IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        Object coreHttpRequest = this.getHttpRequest(request, (Class)resultClass, (Object)serializable);
        Call call = this.corehttpClient.newCall((Request)coreHttpRequest);
        CoreHttpCallbackFutureWrapper wrapper = new CoreHttpCallbackFutureWrapper(call);
        call.enqueue(wrapper);
        return wrapper.future.thenApply(r -> this.processResponse((Response)r, request, resultClass, serializable, handler));
    }

    @Nullable
    private <Result, Body, DeserializeType> Result sendRequestInternal(@Nonnull IHttpRequest request, @Nonnull Class<Result> resultClass, @Nullable Body serializable, @Nullable IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        Object coreHttpRequest = this.getHttpRequest(request, (Class)resultClass, (Object)serializable);
        try {
            Response response = this.corehttpClient.newCall((Request)coreHttpRequest).execute();
            return this.processResponse(response, request, resultClass, serializable, handler);
        }
        catch (IOException ex) {
            throw new ClientException("Error executing the request", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Result, Body, DeserializeType> Result processResponse(Response response, IHttpRequest request, Class<Result> resultClass, Body serializable, IStatefulResponseHandler<Result, DeserializeType> handler) {
        if (response == null) {
            return null;
        }
        ResponseBody body = response.body();
        try {
            InputStream in = null;
            boolean isBinaryStreamInput = false;
            try {
                this.logger.logDebug(String.format(Locale.ROOT, "Response code %d, %s", response.code(), response.message()));
                if (handler != null) {
                    this.logger.logDebug("StatefulResponse is handling the HTTP response.");
                    Result Result2 = handler.generateResult(request, response, this.serializer, this.logger);
                    return Result2;
                }
                if (response.code() >= 400 && body != null) {
                    this.logger.logDebug("Handling error response");
                    in = body.byteStream();
                    this.handleErrorResponse(request, serializable, response);
                }
                Map<String, List<String>> responseHeaders = response.headers().toMultimap();
                if (response.code() == 204 || response.code() == 304) {
                    this.logger.logDebug("Handling response with no body");
                    Result e = this.handleEmptyResponse(responseHeaders, resultClass);
                    return e;
                }
                if (response.code() == 202) {
                    this.logger.logDebug("Handling accepted response");
                    Result e = this.handleEmptyResponse(responseHeaders, resultClass);
                    return e;
                }
                if (body == null || body.contentLength() == 0L) {
                    Result e = null;
                    return e;
                }
                in = new BufferedInputStream(body.byteStream());
                MediaType contentType = body.contentType();
                if (contentType != null && contentType.subtype().contains("json") && resultClass != InputStream.class) {
                    this.logger.logDebug("Response json");
                    Result Result3 = this.handleJsonResponse(in, responseHeaders, resultClass);
                    return Result3;
                }
                if (resultClass == InputStream.class) {
                    this.logger.logDebug("Response binary");
                    isBinaryStreamInput = true;
                    InputStream inputStream2 = this.handleBinaryStream(in);
                    return (Result)inputStream2;
                }
                if (contentType != null && resultClass != InputStream.class && contentType.type().contains("text") && contentType.subtype().contains("plain")) {
                    Result Result4 = this.handleRawResponse(in, resultClass);
                    return Result4;
                }
                Result Result5 = null;
                return Result5;
            }
            finally {
                if (!isBinaryStreamInput) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (body != null) {
                            body.close();
                        }
                    }
                    catch (IOException e) {
                        this.logger.logError(e.getMessage(), e);
                    }
                    response.close();
                }
            }
        }
        catch (GraphServiceException ex) {
            this.logger.logError("Graph service exception", ex);
            throw ex;
        }
        catch (Exception ex) {
            ClientException clientException = new ClientException("Error during http request", ex);
            this.logger.logError("Error during http request", clientException);
            throw clientException;
        }
    }

    private <Body> void handleErrorResponse(IHttpRequest request, Body serializable, Response response) throws IOException {
        throw GraphServiceException.createFromResponse(request, serializable, this.serializer, response, this.logger);
    }

    private InputStream handleBinaryStream(InputStream in) {
        return in;
    }

    private <Result> Result handleJsonResponse(InputStream in, Map<String, List<String>> responseHeaders, Class<Result> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.serializer.deserializeObject(in, clazz, responseHeaders);
    }

    private <Result> Result handleRawResponse(InputStream in, Class<Result> clazz) {
        if (clazz == null) {
            return null;
        }
        String rawText = CoreHttpProvider.streamToString(in);
        if (clazz == Long.class) {
            try {
                return (Result)Long.valueOf(rawText);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private <Result> Result handleEmptyResponse(Map<String, List<String>> responseHeaders, Class<Result> clazz) throws UnsupportedEncodingException {
        Result result = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream("{}".getBytes(JSON_ENCODING));){
            result = this.handleJsonResponse(in, responseHeaders, clazz);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Request convertIHttpRequestToOkHttpRequest(IHttpRequest request) {
        if (request != null) {
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(request.getRequestUrl());
            for (HeaderOption header : request.getHeaders()) {
                requestBuilder.addHeader(header.getName(), header.getValue().toString());
            }
            return requestBuilder.build();
        }
        return null;
    }

    @Nullable
    public static String streamToString(@Nonnull InputStream input) {
        Objects.requireNonNull(input, "parameter input cannot be null");
        String endOfFile = "\\A";
        try (Scanner scanner = new Scanner(input, JSON_ENCODING.name());){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                String string = scanner.next();
                return string;
            }
            String string = "";
            return string;
        }
    }

    @VisibleForTesting
    static boolean hasHeader(List<HeaderOption> headers, String header) {
        for (HeaderOption option : headers) {
            if (!option.getName().equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    @SuppressFBWarnings
    public ILogger getLogger() {
        return this.logger;
    }
}

