/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseRequestBuilder<T>
implements IRequestBuilder {
    private final IBaseClient<?> client;
    private final String requestUrl;
    private final List<Option> options = new ArrayList<Option>();

    public BaseRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> options) {
        this.requestUrl = Objects.requireNonNull(requestUrl, "parameter requestUrl cannot be null");
        this.client = Objects.requireNonNull(client, "parameter client cannot be null");
        if (options != null) {
            this.options.addAll(options);
        }
    }

    @Override
    @Nullable
    @SuppressFBWarnings
    public IBaseClient<?> getClient() {
        return this.client;
    }

    @Override
    @Nullable
    public String getRequestUrl() {
        return this.requestUrl;
    }

    @Nonnull
    public List<? extends Option> getOptions(Option ... requestOptions) {
        return Collections.unmodifiableList(requestOptions != null && requestOptions.length > 0 ? Arrays.asList(requestOptions) : this.options);
    }

    @Override
    @Nonnull
    public String getRequestUrlWithAdditionalSegment(@Nonnull String urlSegment) {
        Objects.requireNonNull(urlSegment, "parameter urlSegment cannot be null");
        return this.requestUrl + "/" + urlSegment;
    }

    @Nonnull
    public String getRequestUrlWithAdditionalParameter(@Nonnull String parameter) {
        Objects.requireNonNull(parameter, "parameter cannot be null");
        return this.requestUrl + "('" + parameter + "')";
    }
}

