/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream.util;

import com.bea.xml.stream.util.Stack;
import com.bea.xml.stream.util.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SymbolTable {
    private int depth = 0;
    private Stack table = new Stack();
    private Map values = new HashMap();

    public void clear() {
        this.depth = 0;
        this.table.clear();
        this.values.clear();
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean withinElement() {
        return this.depth > 0;
    }

    public void put(String name, String value) {
        this.table.push(new Symbol(name, value, this.depth));
        if (!this.values.containsKey(name)) {
            Stack valueStack = new Stack();
            valueStack.push(value);
            this.values.put(name, valueStack);
        } else {
            Stack valueStack = (Stack)this.values.get(name);
            valueStack.push(value);
        }
    }

    public String get(String name) {
        Stack valueStack = (Stack)this.values.get(name);
        if (valueStack == null || valueStack.isEmpty()) {
            return null;
        }
        return (String)valueStack.peek();
    }

    public Set getAll(String name) {
        HashSet<String> result = new HashSet<String>();
        Iterator i = this.table.iterator();
        while (i.hasNext()) {
            Symbol s2 = (Symbol)i.next();
            if (!name.equals(s2.getName())) continue;
            result.add(s2.getValue());
        }
        return result;
    }

    public void openScope() {
        ++this.depth;
    }

    public void closeScope() {
        Symbol symbol = (Symbol)this.table.peek();
        int symbolDepth = symbol.depth;
        while (symbolDepth == this.depth && !this.table.isEmpty()) {
            symbol = (Symbol)this.table.pop();
            Stack valueStack = (Stack)this.values.get(symbol.name);
            valueStack.pop();
            if (this.table.isEmpty()) break;
            symbol = (Symbol)this.table.peek();
            symbolDepth = symbol.depth;
        }
        --this.depth;
    }

    public String toString() {
        Iterator i = this.table.iterator();
        String retVal = "";
        while (i.hasNext()) {
            Symbol symbol = (Symbol)i.next();
            retVal = retVal + symbol + "\n";
        }
        return retVal;
    }

    public static void main(String[] args2) throws Exception {
        SymbolTable st = new SymbolTable();
        st.openScope();
        st.put("x", "foo");
        st.put("y", "bar");
        System.out.println("1 x:" + st.get("x"));
        System.out.println("1 y:" + st.get("y"));
        st.openScope();
        st.put("x", "bar");
        st.put("y", "foo");
        st.openScope();
        st.put("x", "barbie");
        st.openScope();
        st.closeScope();
        System.out.println("3 x:" + st.get("x"));
        st.closeScope();
        System.out.println("2 x:" + st.get("x"));
        System.out.println("2 y:" + st.get("y"));
        System.out.print(st);
        st.closeScope();
        System.out.println("1 x:" + st.get("x"));
        System.out.println("1 y:" + st.get("y"));
        st.closeScope();
        System.out.print(st);
    }
}

