/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;

public class SynchronizedAccessor<T> {
    private final AtomicBoolean wip;
    private volatile T cache;
    private final ReplayProcessor<T> replayProcessor = ReplayProcessor.create(1);
    private final FluxSink<T> sink = this.replayProcessor.sink(FluxSink.OverflowStrategy.BUFFER);
    private final Supplier<T> supplier;

    public SynchronizedAccessor(Supplier<T> supplier) {
        this.wip = new AtomicBoolean(false);
        this.supplier = supplier;
    }

    public Mono<T> getValue() {
        return Mono.defer(() -> {
            if (this.cache != null) {
                return Mono.just(this.cache);
            }
            if (!this.wip.getAndSet(true)) {
                try {
                    this.cache = this.supplier.get();
                    this.sink.next(this.cache);
                }
                catch (Exception e) {
                    this.sink.error(e);
                }
            }
            return this.replayProcessor.next();
        });
    }
}

