/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import reactor.core.publisher.Mono;

public class AuthenticationRecord {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="authority")
    private String authority;
    @JsonProperty(value="homeAccountId")
    private String homeAccountId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="clientId")
    private String clientId;

    AuthenticationRecord() {
    }

    public AuthenticationRecord(IAuthenticationResult authenticationResult, String tenantId, String clientId) {
        this.authority = authenticationResult.account().environment();
        this.homeAccountId = authenticationResult.account().homeAccountId();
        this.username = authenticationResult.account().username();
        this.tenantId = tenantId;
        this.clientId = clientId;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public Mono<OutputStream> serialize(OutputStream outputStream2) {
        return Mono.defer(() -> {
            try {
                OBJECT_MAPPER.writeValue(outputStream2, (Object)this);
            }
            catch (IOException e) {
                return Mono.error(e);
            }
            return Mono.just(outputStream2);
        });
    }

    public static Mono<AuthenticationRecord> deserialize(InputStream inputStream2) {
        return Mono.defer(() -> {
            AuthenticationRecord authenticationRecord;
            try {
                authenticationRecord = OBJECT_MAPPER.readValue(inputStream2, AuthenticationRecord.class);
            }
            catch (IOException e) {
                return Mono.error(e);
            }
            return Mono.just(authenticationRecord);
        });
    }
}

