/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AppServiceMsiCredential;
import com.azure.identity.ArcIdentityCredential;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.ServiceFabricMsiCredential;
import com.azure.identity.VirtualMachineMsiCredential;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private final ManagedIdentityServiceCredential managedIdentityServiceCredential;
    private final ClientLogger logger = new ClientLogger(ManagedIdentityCredential.class);
    static final String PROPERTY_IMDS_ENDPOINT = "IMDS_ENDPOINT";
    static final String PROPERTY_IDENTITY_SERVER_THUMBPRINT = "IDENTITY_SERVER_THUMBPRINT";

    ManagedIdentityCredential(String clientId, IdentityClientOptions identityClientOptions) {
        IdentityClient identityClient = new IdentityClientBuilder().clientId(clientId).identityClientOptions(identityClientOptions).build();
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.managedIdentityServiceCredential = configuration.contains("MSI_ENDPOINT") ? new AppServiceMsiCredential(clientId, identityClient) : (configuration.contains("IDENTITY_ENDPOINT") ? (configuration.contains("IDENTITY_HEADER") ? (configuration.get(PROPERTY_IDENTITY_SERVER_THUMBPRINT) != null ? new ServiceFabricMsiCredential(clientId, identityClient) : new VirtualMachineMsiCredential(clientId, identityClient)) : (configuration.get(PROPERTY_IMDS_ENDPOINT) != null ? new ArcIdentityCredential(clientId, identityClient) : new VirtualMachineMsiCredential(clientId, identityClient))) : new VirtualMachineMsiCredential(clientId, identityClient));
        LoggingUtil.logAvailableEnvironmentVariables(this.logger, configuration);
    }

    public String getClientId() {
        return this.managedIdentityServiceCredential.getClientId();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.managedIdentityServiceCredential == null) {
            return Mono.error(this.logger.logExceptionAsError(new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. The Target Azure platform could not be determined from environment variables.")));
        }
        return this.managedIdentityServiceCredential.authenticate(request).doOnSuccess(t -> this.logger.info(String.format("Azure Identity => Managed Identity environment: %s", this.managedIdentityServiceCredential.getEnvironment()))).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error));
    }
}

