/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.UsernamePasswordCredential;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import reactor.core.publisher.Mono;

public class EnvironmentCredential
implements TokenCredential {
    private final Configuration configuration;
    private final ClientLogger logger = new ClientLogger(EnvironmentCredential.class);
    private final TokenCredential tokenCredential;

    EnvironmentCredential(IdentityClientOptions identityClientOptions) {
        this.configuration = Configuration.getGlobalConfiguration().clone();
        TokenCredential targetCredential = null;
        String clientId = this.configuration.get("AZURE_CLIENT_ID");
        String tenantId = this.configuration.get("AZURE_TENANT_ID");
        String clientSecret = this.configuration.get("AZURE_CLIENT_SECRET");
        String certPath = this.configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
        String username = this.configuration.get("AZURE_USERNAME");
        String password = this.configuration.get("AZURE_PASSWORD");
        ValidationUtil.validateTenantIdCharacterRange(this.getClass().getSimpleName(), tenantId);
        LoggingUtil.logAvailableEnvironmentVariables(this.logger, this.configuration);
        if (this.verifyNotNull(clientId)) {
            if (this.verifyNotNull(tenantId)) {
                if (this.verifyNotNull(clientSecret)) {
                    this.logger.info("Azure Identity => EnvironmentCredential invoking ClientSecretCredential");
                    targetCredential = new ClientSecretCredential(tenantId, clientId, clientSecret, identityClientOptions);
                } else if (this.verifyNotNull(certPath)) {
                    this.logger.info("Azure Identity => EnvironmentCredential invoking ClientCertificateCredential");
                    targetCredential = new ClientCertificateCredential(tenantId, clientId, certPath, null, null, identityClientOptions);
                } else {
                    this.logger.error("Azure Identity => ERROR in EnvironmentCredential: Failed to create a ClientSecretCredential or ClientCertificateCredential. Missing required environment variable either {} or {}", "AZURE_CLIENT_SECRET", "AZURE_CLIENT_CERTIFICATE_PATH");
                }
            } else if (this.verifyNotNull(clientSecret) || this.verifyNotNull(certPath)) {
                this.logger.error("Azure Identity => ERROR in EnvironmentCredential: Failed to create a ClientSecretCredential or ClientCertificateCredential. Missing required environment variable {}", "AZURE_TENANT_ID");
            }
            if (targetCredential == null && this.verifyNotNull(username, password)) {
                this.logger.info("Azure Identity => EnvironmentCredential invoking UsernamePasswordCredential");
                targetCredential = new UsernamePasswordCredential(clientId, tenantId, username, password, identityClientOptions);
            } else if (this.verifyNotNull(username) ^ this.verifyNotNull(password)) {
                this.logger.error("Azure Identity => ERROR in EnvironmentCredential: Failed to create a UsernamePasswordCredential. Missing required environment variable {}", username == null ? "AZURE_USERNAME" : "AZURE_PASSWORD");
            }
            if (targetCredential == null) {
                String msg = String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to determine an authentication scheme based on the available environment variables. Please specify %1$s and %2$s to authenticate through a ClientSecretCredential; %1$s and %3$s to authenticate through a ClientCertificateCredential; or %4$s and %5$s to authenticate through a UserPasswordCredential.", "AZURE_TENANT_ID", "AZURE_CLIENT_SECRET", "AZURE_CLIENT_CERTIFICATE_PATH", "AZURE_USERNAME", "AZURE_PASSWORD");
                this.logger.error(msg);
            }
        } else {
            this.logger.error("Azure Identity => ERROR in EnvironmentCredential: Missing required environment variable {}", "AZURE_CLIENT_ID");
        }
        this.tokenCredential = targetCredential;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.tokenCredential == null) {
            return Mono.error(this.logger.logExceptionAsError(new CredentialUnavailableException("EnvironmentCredential authentication unavailable. Environment variables are not fully configured.")));
        }
        return this.tokenCredential.getToken(request);
    }

    private boolean verifyNotNull(String ... configs) {
        for (String config : configs) {
            if (config != null) continue;
            return false;
        }
        return true;
    }
}

