/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;

final class FlatteningDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private static final long serialVersionUID = -2133095337545715498L;
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;

    protected FlatteningDeserializer(Class<?> vc, JsonDeserializer<?> defaultDeserializer, ObjectMapper mapper) {
        super(vc);
        this.defaultDeserializer = defaultDeserializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (beanDesc.getBeanClass().getAnnotation(JsonFlatten.class) != null) {
                    return new FlatteningDeserializer(beanDesc.getBeanClass(), deserializer, mapper);
                }
                return deserializer;
            }
        });
        return module;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext cxt, TypeDeserializer tDeserializer) throws IOException {
        JsonNode currentJsonNode = (JsonNode)this.mapper.readTree(jp);
        Class<?> tClass = this.defaultDeserializer.handledType();
        for (Class<?> c : TypeUtil.getAllClasses(tClass)) {
            String typeIdOnWire;
            JsonNode typeIdValue;
            String typeId;
            JsonTypeInfo typeInfo = c.getAnnotation(JsonTypeInfo.class);
            if (typeInfo == null || !FlatteningDeserializer.containsDot(typeId = typeInfo.property()) || (typeIdValue = ((ObjectNode)currentJsonNode).remove(typeIdOnWire = FlatteningDeserializer.unescapeEscapedDots(typeId))) == null) continue;
            ((ObjectNode)currentJsonNode).set(typeId, typeIdValue);
        }
        return tDeserializer.deserializeTypedFromAny(FlatteningDeserializer.newJsonParserForNode(currentJsonNode), cxt);
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext cxt) throws IOException {
        JsonNode currentJsonNode = (JsonNode)this.mapper.readTree(jp);
        if (currentJsonNode.isNull()) {
            currentJsonNode = this.mapper.getNodeFactory().objectNode();
        }
        Class<?> tClass = this.defaultDeserializer.handledType();
        for (Class<Object> clazz : TypeUtil.getAllClasses(tClass)) {
            if (clazz.isAssignableFrom(Object.class)) continue;
            for (Field classField : clazz.getDeclaredFields()) {
                FlatteningDeserializer.handleFlatteningForField(classField, currentJsonNode);
            }
        }
        return this.defaultDeserializer.deserialize(FlatteningDeserializer.newJsonParserForNode(currentJsonNode), cxt);
    }

    @Override
    public void resolve(DeserializationContext cxt) throws JsonMappingException {
        if (this.defaultDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)this.defaultDeserializer)).resolve(cxt);
        }
    }

    private static void handleFlatteningForField(Field classField, JsonNode jsonNode) {
        JsonProperty jsonProperty = classField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            String jsonPropValue = jsonProperty.value();
            if (jsonNode.has(jsonPropValue)) {
                String escapedJsonPropValue = jsonPropValue.replace(".", "\\.");
                ((ObjectNode)jsonNode).set(escapedJsonPropValue, jsonNode.get(jsonPropValue));
            }
            if (FlatteningDeserializer.containsFlatteningDots(jsonPropValue)) {
                JsonNode childJsonNode = FlatteningDeserializer.findNestedNode(jsonNode, jsonPropValue);
                ((ObjectNode)jsonNode).set(jsonPropValue, childJsonNode);
            }
        }
    }

    private static boolean containsFlatteningDots(String key) {
        return key.matches(".+[^\\\\]\\..+");
    }

    private static JsonNode findNestedNode(JsonNode jsonNode, String composedKey) {
        String[] jsonNodeKeys;
        for (String jsonNodeKey : jsonNodeKeys = FlatteningDeserializer.splitKeyByFlatteningDots(composedKey)) {
            if ((jsonNode = jsonNode.get(FlatteningDeserializer.unescapeEscapedDots(jsonNodeKey))) != null) continue;
            return null;
        }
        return jsonNode;
    }

    private static String[] splitKeyByFlatteningDots(String key) {
        return key.split("((?<!\\\\))\\.");
    }

    private static String unescapeEscapedDots(String key) {
        return key.replace("\\.", ".");
    }

    private static boolean containsDot(String str) {
        return !CoreUtils.isNullOrEmpty(str) && str.contains(".");
    }

    private static JsonParser newJsonParserForNode(JsonNode jsonNode) throws IOException {
        JsonParser parser = new JsonFactory().createParser(jsonNode.toString());
        parser.nextToken();
        return parser;
    }
}

