/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.DefaultSyncPoller;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PollerFlux<T, U>
extends Flux<AsyncPollResponse<T, U>> {
    private final ClientLogger logger = new ClientLogger(PollerFlux.class);
    private final PollingContext<T> rootContext = new PollingContext();
    private final Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final Mono<Boolean> oneTimeActivationMono;
    private final Function<PollingContext<T>, PollResponse<T>> syncActivationOperation;
    private volatile Duration pollInterval;

    public PollerFlux(Duration pollInterval, Function<PollingContext<T>, Mono<T>> activationOperation, Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.compareTo(Duration.ZERO) <= 0) {
            throw this.logger.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        Objects.requireNonNull(activationOperation, "'activationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(pollOperation, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(cancelOperation, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(fetchResultOperation, "'fetchResultOperation' cannot be null.");
        this.oneTimeActivationMono = new OneTimeActivation<T, Object>(this.rootContext, activationOperation, activationResult -> new PollResponse<Object>(LongRunningOperationStatus.NOT_STARTED, activationResult)).getMono();
        this.syncActivationOperation = cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, ((Mono)activationOperation.apply(cxt)).block());
    }

    public static <T, U> PollerFlux<T, U> create(Duration pollInterval, Function<PollingContext<T>, Mono<PollResponse<T>>> activationOperation, Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation) {
        return new PollerFlux<T, U>(pollInterval, activationOperation, pollOperation, cancelOperation, fetchResultOperation, true);
    }

    private PollerFlux(Duration pollInterval, Function<PollingContext<T>, Mono<PollResponse<T>>> activationOperation, Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation, boolean ignored) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.isNegative() || pollInterval.isZero()) {
            throw this.logger.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'pollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        Objects.requireNonNull(activationOperation, "'activationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(pollOperation, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(cancelOperation, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(fetchResultOperation, "'fetchResultOperation' cannot be null.");
        this.oneTimeActivationMono = new OneTimeActivation(this.rootContext, activationOperation, Function.identity()).getMono();
        this.syncActivationOperation = cxt -> (PollResponse)((Mono)activationOperation.apply(cxt)).block();
    }

    public static <T, U> PollerFlux<T, U> error(Exception ex) {
        return new PollerFlux<T, U>(Duration.ofMillis(1L), context -> Mono.error(ex), context -> Mono.error(ex), (context, response) -> Mono.error(ex), context -> Mono.error(ex));
    }

    public PollerFlux<T, U> setPollInterval(Duration pollInterval) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.isNegative() || pollInterval.isZero()) {
            throw this.logger.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'pollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        return this;
    }

    @Override
    public void subscribe(CoreSubscriber<? super AsyncPollResponse<T, U>> actual) {
        this.oneTimeActivationMono.flatMapMany(ignored -> {
            PollResponse<T> activationResponse = this.rootContext.getActivationResponse();
            if (activationResponse.getStatus().isComplete()) {
                return Flux.just(new AsyncPollResponse<T, U>(this.rootContext, this.cancelOperation, this.fetchResultOperation));
            }
            return this.pollingLoop();
        }).subscribe(actual);
    }

    public SyncPoller<T, U> getSyncPoller() {
        return new DefaultSyncPoller<T, U>(this.pollInterval, this.syncActivationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
    }

    private Flux<AsyncPollResponse<T, U>> pollingLoop() {
        return Flux.using(() -> this.rootContext.copy(), cxt -> Mono.defer(() -> {
            Mono<PollResponse<T>> pollOnceMono = this.pollOperation.apply((PollingContext<PollingContext>)cxt);
            return pollOnceMono.delaySubscription(this.getDelay(cxt.getLatestResponse()));
        }).switchIfEmpty(Mono.error(new IllegalStateException("PollOperation returned Mono.empty()."))).repeat().takeUntil(currentPollResponse -> currentPollResponse.getStatus().isComplete()).concatMap(currentPollResponse -> {
            cxt.setLatestResponse(currentPollResponse);
            return Mono.just(new AsyncPollResponse<T, U>(cxt, this.cancelOperation, this.fetchResultOperation));
        }), cxt -> {});
    }

    private Duration getDelay(PollResponse<T> pollResponse) {
        Duration retryAfter = pollResponse.getRetryAfter();
        if (retryAfter == null) {
            return this.pollInterval;
        }
        return retryAfter.compareTo(Duration.ZERO) > 0 ? retryAfter : this.pollInterval;
    }

    private class OneTimeActivation<V, R> {
        private final PollingContext<V> rootContext;
        private final Function<PollingContext<V>, Mono<R>> activationFunction;
        private final Function<R, PollResponse<V>> activationPollResponseMapper;
        private volatile boolean activated = false;
        private final AtomicBoolean guardActivation = new AtomicBoolean(false);

        OneTimeActivation(PollingContext<V> rootContext, Function<PollingContext<V>, Mono<R>> activationFunction, Function<R, PollResponse<V>> activationPollResponseMapper) {
            this.rootContext = rootContext;
            this.activationFunction = activationFunction;
            this.activationPollResponseMapper = activationPollResponseMapper;
        }

        Mono<Boolean> getMono() {
            return Mono.defer(() -> {
                if (this.activated) {
                    return Mono.just(true);
                }
                if (this.guardActivation.compareAndSet(false, true)) {
                    Mono<PollResponse<V>> activationMono;
                    try {
                        activationMono = this.activationFunction.apply(this.rootContext);
                    }
                    catch (RuntimeException e) {
                        this.guardActivation.set(false);
                        return FluxUtil.monoError(PollerFlux.this.logger, e);
                    }
                    return activationMono.map(this.activationPollResponseMapper).switchIfEmpty(Mono.defer(() -> Mono.just(new PollResponse<Object>(LongRunningOperationStatus.NOT_STARTED, null)))).map(activationResponse -> {
                        this.rootContext.setOnetimeActivationResponse((PollResponse<V>)activationResponse);
                        this.activated = true;
                        return true;
                    }).doOnError(throwable -> this.guardActivation.set(false));
                }
                return Mono.empty();
            }).repeatWhenEmpty(longFlux -> longFlux.concatMap(ignored -> Flux.just(Boolean.valueOf(true))));
        }
    }
}

