/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Header {
    private final String name;
    private final List<String> values;
    private String cachedStringValue;

    public Header(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<String>();
        this.values.add(value);
    }

    public Header(String name, String ... values2) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<String>();
        for (String value : values2) {
            this.values.add(value);
        }
    }

    public Header(String name, List<String> values2) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.values = new LinkedList<String>(values2);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        this.checkCachedStringValue();
        return this.cachedStringValue;
    }

    public String[] getValues() {
        return this.values.toArray(new String[0]);
    }

    public List<String> getValuesList() {
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(String value) {
        this.values.add(value);
        this.cachedStringValue = null;
    }

    public String toString() {
        this.checkCachedStringValue();
        return this.name + ":" + this.cachedStringValue;
    }

    private void checkCachedStringValue() {
        if (this.cachedStringValue == null) {
            this.cachedStringValue = String.join((CharSequence)",", this.values);
        }
    }
}

