/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class SetDisplayName {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String skip = config.getProperty("skip").toString();
        int skipValue = Integer.parseInt(skip);
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        String adUserName = "CN=PA26036T,OU=Non-SAP,OU=All-Users,OU=WIPRO,DC=wipro,DC=com";
        System.out.print("Enter your adUserPassword: ");
        String adUserPassword = "qazplm123*";
        System.out.print("Enter your adUrl: ");
        String adUrl = "ldap://10.200.51.100:389";
        System.out.print("Enter your adCn: ");
        String adCn = "DC=wipro,DC=com";
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> deviceBkpOverviewDB = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        int count = 0;
        int totalCount = 0;
        List documents = userDBCollection.find(new Document("deleted", false)).skip(skipValue).into(new ArrayList());
        System.out.println("+++++++++++++++++++++++++++" + documents.size());
        LdapContext ldapContext = SetDisplayName.getLdapContext(adUserName, adUserPassword, adUrl);
        SearchControls searchControls = SetDisplayName.getSearchControls();
        for (Document user : documents) {
            String userName = user.getString("userName");
            System.out.println(userName);
            try {
                NamingEnumeration<SearchResult> answer = ldapContext.search(adCn, "sAMAccountName=" + userName, searchControls);
                if (answer.hasMore()) {
                    Attributes attrs = answer.next().getAttributes();
                    String displayName = "";
                    if (attrs.get("givenname") == null || attrs.get("sn") == null) {
                        Attribute groupCn = attrs.get("displayName");
                        displayName = (String)groupCn.get();
                    } else {
                        Attribute givenname = attrs.get("givenname");
                        Attribute sn = attrs.get("sn");
                        displayName = String.valueOf((String)givenname.get()) + " " + sn.get();
                    }
                    BasicDBObject userSearchQuery = new BasicDBObject();
                    userSearchQuery.append("userName", userName);
                    BasicDBObject deviceUpdateFields = new BasicDBObject();
                    deviceUpdateFields.append("displayName", displayName);
                    BasicDBObject updateDeviceQuery = new BasicDBObject();
                    updateDeviceQuery.append("$set", deviceUpdateFields);
                    userDBCollection.updateOne(userSearchQuery, updateDeviceQuery);
                    deviceBkpOverviewDB.updateMany(userSearchQuery, updateDeviceQuery);
                    System.out.println("Done for " + userName + " updated " + count);
                    ++count;
                } else {
                    System.out.println("user not found " + userName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println(" total of " + count + "/" + totalCount);
            ++totalCount;
            System.out.println("Final count :" + count);
        }
    }

    private static LdapContext getLdapContext(String adUserName, String adUserPassword, String adUrl) {
        InitialLdapContext ctx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "Simple");
            env.put("java.naming.security.principal", adUserName);
            env.put("java.naming.security.credentials", adUserPassword);
            env.put("java.naming.provider.url", adUrl);
            env.put("java.naming.referral", "follow");
            ctx = new InitialLdapContext(env, null);
            System.out.println("LDAP Connection: COMPLETE");
        }
        catch (NamingException nex) {
            System.out.println("LDAP Connection: FAILED");
            nex.printStackTrace();
            System.exit(0);
        }
        return ctx;
    }

    private static SearchControls getSearchControls() {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        String[] attrIDs = new String[]{"distinguishedName", "sn", "givenname", "mail", "displayName", "thumbnailPhoto"};
        cons.setReturningAttributes(attrIDs);
        return cons;
    }
}

