/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class DataTracking {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        String devicePath = config.getProperty("devicePath").toString();
        String tableName = config.getProperty("bkpColl").toString();
        boolean deleteAllowed = false;
        if (config.getProperty("delete") != null) {
            deleteAllowed = Boolean.parseBoolean(config.getProperty("delete").toString());
        }
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> bkpColl = db.getCollection(tableName);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<String> allFoldersList = new ArrayList<String>();
        allFoldersList.addAll(Arrays.asList(devicePath.split(",")));
        for (String folderName : allFoldersList) {
            folderName = folderName.replace("[", "");
            folderName = folderName.replace("]", "");
            andQuery = new BasicDBObject();
            folderName = folderName.trim();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            andQuery.put("$and", whereQuery);
            long count = bkpColl.count(andQuery);
            andQuery = new BasicDBObject();
            String folder = folderName.substring(0, folderName.lastIndexOf(47));
            String folderFileName = folderName.substring(folder.length() + 1, folderName.length());
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", true));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("devicePath", folder));
            whereQuery.add(new BasicDBObject("fileName", folderFileName));
            andQuery.put("$and", whereQuery);
            long folderNameCount = bkpColl.count(andQuery);
            System.out.println("....count before tracking folder.... " + folder + ".....count ... " + folderNameCount);
            if (!deleteAllowed) continue;
            DeleteResult result = bkpColl.deleteMany(andQuery);
            System.out.println(String.valueOf(folderName) + "... tracking for folder .... " + result.getDeletedCount());
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", true));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("devicePath", folder));
            whereQuery.add(new BasicDBObject("fileName", folderFileName));
            andQuery.put("$and", whereQuery);
            result = bkpColl.deleteMany(andQuery);
            System.out.println(String.valueOf(folder) + "........" + folderFileName + ".. tracking folder entry .... " + result.getDeletedCount());
        }
    }
}

