/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pmm.util;

import com.parablu.paracloud.element.MediaElement;
import com.parablu.pcbd.domain.MediaImage;
import java.util.ArrayList;
import java.util.List;

public class MediaObjectUtils {
    private MediaObjectUtils() {
    }

    public static MediaElement convertMediaImageToMediaElement(MediaImage mediaImage, String clientData) {
        if (mediaImage == null) {
            return null;
        }
        MediaElement mediaElement = new MediaElement();
        mediaElement.setClientData(clientData);
        mediaElement.setExists(true);
        mediaElement.setFolder(mediaImage.isFolder());
        mediaElement.setExtension(mediaImage.getExtension());
        mediaElement.setFileCompletePath(mediaImage.getClientFilePath());
        mediaElement.setFileName(mediaImage.getFileName());
        mediaElement.setFileSystemPath(mediaImage.getFileSystemPath());
        mediaElement.setLastModifiedTimestamp(mediaImage.getLastClientModifiedTime());
        mediaElement.setMd5checksum(mediaImage.getMd5Checksum());
        mediaElement.setMediaType(mediaImage.getMediaType());
        mediaElement.setMetaData(mediaImage.getMetaData());
        mediaElement.setSharedTimeStamp(null);
        mediaElement.setSize(String.valueOf(mediaImage.getSize()));
        mediaElement.setThumbnailPath(mediaImage.getThumbNailPath());
        mediaElement.setFileUserOwner(mediaImage.getUserName());
        mediaElement.setFileDeviceOwner(mediaImage.getDevice().getDeviceName());
        return mediaElement;
    }

    public static MediaImage convertMediaElementToMediaImage(MediaElement mediaElement) {
        if (mediaElement == null) {
            return null;
        }
        MediaImage mediaImage = new MediaImage();
        mediaImage.setClientData(null);
        mediaImage.setFolder(mediaElement.isFolder());
        mediaImage.setExtension(mediaElement.getExtension());
        mediaImage.setClientFilePath(mediaElement.getFileCompletePath());
        mediaImage.setFileName(mediaElement.getFileName());
        mediaImage.setFileSystemPath(mediaElement.getFileSystemPath());
        mediaImage.setLastServerModifiedTime(System.currentTimeMillis());
        mediaImage.setLastClientModifiedTime(mediaElement.getLastModifiedTimestamp());
        mediaImage.setMd5Checksum(mediaElement.getMd5checksum());
        mediaImage.setMediaType(mediaElement.getMediaType());
        mediaImage.setMetaData(mediaElement.getMetaData());
        mediaImage.setSize(Double.valueOf(mediaElement.getSize()).doubleValue());
        mediaImage.setThumbNailPath(mediaElement.getThumbnailPath());
        return mediaImage;
    }

    public static List<MediaElement> convertMediaImageListToMediaElementList(List<MediaImage> mediaImages) {
        ArrayList<MediaElement> elements = new ArrayList<MediaElement>();
        if (mediaImages == null || mediaImages.isEmpty()) {
            return elements;
        }
        for (MediaImage mediaImage : mediaImages) {
            elements.add(MediaObjectUtils.convertMediaImageToMediaElement(mediaImage, mediaImage.getDevice().getUserName()));
        }
        return elements;
    }
}

