/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pmm.delegate.impl;

import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.paracloud.element.MediaElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MediaImage;
import com.parablu.pmm.delegate.MediaUploadService;
import com.parablu.pmm.exception.ParacloudMediaException;
import com.parablu.pmm.service.MediaService;
import com.parablu.pmm.util.ResourceFileHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class MediaUploadServiceImpl
implements MediaUploadService {
    private Logger logger = LogManager.getLogger(MediaUploadServiceImpl.class);
    @Autowired
    private MediaService mediaService;

    @Override
    public void uploadFileAsMedia(int cloudId, String cloudName, Cloud cloud, InputStream inputStream, MediaElement mediaElement, int mediaType, long cloudSizeAllowedInBytes, Device device) {
        this.logger.trace("Uploading file ");
        String fileName = null;
        MediaImage mediaImage = null;
        try {
            this.convertToServerPath(mediaElement, device);
            fileName = mediaElement.getFileName();
            if (!DiskSpaceHelper.isEnoughSpaceAvailable((String)cloudName, (long)Long.valueOf(mediaElement.getSize()), (long)cloudSizeAllowedInBytes)) {
                throw new ParacloudMediaException("Enough space not avaiable", 507);
            }
            mediaImage = this.readFromMediaDb(cloudId, cloudName, mediaElement);
            boolean lastRecordPresent = this.isRecordPresent(mediaImage);
            boolean noChange = false;
            if (lastRecordPresent) {
                noChange = this.checkIfRevisionHasBeenModified(mediaElement, mediaImage);
            }
            if (lastRecordPresent && noChange) {
                return;
            }
            if (mediaElement.isFolder()) {
                throw new ParacloudMediaException("folders not allowed", 400);
            }
            this.uploadFile(cloudId, cloudName, cloud, inputStream, mediaElement, device, fileName);
        }
        catch (ParacloudMediaException e) {
            this.logger.error("@ResourceFunnelException@", (Throwable)((Object)e));
            throw new ParacloudMediaException("Exception occured in uploadImpl" + (Object)((Object)e), e.getResponseCode());
        }
        catch (Exception e) {
            this.logger.error("@Exception@", (Throwable)e);
            throw new ParacloudMediaException("Exception occured in uploadImpl" + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void uploadFile(int cloudId, String cloudName, Cloud cloud, InputStream inputStream, MediaElement mediaElement, Device device, String fileName) throws NoSuchAlgorithmException, IOException {
        String intermediateUploadFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "media";
        File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        this.readFileItemAndUploadToTempPath(cloudId, cloudName, fileName, intermediateUploadFolder, intermediateFile, mediaElement.getMd5checksum(), inputStream, device.getDeviceUUID());
        long fileSizeinBytes = intermediateFile.length();
        long filesizeInKB = (long)Math.ceil((double)fileSizeinBytes / 1024.0);
        mediaElement.setSize(String.valueOf(filesizeInKB));
        this.mediaService.uploadMediaFile(cloudId, cloudName, cloud, mediaElement, intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR, device, mediaElement.getExtension(), mediaElement.getMediaType());
    }

    private void readFileItemAndUploadToTempPath(int cloudId, String cloudName, String fileName, String intermediateUploadCompleteFolderPath, File intermediateFile, String md5checksum, InputStream inputStream, String deviceUUID) throws IOException, NoSuchAlgorithmException {
        File intermediateFolder = new File(intermediateUploadCompleteFolderPath);
        if (intermediateFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories(intermediateFolder);
        } else if (!intermediateFolder.mkdirs()) {
            throw new ParacloudMediaException("Upload Folder Not Created", 500);
        }
        this.tranferFileFromStream(inputStream, intermediateFile, md5checksum);
    }

    private void tranferFileFromStream(InputStream inputStream, File intermediateFile, String md5Checksum) throws NoSuchAlgorithmException, IOException {
        byte[] b = new byte[4096];
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (InputStream inputStreamTemp = inputStream;
             FileOutputStream outstream = new FileOutputStream(intermediateFile);){
            intermediateFile.createNewFile();
            int buff = -1;
            while ((buff = inputStreamTemp.read(b)) != -1) {
                outstream.write(b, 0, buff);
                md.update(b, 0, buff);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudMediaException("IO Exception while creating tempFile" + e, 500);
        }
        catch (IOException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudMediaException("IO Exception while transfering from client" + e, 500);
        }
        String uploadedFileMd5Checksum = new String(Hex.encodeHex((byte[])md.digest()));
        if (!uploadedFileMd5Checksum.equals(md5Checksum)) {
            this.logger.debug("md5 @@@@@" + uploadedFileMd5Checksum);
            intermediateFile.delete();
            throw new ParacloudMediaException("File Upload Not Successful,due to MD5 mismatch", 500);
        }
    }

    private boolean checkIfRevisionHasBeenModified(MediaElement mediaElement, MediaImage mediaImage) {
        return mediaImage.getMd5Checksum().equals(mediaElement.getMd5checksum());
    }

    private boolean isRecordPresent(MediaImage mediaImage) {
        return mediaImage != null;
    }

    private MediaImage readFromMediaDb(int cloudId, String cloudName, MediaElement mediaElement) {
        this.mediaService.readFromMediaTable(cloudId, cloudName, mediaElement.getFileName());
        return null;
    }

    private void convertToServerPath(MediaElement fileElement, Device device) {
        String ostype = device.getOsType();
        boolean type = ostype.equals("Android");
        String convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)type);
        fileElement.setFileCompletePath(convertedPath);
    }
}

