/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.service.impl;

import com.parablu.bluvault.sync.exception.FileOperationException;
import com.parablu.bluvault.sync.service.ResourceSyncService;
import com.parablu.bluvault.udc.dto.ShareAndSearchDLTO;
import com.parablu.bluvault.udc.helper.SearchIndexHelper;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.FileRevisionElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudFileElement;
import com.parablu.paracloud.element.SharedFileImageElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.FileTypeHelper;
import com.parablu.paracloud.util.PathGenerator;
import com.parablu.paracloud.util.ThumbnailHelper;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.ConsolidatedImageDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.MiniCloudDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.dao.SharedFileImageDao;
import com.parablu.pcbd.dao.SyncBackUpImageDAO;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserMiniCloudMappingDao;
import com.parablu.pcbd.dao.UserSyncOverViewDao;
import com.parablu.pcbd.dao.UsersSharedFileDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.DeletedSearchIndex;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.SharedFileImage;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import com.parablu.pcbd.domain.UserSyncOverView;
import com.parablu.pcbd.domain.UsersSharedFile;
import com.parablu.pcsd.domain.SyncPolicy;
import com.parablu.rf.service.SearchService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ResourceSyncServiceImpl
implements ResourceSyncService {
    private static Logger logger = LogManager.getLogger(ResourceSyncServiceImpl.class);
    @Resource
    private ConsolidatedImageDao consolidatedImageDao;
    @Resource
    private UserDao userDao;
    @Resource
    private UserMiniCloudMappingDao userMiniCloudMappingDao;
    @Resource
    private MiniCloudDao miniCloudDao;
    @Resource
    private FileRevisionDao fileRevisionDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private UsersSharedFileDao usersSharedFileDao;
    @Resource
    private SharedFileImageDao sharedFileImageDao;
    @Resource
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private SearchService searchService;
    @Autowired
    private BackUpImageDao backUpImageDao;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Resource
    private UserSyncOverViewDao userSyncOverViewDao;
    @Resource
    private SearchIndexDao searchIndexDao;
    @Resource
    private SyncBackUpImageDAO syncBackUpImageDAO;
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException ";
    private static final String RESTORED = "RESTORED";
    private static final String DELETED = "DELETED";
    private static final String SIZE_FROM_DB = "size got after DB fetch: ";
    private static final String NEW_DESTINATION_PATH = "new destination path: ";
    private static final String FILE_TO_COPY = "File to copy: ";
    private static final String EXCEPTION_GETTING_PAGE_WISE_DELETE_IMAGES = "Exception while getting page wise delete file images ";
    private static final String ACTIVE = "ACTIVE";

    @Override
    public List<MiniCloudFileElement> getChildren(int cloudId, String cloudName, String folderPath, int skip, List<MiniCloudElement> restrictedMiniCloudElements, List<MiniCloudElement> userMiniCloudElements, String userName, ObjectId userId, boolean showDeletedFiles) {
        User user = null;
        MiniCloud miniCloud = null;
        ArrayList<MiniCloudFileElement> fileList = new ArrayList<MiniCloudFileElement>();
        List userMiniCloudElementsTemp = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudName, userId).getMiniClouds();
        List backUpImageList = new ArrayList();
        boolean isParentMC = this.isParentDirMiniCloud(userMiniCloudElementsTemp, folderPath);
        if (isParentMC) {
            String mcName = ResourceSyncServiceImpl.getMCName(folderPath);
            miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, mcName);
            backUpImageList = this.syncBackUpImageDAO.getLatestChildrenByFolder(cloudId, "", cloudName, folderPath, skip, user, miniCloud, showDeletedFiles);
        } else {
            user = this.userDao.getUserByName(cloudId, userName);
            backUpImageList = this.syncBackUpImageDAO.getLatestChildrenByFolder(cloudId, userName, cloudName, folderPath, skip, user, miniCloud, showDeletedFiles);
        }
        logger.debug(folderPath + "@@@@@@ getChildren FILE LIST ...for user " + userName + "..... " + backUpImageList.size());
        if ("ParaBlu".equalsIgnoreCase(folderPath)) {
            List miniCloudList;
            ArrayList<String> miniCloudNames = new ArrayList<String>();
            ArrayList<String> destinationCollections = new ArrayList<String>();
            for (MiniCloudElement userMiniClouds : userMiniCloudElementsTemp) {
                if (userMiniClouds == null) continue;
                miniCloudNames.add(userMiniClouds.getMiniCloudName());
                destinationCollections.add(userMiniClouds.getSyncDestinationCollection());
            }
            if (!(CollectionUtils.isEmpty(miniCloudNames) || CollectionUtils.isEmpty(destinationCollections) || CollectionUtils.isEmpty((Collection)(miniCloudList = this.syncBackUpImageDAO.getLatestChildrenByFolderForMC(cloudId, cloudName, folderPath, miniCloudNames, destinationCollections, skip))))) {
                backUpImageList.addAll(miniCloudList);
            }
        }
        for (int i = 0; i < backUpImageList.size(); ++i) {
            MiniCloudFileElement miniCloudFileElement = new MiniCloudFileElement();
            try {
                BackUpImage backUpImage = (BackUpImage)backUpImageList.get(i);
                MiniCloudElement miniCloudElement = new MiniCloudElement();
                miniCloudElement.setMiniCloudName(backUpImage.getFileName());
                if (restrictedMiniCloudElements != null && restrictedMiniCloudElements.contains(miniCloudElement)) {
                    logger.debug("--- Restricted MiniCloud, ignoring ---");
                    continue;
                }
                if (userMiniCloudElementsTemp.contains(miniCloudElement)) {
                    miniCloudFileElement.setMinicloud(true);
                }
                miniCloudFileElement.setStoragePlace(backUpImage.getStoragePlace());
                miniCloudFileElement.setFileName(backUpImage.getFileName());
                miniCloudFileElement.setFolder(backUpImage.isFolder());
                miniCloudFileElement.setFileCompletePath(backUpImage.getDevicePath());
                miniCloudFileElement.setMd5checksum(backUpImage.getMd5Checksum());
                miniCloudFileElement.setSize(String.valueOf(backUpImage.getSize()));
                miniCloudFileElement.setExists(backUpImage.isPresent());
                miniCloudFileElement.setFileUserOwner(backUpImage.getUserName());
                miniCloudFileElement.setFileRevisionId(backUpImage.getId().toString());
                String extension = FilenameUtils.getExtension((String)backUpImage.getFileName());
                if (!StringUtils.isEmpty((String)backUpImage.getGatewayName())) {
                    miniCloudFileElement.setGatewayName(backUpImage.getGatewayName());
                }
                if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
                    miniCloudFileElement.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath());
                }
                miniCloudFileElement.setLastModifiedTimestamp(backUpImage.getLastServerModifiedTime());
            }
            catch (Exception e) {
                logger.trace("--- Exception occurred --- ", (Throwable)e);
                logger.error("--- Exception occurred --- " + e.getMessage());
            }
            fileList.add(miniCloudFileElement);
        }
        return fileList;
    }

    private boolean isParentDirMiniCloud(List<MiniCloudElement> userMiniCloudElements, String folderPath) {
        boolean isParentMC = false;
        String parentFolder = "";
        String[] temp = folderPath.split("/");
        if (temp != null && temp.length > 1) {
            parentFolder = temp[1];
        }
        logger.debug(folderPath + " PATH....... " + parentFolder);
        if (!StringUtils.isEmpty((String)parentFolder) && !CollectionUtils.isEmpty(userMiniCloudElements)) {
            for (MiniCloudElement userMiniClouds : userMiniCloudElements) {
                if (userMiniClouds == null) continue;
                logger.debug(" !!!MC NAME ......... " + userMiniClouds.getMiniCloudName());
                if (!parentFolder.equals(userMiniClouds.getMiniCloudName())) continue;
                isParentMC = true;
                break;
            }
        }
        logger.debug(" !!!!!!!!!!!!!!!! " + isParentMC);
        return isParentMC;
    }

    private void convertFileRevisionDomainToElement(FileRevision fileRevision, FileRevisionElement fileRevisionElement) {
        fileRevisionElement.setFileCompletePath(fileRevision.getConsolidatedImage().getDevicePath());
        fileRevisionElement.setFileName(fileRevision.getConsolidatedImage().getFileName());
        fileRevisionElement.setExists(fileRevision.getConsolidatedImage().isPresent());
        fileRevisionElement.setFolder(fileRevision.getConsolidatedImage().isFolder());
        fileRevisionElement.setfSPath(fileRevision.getfSPath());
        fileRevisionElement.setStatus(fileRevision.getStatus());
        fileRevisionElement.setLastModifiedTimestamp(fileRevision.getLastModifiedTime());
        fileRevisionElement.setMd5checksum(fileRevision.getMd5());
        fileRevisionElement.setMetaData(fileRevision.getMetaData());
        fileRevisionElement.setSize(Double.toString(fileRevision.getSize()));
        fileRevisionElement.setFileUserOwner(fileRevision.getUserName());
        fileRevisionElement.setFileDeviceOwner(fileRevision.getRegID());
        if (fileRevision.getComment() == null) {
            fileRevisionElement.setComment("");
        } else {
            fileRevisionElement.setComment(fileRevision.getComment());
        }
        fileRevisionElement.setRevisionId(fileRevision.getId());
        String extension = FilenameUtils.getExtension((String)fileRevision.getConsolidatedImage().getFileName());
        if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
            fileRevisionElement.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileRevision.getfSPath());
        }
    }

    private void convertFileRevisionDomainToElement(BackUpImage imageFile, FileRevisionElement fileRevisionElement) {
        fileRevisionElement.setFileCompletePath(imageFile.getDevicePath());
        fileRevisionElement.setFileName(imageFile.getFileName());
        fileRevisionElement.setExists(imageFile.isPresent());
        fileRevisionElement.setFolder(imageFile.isFolder());
        fileRevisionElement.setfSPath(imageFile.getfSPath());
        fileRevisionElement.setStatus(imageFile.getStatus());
        fileRevisionElement.setLastModifiedTimestamp(imageFile.getLastServerModifiedTime());
        fileRevisionElement.setMd5checksum(imageFile.getMd5Checksum());
        fileRevisionElement.setSize(Double.toString(imageFile.getSize()));
        fileRevisionElement.setFileUserOwner(imageFile.getUserName());
        fileRevisionElement.setBackupId(imageFile.getId().toString());
        fileRevisionElement.setComment(imageFile.getComment());
        String extension = FilenameUtils.getExtension((String)imageFile.getFileName());
        if (FileTypeHelper.isImageFile((String)extension) || FileTypeHelper.isVideoFile((String)extension)) {
            fileRevisionElement.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + imageFile.getfSPath());
        }
    }

    private void convertFileRevisionDomainToElement(int cloudId, String cloudName, FileRevision fileRevision, FileRevisionElement fileRevisionElement) {
        this.convertFileRevisionDomainToElement(fileRevision, fileRevisionElement);
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, fileRevision.getRegID());
        if (device == null) {
            fileRevisionElement.setFileDeviceOwner(null);
        } else {
            fileRevisionElement.setFileDeviceOwner(device.getDeviceName());
        }
    }

    private void convertBackUpImageRevisionDomainToElement(int cloudId, String cloudName, BackUpImage backUpImageRevision, FileRevisionElement fileRevisionElement) {
        this.convertFileRevisionDomainToElement(backUpImageRevision, fileRevisionElement);
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, backUpImageRevision.getDeviceUUID());
        if (device == null) {
            fileRevisionElement.setFileDeviceOwner(null);
        } else {
            fileRevisionElement.setFileDeviceOwner(device.getDeviceName());
        }
    }

    public void convertBackupImageToFileElement(int cloudId, String cloudName, BackUpImage backUpImage, FileElement fileElement) {
        String extension;
        Device device;
        long lastDelTask = System.currentTimeMillis() - 2592000000L;
        if (backUpImage == null || backUpImage.getCrawlStartTimestamp() < lastDelTask || backUpImage.isPresent()) {
            return;
        }
        fileElement.setFileName(backUpImage.getFileName());
        fileElement.setFolder(backUpImage.isFolder());
        fileElement.setFileCompletePath(backUpImage.getDevicePath());
        fileElement.setMd5checksum(backUpImage.getMd5Checksum());
        fileElement.setSize(String.valueOf(backUpImage.getSize()));
        fileElement.setExists(backUpImage.isPresent());
        fileElement.setLastModifiedTimestamp(backUpImage.getCrawlStartTimestamp());
        fileElement.setFileUserOwner(backUpImage.getUserName());
        if (backUpImage.getDeviceUUID() != null && !backUpImage.getDeviceUUID().equalsIgnoreCase("Portal") && (device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, backUpImage.getDeviceUUID())) != null) {
            fileElement.setFileDeviceOwner(device.getDeviceName());
        }
        if (FileTypeHelper.isImageFile((String)(extension = FilenameUtils.getExtension((String)backUpImage.getFileName()))) || FileTypeHelper.isVideoFile((String)extension)) {
            fileElement.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath());
        }
    }

    public void convertConsolidatedImageToFileRevision(ConsolidatedImage imageFile, FileRevision fileRevision) {
        fileRevision.setConsolidatedImage(imageFile);
        fileRevision.setFolder(imageFile.isFolder());
        fileRevision.setLastModifiedTime(imageFile.getCrawlStartTimestamp());
        fileRevision.setfSPath(PathGenerator.getFsPath((String)imageFile.getMD5()));
        fileRevision.setMd5(imageFile.getMD5());
        fileRevision.setMetaData(imageFile.getMetaData());
        fileRevision.setSize(imageFile.getSize());
        fileRevision.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
        fileRevision.setUserName(imageFile.getUserName());
        fileRevision.setRegID(imageFile.getRegID());
    }

    @Override
    public FileRevisionElement validateResourceFile(int cloudId, String userName, String cloudName, String fileName, String destinationPath, User user, MiniCloud miniCloud) {
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, destinationPath, fileName, user, miniCloud);
        if (backUpImage == null) {
            backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathForMiniCloudWithoutRegex(cloudId, cloudName, destinationPath, fileName, user, miniCloud);
            logger.debug("Inside minicloud check .... " + backUpImage);
        }
        if (backUpImage == null || !backUpImage.isPresent()) {
            return null;
        }
        backUpImage = this.getLatestImageForDeletedFiles(cloudId, userName, backUpImage, user, miniCloud);
        FileRevisionElement fileRevisionElement = new FileRevisionElement();
        this.convertFileRevisionDomainToElement(backUpImage, fileRevisionElement);
        fileRevisionElement.setRevisionId(backUpImage.getId());
        return fileRevisionElement;
    }

    @Override
    public FileRevisionElement validateResourceFileForDelete(int cloudId, String userName, String cloudName, String fileName, String destinationPath, User user, MiniCloud miniCloud) {
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, destinationPath, fileName, user, miniCloud);
        if (backUpImage == null) {
            backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathForMiniCloudWithoutRegex(cloudId, cloudName, destinationPath, fileName, user, miniCloud);
            logger.debug("Inside minicloud check .... " + backUpImage);
        }
        if (backUpImage == null) {
            return null;
        }
        backUpImage = this.getLatestImageForDeletedFiles(cloudId, userName, backUpImage, user, miniCloud);
        FileRevisionElement fileRevisionElement = new FileRevisionElement();
        this.convertFileRevisionDomainToElement(backUpImage, fileRevisionElement);
        fileRevisionElement.setRevisionId(backUpImage.getId());
        return fileRevisionElement;
    }

    @Override
    public FileRevisionElement validateResourceFileByRevId(int cloudId, String userName, String fileRevisionId, User user, MiniCloud miniCloud) {
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageById(cloudId, fileRevisionId, user, miniCloud);
        if (backUpImage == null) {
            logger.debug(".....backUpImage is null...." + fileRevisionId);
            return null;
        }
        backUpImage = this.getLatestImageForDeletedFiles(cloudId, userName, backUpImage, user, miniCloud);
        FileRevisionElement fileRevisionElement = new FileRevisionElement();
        this.convertFileRevisionDomainToElement(backUpImage, fileRevisionElement);
        fileRevisionElement.setRevisionId(backUpImage.getId());
        return fileRevisionElement;
    }

    private FileRevision getLatestRevisionForDeletedFiles(int cloudId, String cloudName, ObjectId consoId, FileRevision fileRevision) {
        if (!StringUtils.isEmpty((String)fileRevision.getStatus()) && fileRevision.getStatus().equals(RESTORED)) {
            List revisions = this.fileRevisionDao.getAllRevisions(cloudId, cloudName, consoId);
            for (FileRevision revision : revisions) {
                if (revision.getStatus().equals(RESTORED) || revision.getStatus().equals(DELETED)) continue;
                return revision;
            }
        }
        return fileRevision;
    }

    @Override
    public FileRevisionElement validateResourceFileForRestore(int cloudId, String userName, String cloudName, String fileName, String destinationPath, User user, MiniCloud miniCloud) {
        logger.debug(userName + "FileRevisionElement  fileName " + fileName + " destinationPath " + destinationPath);
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathForRestore(cloudId, userName, cloudName, destinationPath, fileName, user, miniCloud);
        if (backUpImage == null || backUpImage.isPresent()) {
            logger.error("File/folder does not exists...." + fileName + " destinationPath " + destinationPath);
            return null;
        }
        FileRevisionElement fileRevisionElement = new FileRevisionElement();
        this.convertFileRevisionDomainToElement(backUpImage, fileRevisionElement);
        fileRevisionElement.setRevisionId(backUpImage.getId());
        return fileRevisionElement;
    }

    @Override
    public ShareAndSearchDLTO deleteResourceFile(int cloudId, String cloudName, String fileName, String folderPath, String userName, boolean isPathInsideMC, boolean isSearchEnabled, User user, MiniCloud miniCloud, boolean isFolder) throws Exception {
        BackUpImage existingImage;
        String userNameVal = userName;
        if (isPathInsideMC) {
            userNameVal = "";
        }
        if ((existingImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathForPresentRecord(cloudId, userNameVal, cloudName, folderPath, fileName, user, miniCloud)) == null) {
            return null;
        }
        ArrayList<String> sharedFileNameList = new ArrayList<String>();
        ArrayList<String> sharedDevicePathList = new ArrayList<String>();
        ArrayList searchIndexs = new ArrayList();
        long lastModifiedTime = System.currentTimeMillis();
        if (!isFolder) {
            BackUpImage imageNewRevision = new BackUpImage();
            BeanUtils.copyProperties((Object)existingImage, (Object)imageNewRevision, (String[])new String[]{"id"});
            imageNewRevision.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
            imageNewRevision.setPresent(false);
            imageNewRevision.setCrawlStartTimestamp(lastModifiedTime);
            imageNewRevision.setLastServerModifiedTime(lastModifiedTime);
            imageNewRevision.setUserName(userName);
            imageNewRevision.setDeviceUUID("Portal");
            this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, existingImage);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, imageNewRevision, user, miniCloud);
            if (!existingImage.isFolder() && isSearchEnabled) {
                DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                deletedSearchIndex.setId(existingImage.getId());
                deletedSearchIndex.setSync(true);
                deletedSearchIndex.setCloudId(cloudId);
                deletedSearchIndex.setCloudName(cloudName);
                deletedSearchIndex.setUserName(userNameVal);
                deletedSearchIndex.setDevicePath(existingImage.getDevicePath());
                this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
                this.searchService.updateDeleteFileIndex(cloudId, cloudName, existingImage.getId().toString(), DELETED);
            }
            if (isPathInsideMC) {
                this.updateModifiedTimeStamp(cloudId, null, cloudName, folderPath, lastModifiedTime, null, miniCloud);
            } else {
                this.updateModifiedTimeStamp(cloudId, userNameVal, cloudName, folderPath, lastModifiedTime, user, miniCloud);
            }
        } else {
            String newPath = folderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
            logger.debug("BEFORE LIST delete:!!!! " + newPath);
            ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
            folderList.add(existingImage);
            this.getChildFoldersForBaseFolder(cloudId, cloudName, userNameVal, newPath, folderList, user, miniCloud, true);
            for (BackUpImage subFolder : folderList) {
                String subFolderPath = subFolder.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + subFolder.getFileName();
                List fileListFromDatabase = this.syncBackUpImageDAO.getLatestExistingRecordsBeforeCurrentTimeStampForPath(cloudId, userNameVal, cloudName, lastModifiedTime, subFolderPath, user, miniCloud);
                for (BackUpImage backUpImageChild : fileListFromDatabase) {
                    logger.debug("Sync BackUpImage Path : " + backUpImageChild.getDevicePath() + " FileName : " + backUpImageChild.getFileName());
                    BackUpImage backUpImageChildDeleted = new BackUpImage();
                    backUpImageChild = this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloudId, userNameVal, backUpImageChild.getDevicePath(), backUpImageChild.getFileName(), user, miniCloud);
                    BeanUtils.copyProperties((Object)backUpImageChild, (Object)backUpImageChildDeleted, (String[])new String[]{"id"});
                    backUpImageChildDeleted.setPresent(false);
                    backUpImageChildDeleted.setStatus(DELETED);
                    backUpImageChildDeleted.setCrawlStartTimestamp(lastModifiedTime);
                    backUpImageChildDeleted.setLastServerModifiedTime(lastModifiedTime);
                    backUpImageChildDeleted.setDeviceUUID("Portal");
                    this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, backUpImageChildDeleted, user, miniCloud);
                    this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, backUpImageChild);
                }
                BackUpImage subFolderDeleted = new BackUpImage();
                BeanUtils.copyProperties((Object)subFolder, (Object)subFolderDeleted);
                subFolderDeleted.setPresent(false);
                subFolderDeleted.setStatus(DELETED);
                subFolderDeleted.setCrawlStartTimestamp(lastModifiedTime);
                subFolderDeleted.setLastServerModifiedTime(lastModifiedTime);
                subFolderDeleted.setDeviceUUID("Portal");
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, subFolderDeleted, user, miniCloud);
                if (!subFolder.isFolder() || !isSearchEnabled) continue;
                DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                deletedSearchIndex.setId(subFolder.getId());
                deletedSearchIndex.setSync(true);
                deletedSearchIndex.setFolderDelete(true);
                deletedSearchIndex.setCloudId(cloudId);
                deletedSearchIndex.setCloudName(cloudName);
                deletedSearchIndex.setUserName(userNameVal);
                deletedSearchIndex.setDevicePath(subFolder.getDevicePath());
                this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
            }
        }
        return new ShareAndSearchDLTO(searchIndexs, sharedFileNameList, sharedDevicePathList);
    }

    public ShareAndSearchDLTO deleteResourceFilesForMC(int cloudId, String cloudName, String fileName, String folderPath, String userName, MiniCloud miniCloud) throws Exception {
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathForPresentRecord(cloudId, userName, cloudName, folderPath, fileName, null, miniCloud);
        if (backUpImage == null) {
            return null;
        }
        ArrayList<String> sharedFileNameList = new ArrayList<String>();
        ArrayList<String> sharedDevicePathList = new ArrayList<String>();
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        long lastModifiedTime = System.currentTimeMillis();
        this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, backUpImage);
        ArrayList searchIndexes = new ArrayList();
        SearchIndexHelper.deleteIndexByFileName((int)cloudId, (String)cloudName, (BackUpImage)backUpImage);
        if (miniCloud != null) {
            this.updateModifiedTimeStamp(cloudId, null, cloudName, folderPath, lastModifiedTime);
        } else {
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, folderPath, lastModifiedTime);
        }
        if (backUpImage.isFolder()) {
            String newPath = folderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
            logger.debug("BEFORE LIST delete:!!!! ");
            ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
            folderList.add(backUpImage);
            this.getAllChildFoldersForBaseFolder(cloudId, cloudName, userName, newPath, folderList, null, miniCloud);
            for (BackUpImage subFolder : folderList) {
                String folderDevicePath = subFolder.getDevicePath() + "/" + subFolder.getFileName();
                List backUpImageListFromDB = this.syncBackUpImageDAO.getAllRecordsBeforeCurrentTimeStamp(cloudId, userName, cloudName, lastModifiedTime, folderDevicePath, null, miniCloud);
                logger.debug("subfolder : " + subFolder.getFileName() + "file list for delete: " + backUpImageListFromDB.size());
                for (BackUpImage subFolderChild : backUpImageListFromDB) {
                    if (!subFolderChild.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString()) && !subFolderChild.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.RESTORED.toString())) {
                        if (!subFolderChild.getChunkFiles().isEmpty()) {
                            this.reduceRefCountInChunkDetail(cloudId, subFolderChild.getChunkFiles(), subFolderChild.getUserName());
                        }
                        if (!subFolderChild.isFolder()) {
                            DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                            deletedSearchIndex.setId(subFolderChild.getId());
                            deletedSearchIndex.setSync(true);
                            deletedSearchIndex.setCloudId(cloudId);
                            deletedSearchIndex.setCloudName(cloudName);
                            deletedSearchIndex.setUserName(userName);
                            deletedSearchIndex.setDevicePath(subFolderChild.getDevicePath());
                            this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
                        }
                        this.searchService.updateDeleteFileIndex(cloudId, cloudName, backUpImage.getId().toString(), DELETED);
                        this.reduceStorageSizeInSyncOverview(subFolderChild);
                        long fileSize = Math.round((double)subFolderChild.getSize() * 1024.0);
                        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)0, (long)fileSize);
                    }
                    this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, subFolderChild);
                    pathsToDelete.add(subFolderChild.getfSPath());
                    this.searchService.updateDeleteFileIndex(cloudId, cloudName, subFolderChild.getId().toString(), DELETED);
                    this.syncBackUpImageDAO.deleteBackUpImage(cloudId, subFolderChild, null, miniCloud);
                }
                this.syncBackUpImageDAO.deleteBackUpImage(cloudId, subFolder, null, miniCloud);
            }
        }
        for (String path : pathsToDelete) {
            File file = new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + path);
            file.delete();
            file = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + path);
            file.delete();
        }
        return new ShareAndSearchDLTO(searchIndexes, sharedFileNameList, sharedDevicePathList);
    }

    private void getAllChildFoldersForBaseFolder(int cloudId, String cloudName, String userName, String filePath, List<BackUpImage> syncFolderList, User user, MiniCloud miniCloud) {
        List backUpImageList = this.syncBackUpImageDAO.getBackUpImageDBRecordByOnlyDevicePath(cloudId, userName, cloudName, filePath, user, miniCloud, true);
        if (!CollectionUtils.isEmpty((Collection)backUpImageList)) {
            syncFolderList.addAll(backUpImageList);
            Stream stream = backUpImageList.parallelStream();
            stream.forEach(syncFile -> {
                String devicePath = syncFile.getDevicePath() + "/" + syncFile.getFileName();
                this.getAllChildFoldersForBaseFolder(cloudId, cloudName, userName, devicePath, syncFolderList, user, miniCloud);
            });
        }
    }

    private void reduceRefCountInChunkDetail(int cloudId, List<ChunkFile> chunkFiles, String userName) {
        String dedupVal = this.getDedupValue(userName);
        for (ChunkFile chunkFile : chunkFiles) {
            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
            if (chunkDetail == null) continue;
            logger.debug("Chunk detail md5 is " + chunkDetail.getMd5());
            if (chunkDetail.getRefCount() <= 0) continue;
            int refCount = chunkDetail.getRefCount() - 1;
            chunkDetail.setRefCount(refCount);
            this.externalStorageBackupFileDao.updateChunkDetail(cloudId, chunkDetail);
        }
    }

    private void increaseRefCountInChunkDetail(int cloudId, List<ChunkFile> chunkFiles, String userName) {
        String dedupVal = this.getDedupValue(userName);
        for (ChunkFile chunkFile : chunkFiles) {
            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
            if (chunkDetail == null) continue;
            logger.debug("Chunk detail md5 is " + chunkDetail.getMd5());
            int refCount = chunkDetail.getRefCount() + 1;
            chunkDetail.setRefCount(refCount);
            this.externalStorageBackupFileDao.updateChunkDetail(cloudId, chunkDetail);
        }
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.userDao.getUserByName(1, userName);
        if (user != null) {
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(1, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    public void reduceStorageSizeInSyncOverview(BackUpImage backUpImageRevision) {
        long fileSize = new Double(backUpImageRevision.getSize()).longValue();
        SyncOverView syncOverView = this.fileRevisionDao.getSyncOverview(1);
        long total = syncOverView.getTotalSizeUploaded();
        long actual = total - fileSize;
        syncOverView.setTotalSizeUploaded(actual);
        this.fileRevisionDao.saveSyncOverview(1, syncOverView);
        User user = this.userDao.getUserByName(1, backUpImageRevision.getUserName());
        if (user == null) {
            return;
        }
        UserSyncOverView userSyncOverView = user.getUserSyncOverView();
        if (userSyncOverView == null) {
            return;
        }
        total = 0L;
        actual = 0L;
        double totald = userSyncOverView.getStorageUtilized();
        double actuald = totald - (double)backUpImageRevision.getSize();
        userSyncOverView.setStorageUtilized(actuald);
        this.userSyncOverViewDao.saveUserSyncOverViewToDB(1, userSyncOverView);
    }

    private void deleteSharedFiles(List<String> sharedFileNameList, List<String> sharedDevicePathList, ConsolidatedImage imageFile) {
        if (imageFile.getSharedTimeStamp() != null) {
            imageFile.setSharedTimeStamp(null);
            sharedFileNameList.add(imageFile.getFileName());
            sharedDevicePathList.add(imageFile.getDevicePath());
        }
    }

    private void deleteSyncSharedFiles(List<String> sharedFileNameList, List<String> sharedDevicePathList, BackUpImage imageFile) {
        if (imageFile != null && StringUtils.isNotEmpty((String)imageFile.getDevicePath()) && StringUtils.isNotEmpty((String)imageFile.getFileName())) {
            sharedFileNameList.add(imageFile.getFileName());
            sharedDevicePathList.add(imageFile.getDevicePath());
        }
    }

    @Override
    public List<SearchIndex> uploadResourceFile(int cloudId, String cloudName, Cloud cloud, FileElement fileElement, String userName, boolean isMiniCloud, User user, MiniCloud miniCloud, boolean isPathInsideMiniCoud) throws Exception {
        long currentTime = System.currentTimeMillis();
        String name = fileElement.getFileName();
        char[] cArray = "/*\":<>".toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (!name.contains(c.toString())) continue;
            return null;
        }
        ArrayList<SearchIndex> searchIndexes = new ArrayList<SearchIndex>();
        long filesize = 0L;
        String sourceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileElement.getFileName();
        File file = new File(sourceTempPath);
        String status = PCHelperConstant.REVISION_STATUS.ADDED.toString();
        double filesizeInKB = 0.0;
        if (file.exists()) {
            filesize = file.length();
            filesizeInKB = Math.ceil((double)filesize / 1024.0);
        }
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathWithoutRegex(cloud.getCloudId(), userName, cloud.getCloudName(), fileElement.getFileCompletePath(), fileElement.getFileName(), user, miniCloud);
        if (isMiniCloud && backUpImage != null) {
            backUpImage = null;
        }
        if (backUpImage != null) {
            if (backUpImage.isPresent()) {
                status = PCHelperConstant.REVISION_STATUS.MODIFIED.toString();
                if (backUpImage.isFolder() && fileElement.isFolder() || backUpImage.isFolder() && !fileElement.isFolder() || !backUpImage.isFolder() && fileElement.isFolder()) {
                    return searchIndexes;
                }
                if (backUpImage.getMd5Checksum().equals(fileElement.getMd5checksum())) {
                    if (file.exists()) {
                        file.delete();
                    }
                    return searchIndexes;
                }
            }
            backUpImage.setPresent(true);
            backUpImage.setSize((long)filesizeInKB);
            backUpImage.setCrawlStartTimestamp(currentTime);
            backUpImage.setLastServerModifiedTime(currentTime);
            backUpImage.setMd5Checksum(fileElement.getMd5checksum() == null ? "null" : fileElement.getMd5checksum());
            backUpImage.setFolder(fileElement.isFolder());
            backUpImage.setDeviceUUID("0000000000");
        } else {
            backUpImage = new BackUpImage();
            this.convertToSyncBackUpImage(fileElement, backUpImage, "Portal");
            backUpImage.setPresent(true);
            backUpImage.setSize((long)filesizeInKB);
        }
        backUpImage.setUserName(userName);
        backUpImage.setStatus(status);
        backUpImage.setfSPath(PathGenerator.getFsPath((String)backUpImage.getMd5Checksum()));
        backUpImage.setSync(true);
        backUpImage.setMiniCloud(isMiniCloud);
        this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), backUpImage, user, miniCloud);
        if (isPathInsideMiniCoud) {
            this.updateModifiedTimeStamp(cloudId, null, cloudName, fileElement.getFileCompletePath(), currentTime, null, miniCloud);
        } else {
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, fileElement.getFileCompletePath(), currentTime, user, miniCloud);
        }
        if (backUpImage.isFolder()) {
            return searchIndexes;
        }
        String destinationPath = PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath();
        File parent = new File(destinationPath);
        File f = parent.getParentFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)filesize);
        FileUtils.moveFile((File)new File(sourceTempPath), (File)new File(destinationPath));
        ThumbnailHelper.createThumbnails((String)cloudName, (String)(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath()), (String)("ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath()), (String)FilenameUtils.getExtension((String)backUpImage.getFileName()));
        return searchIndexes;
    }

    @Override
    public List<SearchIndex> uploadMCResourceFile(Cloud cloud, String userName, FileElement fileElement, MiniCloud miniCloud) throws Exception {
        long currentTime = System.currentTimeMillis();
        String mcName = fileElement.getFileName();
        char[] cArray = "/*\":<>".toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (!mcName.contains(c.toString())) continue;
            return null;
        }
        long fileSize = 0L;
        String sourceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName()) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileElement.getFileName();
        File file = new File(sourceTempPath);
        String status = PCHelperConstant.REVISION_STATUS.ADDED.toString();
        double filesizeInKB = 0.0;
        if (file.exists()) {
            fileSize = file.length();
            filesizeInKB = Math.ceil((double)fileSize / 1024.0);
        }
        BackUpImage backUpImage = new BackUpImage();
        this.convertToSyncBackUpImage(fileElement, backUpImage, "Portal");
        backUpImage.setMiniCloud(true);
        backUpImage.setPresent(true);
        backUpImage.setSize((long)filesizeInKB);
        backUpImage.setUserName(userName);
        backUpImage.setStatus(status);
        backUpImage.setSync(true);
        backUpImage.setfSPath(PathGenerator.getFsPath((String)backUpImage.getMd5Checksum()));
        this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), backUpImage, null, miniCloud);
        return new ArrayList<SearchIndex>(SearchIndexHelper.addorUpdateIndex((int)cloud.getCloudId(), (String)cloud.getCloudName(), (BackUpImage)backUpImage));
    }

    @Override
    public String insertSyncEntryForFileUsingPortal(int cloudId, String cloudName, Cloud cloud, FileElement fileElement, String userName, boolean isPathInsideMC, String deviceUUID, boolean isFileInfected) throws Exception {
        String parentFilePathTemp;
        long currentTime = System.currentTimeMillis();
        String name = fileElement.getFileName();
        String regID = "Portal".equals(deviceUUID) ? "0000000000" : deviceUUID;
        char[] cArray = "/*\":<>".toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (!name.contains(c.toString())) continue;
            return "SPECIAL_CHARACTERS";
        }
        FileRevision fileRevision = new FileRevision();
        long filesize = 0L;
        String status = PCHelperConstant.REVISION_STATUS.ADDED.toString();
        double filesizeInKB = Math.ceil(Double.parseDouble(fileElement.getSize()) / 1024.0);
        String userNameVal = userName;
        if (isPathInsideMC) {
            userNameVal = "";
        }
        String devicePath = parentFilePathTemp = fileElement.getFileCompletePath();
        if (parentFilePathTemp.endsWith("/")) {
            int lastIndex = parentFilePathTemp.lastIndexOf(47);
            devicePath = parentFilePathTemp.substring(0, lastIndex);
        }
        fileElement.setFileCompletePath(devicePath);
        logger.debug(".....completepath and filename..." + fileElement.getFileCompletePath() + "......" + fileElement.getFileName());
        ConsolidatedImage imageFile = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), fileElement.getFileCompletePath(), fileElement.getFileName());
        double storageUtilized = 0.0;
        if (imageFile != null) {
            logger.debug(".....already db entry is there check md5....");
            if (imageFile.isPresent()) {
                status = PCHelperConstant.REVISION_STATUS.MODIFIED.toString();
                logger.debug(".....already db entry is there check md51...." + imageFile.getMD5() + "...chec.." + fileElement.getMd5checksum());
            }
            try {
                File fileObj = new File(fileElement.getFileCompletePath());
                logger.debug(".....check if folder exists...." + fileObj.getParent() + ".....path.,," + fileObj.getName());
                ConsolidatedImage folderPathExists = null;
                String[] paths = fileElement.getFileCompletePath().split(File.separator.equals("\\") ? "\\\\" : "/");
                String currentPath = "";
                for (String path : paths) {
                    if (StringUtils.isEmpty((String)currentPath)) {
                        currentPath = path;
                    } else {
                        folderPathExists = this.consolidatedImageDao.getExistingConsolidatedImageDBRecordByDevicePathForFolderLatest(cloudId, userNameVal, cloudName, currentPath, path);
                        if (folderPathExists != null && !folderPathExists.isPresent()) {
                            logger.debug(".....folder does  exists but it is deleted...." + folderPathExists.isPresent());
                            this.consolidatedImageDao.updateDeletedFolder(cloudId, folderPathExists.getId());
                        }
                        currentPath = currentPath + "/" + path;
                    }
                    logger.debug(".....pathhss are ...." + currentPath);
                }
            }
            catch (Exception e) {
                logger.error("...error trying to restore deleted folders....");
            }
            imageFile.setPresent(true);
            imageFile.setSize(filesizeInKB);
            imageFile.setCrawlStartTimestamp(currentTime);
            imageFile.setModifiedTime(String.valueOf(currentTime));
            imageFile.setMD5(fileElement.getMd5checksum() == null ? "null" : fileElement.getMd5checksum());
            imageFile.setFolder(fileElement.isFolder());
            imageFile.setRegID(regID);
            imageFile.setMetaData(fileElement.getMetaData() == null ? "null" : fileElement.getMetaData());
            imageFile.setFileInfected(isFileInfected);
            this.handleVersioning(cloud, cloudName, imageFile, userNameVal);
        } else {
            imageFile = new ConsolidatedImage();
            imageFile.setFileInfected(isFileInfected);
            this.convertToConsolidatedImage(fileElement, regID, imageFile);
            imageFile.setPresent(true);
            imageFile.setSize(filesizeInKB);
        }
        User user = this.userDao.getUserByName(1, userName);
        logger.debug("$$$$$$$$ updating storage for sync user$$$$$$" + user);
        if (user != null) {
            UserSyncOverView userSyncOverView = user.getUserSyncOverView();
            logger.debug("$$$$$$$$ updating storage for sync user$$$$$$" + userSyncOverView);
            if (userSyncOverView != null) {
                storageUtilized = userSyncOverView.getStorageUtilized();
                storageUtilized += filesizeInKB;
            } else {
                userSyncOverView = new UserSyncOverView();
            }
            userSyncOverView.setStorageUtilized(storageUtilized);
            this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloudId, userSyncOverView);
        }
        imageFile.setUserName(userName);
        File fileObj = new File(fileElement.getFileCompletePath());
        ConsolidatedImage folderPathExists = this.consolidatedImageDao.getExistingConsolidatedImageDBRecordByDevicePathForFolder(cloudId, userNameVal, cloudName, fileObj.getParent(), fileObj.getName());
        logger.debug("..parent and name.." + fileObj.getParent() + "...." + fileObj.getName());
        if (folderPathExists == null) {
            String[] paths = fileElement.getFileCompletePath().split(File.separator.equals("\\") ? "\\\\" : "/");
            String currentPath = "";
            for (String path : paths) {
                if (StringUtils.isEmpty((String)currentPath)) {
                    currentPath = path;
                } else {
                    folderPathExists = this.consolidatedImageDao.getExistingConsolidatedImageDBRecordByDevicePathForFolder(cloudId, userNameVal, cloudName, currentPath, path);
                    if (folderPathExists == null) {
                        ConsolidatedImage consolidatedImage = new ConsolidatedImage();
                        BeanUtils.copyProperties((Object)imageFile, (Object)consolidatedImage);
                        consolidatedImage.setFolder(true);
                        consolidatedImage.setDevicePath(currentPath);
                        consolidatedImage.setFileName(path);
                        this.consolidatedImageDao.saveToConsolidatedImageDB(cloud.getCloudId(), cloud.getCloudName(), consolidatedImage);
                        FileRevision fileRevisionval = new FileRevision();
                        this.convertConsolidatedImageToFileRevision(consolidatedImage, fileRevisionval);
                        fileRevisionval.setStatus(status);
                        fileRevisionval.setUserName(userName);
                        fileRevisionval.setGatewayName(fileElement.getGatewayName());
                        this.fileRevisionDao.saveRevision(cloud.getCloudId(), cloud.getCloudName(), fileRevisionval);
                    }
                    currentPath = currentPath + "/" + path;
                }
                logger.debug(".....pathhss are ...." + currentPath);
            }
        }
        this.consolidatedImageDao.saveToConsolidatedImageDB(cloud.getCloudId(), cloud.getCloudName(), imageFile);
        logger.debug(".......fileName......." + imageFile.getFileName());
        this.convertConsolidatedImageToFileRevision(imageFile, fileRevision);
        fileRevision.setStatus(status);
        fileRevision.setUserName(userName);
        fileRevision.setGatewayName(fileElement.getGatewayName());
        this.fileRevisionDao.saveRevision(cloud.getCloudId(), cloud.getCloudName(), fileRevision);
        if (isPathInsideMC) {
            this.updateModifiedTimeStamp(cloudId, null, cloudName, fileElement.getFileCompletePath(), currentTime);
        } else {
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, fileElement.getFileCompletePath(), currentTime);
        }
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)filesize);
        return fileRevision.getId().toString() + "-" + fileRevision.getConsolidatedImage().getId().toString();
    }

    private void handleVersioning(Cloud cloud, String cloudName, ConsolidatedImage imageFile, String userName) {
        SyncPolicy syncPolicy;
        logger.debug(" inside delete revisions........");
        if (cloud.getVersioningEnabled() == 0) {
            return;
        }
        int maxVersionsAllowed = 0;
        User user = this.userDao.getUserByName(cloud.getCloudId(), userName);
        if (user != null && !StringUtils.isEmpty((String)user.getSyncPolicyName()) && (syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloud.getCloudId(), user.getSyncPolicyName())) != null) {
            maxVersionsAllowed = syncPolicy.getMaxVersions();
        }
        if (maxVersionsAllowed == 0 || maxVersionsAllowed == -1) {
            return;
        }
        long versionCount = this.fileRevisionDao.getCountOfVersionsForFile(cloud.getCloudId(), imageFile.getId());
        if (versionCount <= (long)maxVersionsAllowed) {
            return;
        }
        FileRevision fileRevision2 = this.fileRevisionDao.getFirstOldRevisionByRevisionNumber(cloud.getCloudId(), imageFile.getId(), cloud.getVersioningEnabled());
        if (fileRevision2 != null) {
            logger.debug(" deleted revisions............");
            this.externalStorageBackupFileDao.deleteRevision(cloud.getCloudId(), cloudName, fileRevision2);
            BackupFile backupFile = this.externalStorageBackupFileDao.getSyncFile(cloud.getCloudId(), cloudName, userName, fileRevision2.getId().toString());
            List chunkFiles = backupFile.getChunkFiles();
            for (ChunkFile chunkFile : chunkFiles) {
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5());
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    logger.debug(" Chunk updated succcessfully ..........");
                }
                catch (OptimisticLockingFailureException e) {
                    int count = 0;
                    int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    while (true) {
                        try {
                            logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                            ChunkDetail chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd5(1, chunkFile.getMd5());
                            chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                            logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                            this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                        }
                        catch (Exception ex) {
                            logger.trace("" + ex);
                            logger.error(" ex ..." + ex.getMessage());
                            if (++count != maxTries) continue;
                        }
                        break;
                    }
                    logger.trace("" + (Object)((Object)e));
                    logger.error("Exception while handeling version " + e.getMessage());
                }
            }
        }
    }

    private void handleVersioning(Cloud cloud, String cloudName, ConsolidatedImage imageFile) {
    }

    public void handleVersioningOld(Cloud cloud, String cloudName, ConsolidatedImage imageFile) {
        if (cloud.getVersioningEnabled() == 0) {
            return;
        }
        FileRevision fileRevision2 = this.fileRevisionDao.getPresentRevisionByRevisionNumber(cloud.getCloudId(), cloud.getCloudName(), imageFile.getId(), cloud.getVersioningEnabled());
        if (fileRevision2 != null) {
            logger.debug(" deleted revisions............");
            this.deleteFileRevisionPermanently(cloud.getCloudId(), cloud.getCloudName(), new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileRevision2.getfSPath()), fileRevision2);
        }
    }

    @Override
    public List<ConsolidatedImage> getConsolidatedImageListToCut(int cloudId, String userName, String cloudName, FileElement file) {
        Date date = new Date();
        long currentTimeStamp = date.getTime();
        ArrayList<ConsolidatedImage> fileListFromDatabase = new ArrayList<ConsolidatedImage>();
        ConsolidatedImage ci = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, file.getFileCompletePath(), file.getFileName());
        if (ci != null && ci.isPresent()) {
            logger.debug("adding base consoimage to cut." + file.getFileCompletePath() + "/" + file.getFileName());
            fileListFromDatabase.add(ci);
        } else {
            logger.debug("ERROR: base image shud be present and shud not be null");
        }
        if (file.isFolder()) {
            fileListFromDatabase.addAll(this.consolidatedImageDao.getAllExistingRecordsBeforeCurrentTimeStamp(cloudId, userName, cloudName, currentTimeStamp, file.getFileCompletePath() + "/" + file.getFileName()));
        }
        logger.debug("size returned from getConsolidatedImageListToCut : " + fileListFromDatabase.size());
        if (fileListFromDatabase.isEmpty()) {
            return null;
        }
        return fileListFromDatabase;
    }

    @Override
    public List<ConsolidatedImage> saveFinalConsolidatedFileList(int cloudId, String userName, String cloudName, List<ConsolidatedImage> imageList, boolean isPresent) {
        ArrayList<ConsolidatedImage> images = new ArrayList<ConsolidatedImage>();
        for (ConsolidatedImage fileImage : imageList) {
            ConsolidatedImage image = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, fileImage.getDevicePath(), fileImage.getFileName());
            if (image != null) {
                logger.debug("record found: " + image.getDevicePath() + "/" + image.getFileName() + "ispresent:" + isPresent);
                this.copyConsolidatedImage(fileImage, "0000000000", image, System.currentTimeMillis());
                image.setPresent(isPresent);
                this.consolidatedImageDao.saveToConsolidatedImageDB(cloudId, cloudName, image);
                images.add(image);
                continue;
            }
            logger.debug("Inserting new record: " + fileImage.getDevicePath() + "/" + fileImage.getFileName() + "ispresent:" + isPresent);
            fileImage.setPresent(isPresent);
            this.consolidatedImageDao.saveToConsolidatedImageDB(cloudId, cloudName, fileImage);
            images.add(fileImage);
        }
        return images;
    }

    private String buildDestinationDevicePath(String originalSourcePath, String newSourcePath, String destinationPath) {
        String path = "";
        if (newSourcePath.startsWith(originalSourcePath)) {
            String temp = newSourcePath.substring(originalSourcePath.length());
            path = destinationPath + temp;
        }
        return path;
    }

    private void convertToConsolidatedImage(FileElement fileElement, String regID, ConsolidatedImage conso) {
        String parentFilePathTemp = fileElement.getFileCompletePath();
        String devicePath = fileElement.getFileCompletePath();
        if (parentFilePathTemp.endsWith("/")) {
            int lastIndex = parentFilePathTemp.lastIndexOf(47);
            devicePath = parentFilePathTemp.substring(0, lastIndex);
        }
        fileElement.setFileCompletePath(devicePath);
        conso.setDevicePath(fileElement.getFileCompletePath());
        conso.setFileName(fileElement.getFileName());
        logger.debug(fileElement.getFileCompletePath() + "....convertToConsolidatedImage...." + fileElement.getFileName());
        long modifiedTimeStampDate = fileElement.getLastModifiedTimestamp();
        long timeMilliSec = System.currentTimeMillis();
        conso.setCrawlStartTimestamp(timeMilliSec);
        conso.setFolder(fileElement.isFolder());
        conso.setPresent(fileElement.isExists());
        if (fileElement.getMd5checksum() == null || "".equals(fileElement.getMd5checksum())) {
            conso.setMD5("null");
        } else {
            conso.setMD5(fileElement.getMd5checksum());
        }
        conso.setMetaData(fileElement.getMetaData());
        conso.setRegID(regID);
        if (modifiedTimeStampDate <= 0L) {
            conso.setModifiedTime(String.valueOf(timeMilliSec));
        } else {
            conso.setModifiedTime(String.valueOf(modifiedTimeStampDate));
        }
        try {
            if (fileElement.getSize() != null && fileElement.getSize() != "") {
                conso.setSize(Double.parseDouble(fileElement.getSize()));
            }
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            logger.trace("Exception" + e);
            logger.error("Exception`" + e.getMessage());
        }
    }

    private void convertToSyncBackUpImage(FileElement fileElement, BackUpImage backUpImage, String deviceUUID) {
        String parentFilePathTemp = fileElement.getFileCompletePath();
        String devicePath = fileElement.getFileCompletePath();
        if (parentFilePathTemp.endsWith("/")) {
            int lastIndex = parentFilePathTemp.lastIndexOf(47);
            devicePath = parentFilePathTemp.substring(0, lastIndex);
        }
        fileElement.setFileCompletePath(devicePath);
        backUpImage.setDevicePath(fileElement.getFileCompletePath());
        backUpImage.setFileName(fileElement.getFileName());
        logger.debug(fileElement.getFileCompletePath() + "....convertToBackUpImage...." + fileElement.getFileName());
        long modifiedTimeStampDate = fileElement.getLastModifiedTimestamp();
        long timeMilliSec = System.currentTimeMillis();
        backUpImage.setCrawlStartTimestamp(timeMilliSec);
        backUpImage.setFolder(fileElement.isFolder());
        backUpImage.setPresent(fileElement.isExists());
        if (fileElement.getMd5checksum() == null || "".equals(fileElement.getMd5checksum())) {
            backUpImage.setMd5Checksum("null");
        } else {
            backUpImage.setMd5Checksum(fileElement.getMd5checksum());
        }
        backUpImage.setDeviceUUID(deviceUUID);
        if (modifiedTimeStampDate <= 0L) {
            backUpImage.setLastServerModifiedTime(timeMilliSec);
        } else {
            backUpImage.setLastServerModifiedTime(modifiedTimeStampDate);
        }
        try {
            if (fileElement.getSize() != null && fileElement.getSize() != "") {
                backUpImage.setSize((long)Double.parseDouble(fileElement.getSize()));
            }
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            logger.trace("Exception" + e);
            logger.error("Exception`" + e.getMessage());
        }
    }

    @Override
    public ShareAndSearchDLTO renameResourceFile(int cloudId, String cloudName, Cloud cloud, String dPath, String oldFileName, String newFileName, String userName, String deviceName, boolean isPathInsideMC, boolean isFolder) {
        double sizeIncremental = 0.0;
        ArrayList arrayOfSizes = new ArrayList();
        String userNameVal = userName;
        User user = null;
        MiniCloud miniCloud = null;
        if (isPathInsideMC) {
            userNameVal = "";
            String mcName = ResourceSyncServiceImpl.getMCName(dPath);
            miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, mcName);
        } else {
            user = this.userDao.getUserByName(cloud.getCloudId(), userName);
        }
        BackUpImage backUpImageNew = this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), dPath, newFileName, user, miniCloud);
        if (backUpImageNew != null) {
            return null;
        }
        BackUpImage backUpImageOld = null;
        backUpImageOld = isFolder ? this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), dPath, oldFileName, user, miniCloud) : this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloud.getCloudId(), userNameVal, dPath, oldFileName, user, miniCloud);
        if (backUpImageOld == null) {
            return null;
        }
        ArrayList<String> sharedFileNameList = new ArrayList<String>();
        ArrayList<String> sharedDevicePathList = new ArrayList<String>();
        ArrayList searchIndexs = new ArrayList();
        BackUpImage backUpImageRecord = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), dPath, newFileName, user, miniCloud);
        long timeMilliSec = System.currentTimeMillis();
        if (!backUpImageOld.isFolder()) {
            BackUpImage backUpImage = new BackUpImage();
            BeanUtils.copyProperties((Object)backUpImageOld, (Object)backUpImage, (String[])new String[]{"id"});
            backUpImage.setLastServerModifiedTime(timeMilliSec);
            backUpImage.setCrawlStartTimestamp(timeMilliSec);
            backUpImage.setFileName(newFileName);
            backUpImage.setUserName(userName);
            backUpImage.setDeviceUUID("Portal");
            backUpImage.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
            if (backUpImageRecord != null) {
                this.handleVersioning(cloud, backUpImage, userName, userNameVal, user, miniCloud);
            }
            logger.debug(userName + "saving: " + backUpImageOld.getDevicePath() + "/" + newFileName);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), backUpImage, user, miniCloud);
            this.increaseRefCountInChunkDetail(cloudId, backUpImageOld.getChunkFiles(), backUpImageOld.getUserName());
            BackUpImage sourceBackUpImageLatestVersion = this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), dPath, oldFileName, user, miniCloud);
            BackUpImage sourceImageDelete = new BackUpImage();
            BeanUtils.copyProperties((Object)sourceBackUpImageLatestVersion, (Object)sourceImageDelete, (String[])new String[]{"id"});
            sourceImageDelete.setLastServerModifiedTime(timeMilliSec);
            sourceImageDelete.setCrawlStartTimestamp(timeMilliSec);
            sourceImageDelete.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
            sourceImageDelete.setDeviceUUID("Portal");
            sourceImageDelete.setPresent(false);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), sourceImageDelete, user, miniCloud);
            this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, sourceBackUpImageLatestVersion);
            sizeIncremental += (double)backUpImage.getSize();
        } else {
            logger.debug("will rename children now....copying renaming relative paths in children");
            String originalSourcePath = dPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + oldFileName;
            String newDestinationPath = dPath + "/" + newFileName;
            Date date = new Date();
            long currentTimeStamp = date.getTime();
            ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
            folderList.add(backUpImageOld);
            this.getChildFoldersForBaseFolder(cloud.getCloudId(), cloud.getCloudName(), userNameVal, originalSourcePath, folderList, user, miniCloud, true);
            logger.debug("Number of subfolders inside the base folder : " + folderList.size());
            for (BackUpImage subFolder : folderList) {
                String folderDevicePath = subFolder.getDevicePath() + "/" + subFolder.getFileName();
                List fileListFromDatabase = this.syncBackUpImageDAO.getLatestExistingRecordsBeforeCurrentTimeStampForPath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), currentTimeStamp, folderDevicePath, user, miniCloud);
                logger.debug("Subfolder :  " + subFolder.getDevicePath() + "/" + subFolder.getFileName() + " Number of files : " + fileListFromDatabase.size());
                for (BackUpImage sourceSubFolderFile : fileListFromDatabase) {
                    sourceSubFolderFile = this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloudId, userNameVal, sourceSubFolderFile.getDevicePath(), sourceSubFolderFile.getFileName(), user, miniCloud);
                    String newPath = this.buildDestinationDevicePath(originalSourcePath, sourceSubFolderFile.getDevicePath(), newDestinationPath);
                    logger.debug(NEW_DESTINATION_PATH + newPath);
                    if (newPath.isEmpty() || "".equals(newPath)) continue;
                    BackUpImage backUpImageChildRecord = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userName, cloud.getCloudName(), newPath, sourceSubFolderFile.getFileName(), user, miniCloud);
                    BackUpImage backUpImageNewPath = new BackUpImage();
                    if (!sourceSubFolderFile.isPresent()) continue;
                    BeanUtils.copyProperties((Object)sourceSubFolderFile, (Object)backUpImageNewPath, (String[])new String[]{"id"});
                    backUpImageNewPath.setDevicePath(newPath);
                    backUpImageNewPath.setLastServerModifiedTime(timeMilliSec);
                    backUpImageNewPath.setCrawlStartTimestamp(timeMilliSec);
                    backUpImageNewPath.setUserName(userName);
                    backUpImageNewPath.setPresent(true);
                    backUpImageNewPath.setDeviceUUID("Portal");
                    backUpImageNewPath.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
                    if (backUpImageChildRecord != null) {
                        this.handleVersioning(cloud, backUpImageNewPath, userName, userNameVal, user, miniCloud);
                    }
                    this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), backUpImageNewPath, user, miniCloud);
                    this.increaseRefCountInChunkDetail(cloudId, sourceSubFolderFile.getChunkFiles(), sourceSubFolderFile.getUserName());
                    BackUpImage sourceChildImageDelete = new BackUpImage();
                    BeanUtils.copyProperties((Object)sourceSubFolderFile, (Object)sourceChildImageDelete, (String[])new String[]{"id"});
                    sourceChildImageDelete.setLastServerModifiedTime(currentTimeStamp);
                    sourceChildImageDelete.setCrawlStartTimestamp(currentTimeStamp);
                    sourceChildImageDelete.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
                    sourceChildImageDelete.setDeviceUUID("Portal");
                    sourceChildImageDelete.setPresent(false);
                    this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), sourceChildImageDelete, user, miniCloud);
                    this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, sourceSubFolderFile);
                    logger.debug(userName + FILE_TO_COPY + newPath + "/" + sourceSubFolderFile.getFileName());
                    sizeIncremental += (double)backUpImageNewPath.getSize();
                }
                BackUpImage folderBackUpImageNewPath = new BackUpImage();
                BeanUtils.copyProperties((Object)subFolder, (Object)folderBackUpImageNewPath, (String[])new String[]{"id"});
                folderBackUpImageNewPath.setLastServerModifiedTime(timeMilliSec);
                folderBackUpImageNewPath.setCrawlStartTimestamp(timeMilliSec);
                folderBackUpImageNewPath.setUserName(userName);
                folderBackUpImageNewPath.setPresent(true);
                folderBackUpImageNewPath.setDeviceUUID("Portal");
                folderBackUpImageNewPath.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
                if (subFolder.getFileName().equalsIgnoreCase(oldFileName) && subFolder.getDevicePath().equalsIgnoreCase(dPath)) {
                    folderBackUpImageNewPath.setFileName(newFileName);
                    folderBackUpImageNewPath.setDevicePath(subFolder.getDevicePath());
                } else {
                    String newSubFolderPath = this.buildDestinationDevicePath(originalSourcePath, subFolder.getDevicePath(), newDestinationPath);
                    folderBackUpImageNewPath.setDevicePath(newSubFolderPath);
                }
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), folderBackUpImageNewPath, user, miniCloud);
                BackUpImage folderSourceSubFolderDelete = new BackUpImage();
                BeanUtils.copyProperties((Object)subFolder, (Object)folderSourceSubFolderDelete);
                folderSourceSubFolderDelete.setLastServerModifiedTime(currentTimeStamp);
                folderSourceSubFolderDelete.setCrawlStartTimestamp(currentTimeStamp);
                folderSourceSubFolderDelete.setDeviceUUID("Portal");
                folderSourceSubFolderDelete.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
                folderSourceSubFolderDelete.setPresent(false);
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), folderSourceSubFolderDelete, user, miniCloud);
                this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, subFolder);
            }
        }
        if (isPathInsideMC) {
            this.updateModifiedTimeStamp(cloudId, null, cloudName, dPath, timeMilliSec, null, miniCloud);
        } else {
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, dPath, timeMilliSec, user, miniCloud);
        }
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)Math.round(sizeIncremental));
        String mcNameFromPath = "";
        if (isPathInsideMC) {
            mcNameFromPath = ResourceSyncServiceImpl.getMCName(dPath);
        }
        oldFileName = dPath + "/" + oldFileName;
        newFileName = dPath + "/" + newFileName;
        this.saveStatisticToDatabase(cloudId, cloudName, "renamed", userName, oldFileName + " to " + newFileName, deviceName, System.currentTimeMillis(), backUpImageOld.getDevicePath(), isPathInsideMC, mcNameFromPath);
        return new ShareAndSearchDLTO(searchIndexs, sharedFileNameList, sharedDevicePathList);
    }

    @Override
    public List<BackUpImage> getDeletedResourceFilesForTrash(int cloudId, String cloudName, String userName, User user) {
        ArrayList<BackUpImage> deletedImagesList = new ArrayList<BackUpImage>();
        List userMiniClouds = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudName, userName).getMiniClouds();
        for (MiniCloudElement miniCloudElement : userMiniClouds) {
            MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudElement.getMiniCloudName());
            String devicePath = "ParaBlu/" + miniCloudElement.getMiniCloudName();
            List miniCloudFilesDeletedList = this.syncBackUpImageDAO.getDeletedBackupImagesByMiniCloud(cloudId, devicePath, miniCloud);
            deletedImagesList.addAll(miniCloudFilesDeletedList);
        }
        List userFilesDeletedList = this.syncBackUpImageDAO.getDeletedBackupImagesByUser(cloudId, userName, user);
        deletedImagesList.addAll(userFilesDeletedList);
        return deletedImagesList;
    }

    private void handleVersioning(Cloud cloud, BackUpImage backUpImage, String userName, String userNameVal, User user, MiniCloud miniCloud) {
        SyncPolicy syncPolicy;
        logger.debug("--- Inside handle versioning for sync backup image ---");
        if (cloud.getVersioningEnabled() == 0) {
            return;
        }
        int maxVersionsAllowed = 0;
        User userByName = this.userDao.getUserByName(cloud.getCloudId(), userName);
        if (userByName != null && !StringUtils.isEmpty((String)userByName.getSyncPolicyName()) && (syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloud.getCloudId(), userByName.getSyncPolicyName())) != null) {
            maxVersionsAllowed = syncPolicy.getMaxVersions();
        }
        if (maxVersionsAllowed == 0 || maxVersionsAllowed == -1) {
            return;
        }
        long versionCount = this.syncBackUpImageDAO.getCountOfVersionsForFile(cloud.getCloudId(), backUpImage, user, miniCloud);
        if (versionCount < (long)maxVersionsAllowed) {
            return;
        }
        List backUpImagesList = this.syncBackUpImageDAO.getVersions(cloud.getCloudId(), cloud.getCloudName(), userNameVal, backUpImage.getFileName(), backUpImage.getDevicePath(), user, miniCloud);
        List backUpImagesSorted = backUpImagesList.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).collect(Collectors.toList());
        for (BackUpImage sortedBackUpImage : backUpImagesSorted) {
            logger.debug("BackUpImage : " + sortedBackUpImage.getId() + " status : " + sortedBackUpImage.getStatus() + " current number of versions : " + versionCount);
            if ((long)maxVersionsAllowed > versionCount && maxVersionsAllowed != 0) {
                if (!sortedBackUpImage.getStatus().equalsIgnoreCase(DELETED) && !sortedBackUpImage.getStatus().equalsIgnoreCase(RESTORED)) break;
                this.removeSyncBackUpImage(sortedBackUpImage, cloud.getCloudId(), cloud.getCloudName(), user, miniCloud);
            }
            if (sortedBackUpImage.isBusy()) {
                logger.debug("BackUpImage is busy, will not delete : " + sortedBackUpImage.getId());
                continue;
            }
            if (!sortedBackUpImage.getStatus().equalsIgnoreCase(DELETED) && !sortedBackUpImage.getStatus().equalsIgnoreCase(RESTORED)) {
                UserSyncOverView userSyncOverView;
                this.removeSyncBackUpImage(sortedBackUpImage, cloud.getCloudId(), cloud.getCloudName(), user, miniCloud);
                --versionCount;
                if (user == null || (userSyncOverView = user.getUserSyncOverView()) == null) continue;
                double storageUtilized = userSyncOverView.getStorageUtilized();
                userSyncOverView.setStorageUtilized(storageUtilized -= (double)backUpImage.getSize());
                this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloud.getCloudId(), userSyncOverView);
                continue;
            }
            this.removeSyncBackUpImage(sortedBackUpImage, cloud.getCloudId(), cloud.getCloudName(), user, miniCloud);
        }
    }

    private void removeSyncBackUpImage(BackUpImage backUpImage, int cloudId, String cloudName, User user, MiniCloud miniCloud) {
        this.syncBackUpImageDAO.deleteBackUpImage(cloudId, backUpImage, user, miniCloud);
        if (!backUpImage.getStatus().equalsIgnoreCase(DELETED) && !backUpImage.getStatus().equalsIgnoreCase(RESTORED)) {
            List chunkFiles = backUpImage.getChunkFiles();
            for (ChunkFile chunkFile : chunkFiles) {
                String dedupVal = this.getDedupValue(backUpImage.getUserName());
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, backUpImage.getUserName(), true, false);
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(cloudId, chunkDetail);
                    logger.debug("--- Chunk details updated successfully ---");
                }
                catch (OptimisticLockingFailureException e) {
                    int count = 0;
                    int maxRetries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    while (true) {
                        try {
                            logger.debug("--- Retry chunk detail update --- " + chunkFile.getMd5() + " --- Retry count ---" + count);
                            ChunkDetail chunkDetailRetry = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, backUpImage.getUserName(), true, false);
                            chunkDetailRetry.setRefCount(chunkDetailRetry.getRefCount() - 1);
                            this.externalStorageBackupFileDao.saveChunkDetail(cloudId, chunkDetailRetry);
                        }
                        catch (Exception ex) {
                            logger.error("--- Exception during retry chunk details update --- " + ex.getMessage());
                            logger.trace("--- Exception stack trace --- ", (Throwable)ex);
                            if (++count != maxRetries) continue;
                        }
                        break;
                    }
                    logger.error("--- Exception while handling version for Image --- " + e.getMessage());
                    logger.trace("--- Exception stack trace --- ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void updateModifiedTimeStamp(int cloudId, String userName, String cloudName, String tempPath, long time, User user, MiniCloud miniCloud) {
        String[] params;
        String path = tempPath;
        while (!path.isEmpty() && path != "" && (params = path.split("/")).length > 1) {
            String fName = params[params.length - 1];
            String fPath = path.substring(0, path.length() - (fName.length() + 1));
            BackUpImage iFile = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, fPath, fName, user, miniCloud);
            if (iFile == null || !iFile.isFolder() || !iFile.isPresent()) break;
            iFile.setLastServerModifiedTime(time);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, iFile, user, miniCloud);
            path = fPath;
        }
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    private void copyConsolidatedImage(ConsolidatedImage sourceFile, String portalRegId, ConsolidatedImage consolidatedImageNewRecord, long l) {
        consolidatedImageNewRecord.setDevicePath(sourceFile.getDevicePath());
        consolidatedImageNewRecord.setFileName(sourceFile.getFileName());
        consolidatedImageNewRecord.setSize(sourceFile.getSize());
        consolidatedImageNewRecord.setCrawlStartTimestamp(l);
        consolidatedImageNewRecord.setFolder(sourceFile.isFolder());
        consolidatedImageNewRecord.setPresent(sourceFile.isPresent());
        consolidatedImageNewRecord.setMD5(sourceFile.getMD5());
        consolidatedImageNewRecord.setMetaData(sourceFile.getMetaData());
        consolidatedImageNewRecord.setRegID(portalRegId);
        consolidatedImageNewRecord.setModifiedTime(String.valueOf(l));
        consolidatedImageNewRecord.setUserName(sourceFile.getUserName());
    }

    @Override
    public List<FileElement> getDeletedResourceFiles(int cloudId, String cloudName, int pageNum, int rows, String userName, String deviceName, FileListElement fileListElement, User user) {
        ArrayList<FileElement> fileElementList = new ArrayList<FileElement>();
        ArrayList deletedImagesList = new ArrayList();
        List userMiniClouds = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudName, userName).getMiniClouds();
        for (MiniCloudElement miniCloudElement : userMiniClouds) {
            MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudElement.getMiniCloudName());
            String devicePath = "ParaBlu/" + miniCloudElement.getMiniCloudName();
            List miniCloudFilesDeletedList = this.syncBackUpImageDAO.getDeletedBackupImagesByMiniCloud(cloudId, devicePath, miniCloud);
            deletedImagesList.addAll(miniCloudFilesDeletedList);
        }
        List userFilesDeletedList = this.syncBackUpImageDAO.getDeletedBackupImagesByUser(cloudId, userName, user);
        deletedImagesList.addAll(userFilesDeletedList);
        for (BackUpImage backUpImageElement : deletedImagesList) {
            FileElement fileElement = new FileElement();
            this.convertBackupImageToFileElement(cloudId, cloudName, backUpImageElement, fileElement);
            fileElementList.add(fileElement);
        }
        fileListElement.setTotalNoofFiles(String.valueOf(deletedImagesList.size()));
        return fileElementList;
    }

    @Override
    public Long getCountOfAlldeletedResourceFiles(int cloudId, String cloudName) {
        return this.fileRevisionDao.getCountOfAllFileRevisionsHavingStatus(cloudId, cloudName, PCHelperConstant.REVISION_STATUS.DELETED.toString());
    }

    @Override
    public List<FileRevision> getAlldeletedResourceFileRevision(int cloudId, String cloudName, int pageNum, int rows, String userName, String deviceName) {
        long lastDelTask = 0L;
        User user = null;
        if (userName != null) {
            user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        }
        if (user != null && !user.isAdmin()) {
            int offset = this.getOffset(pageNum, rows);
            ArrayList<FileRevision> deletedImageList = new ArrayList<FileRevision>();
            ArrayList<FileRevision> fileRevisions = new ArrayList<FileRevision>();
            List consoIds = this.fileRevisionDao.getLatestFileRevisionConsolidatedIds(cloudId, cloudName, PCHelperConstant.REVISION_STATUS.DELETED.toString(), "", offset, rows);
            if (!CollectionUtils.isEmpty((Collection)consoIds)) {
                for (ObjectId consId : consoIds) {
                    FileRevision fileRevision = this.fileRevisionDao.getAllFileRevisionsForConsoId(cloudId, cloudName, consId);
                    if (fileRevision == null || !fileRevision.getUserName().equalsIgnoreCase(userName)) continue;
                    fileRevisions.add(fileRevision);
                }
                deletedImageList.addAll(fileRevisions);
            }
            List allMiniclouds = this.miniCloudDao.getAllMiniCloud(cloudId, cloudName);
            if (deletedImageList.isEmpty()) {
                return deletedImageList;
            }
            for (FileRevision fileRevision : deletedImageList) {
                if (!fileRevision.getStatus().equals(DELETED)) continue;
                fileRevisions.add(fileRevision);
            }
            for (MiniCloud miniCloud : allMiniclouds) {
                UserCloudAccessControl u = this.userMiniCloudMappingDao.getMiniCloudByName(cloudId, cloudName, user.getUserId(), miniCloud.getId());
                if (u != null) continue;
                List fileImages = this.fileRevisionDao.getAllRevisionsImagesByPath(cloudId, cloudName, "ParaBlu/" + miniCloud.getMiniCloudName(), lastDelTask);
                deletedImageList.removeAll(fileImages);
            }
            return deletedImageList;
        }
        int offset = this.getOffset(pageNum, rows);
        List consoIds = this.fileRevisionDao.getLatestFileRevisionConsolidatedIds(cloudId, cloudName, PCHelperConstant.REVISION_STATUS.DELETED.toString(), "", offset, rows);
        ArrayList<FileRevision> deletedImageList = new ArrayList<FileRevision>();
        ArrayList<FileRevision> fileRevisions = new ArrayList<FileRevision>();
        if (!CollectionUtils.isEmpty((Collection)consoIds)) {
            for (ObjectId consId : consoIds) {
                FileRevision fileRevision = this.fileRevisionDao.getAllFileRevisionsForConsoId(cloudId, cloudName, consId);
                if (fileRevision == null || !fileRevision.getUserName().equalsIgnoreCase(userName)) continue;
                fileRevisions.add(fileRevision);
            }
            deletedImageList.addAll(fileRevisions);
        }
        return deletedImageList;
    }

    private int getOffset(int pageNum, int rows) {
        int offset = 0;
        if (pageNum == 0 && rows > 0) {
            offset = 0;
        } else if (pageNum > 0 && rows > 0) {
            offset = rows * pageNum;
        }
        return offset;
    }

    public void addToFileElementList(int cloudId, String cloudName, FileRevision deleteFileRevision, List<FileElement> fileElements) {
        String extension;
        Device device;
        long lastDelTask = System.currentTimeMillis() - 2592000000L;
        FileElement file = new FileElement();
        ConsolidatedImage imageFile = deleteFileRevision.getConsolidatedImage();
        if (imageFile == null || imageFile.getCrawlStartTimestamp() < lastDelTask || imageFile.isPresent()) {
            return;
        }
        file.setFileName(imageFile.getFileName());
        file.setFolder(imageFile.isFolder());
        file.setFileCompletePath(imageFile.getDevicePath());
        file.setMetaData(imageFile.getMetaData());
        file.setMd5checksum(imageFile.getMD5());
        file.setSize(Double.toString(imageFile.getSize()));
        file.setExists(imageFile.isPresent());
        file.setLastModifiedTimestamp(imageFile.getCrawlStartTimestamp());
        file.setFileUserOwner(deleteFileRevision.getUserName());
        if (deleteFileRevision.getRegID() != null && !deleteFileRevision.getRegID().equals("0000000000") && (device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deleteFileRevision.getRegID())) != null) {
            file.setFileDeviceOwner(device.getDeviceName());
        }
        if (FileTypeHelper.isImageFile((String)(extension = FilenameUtils.getExtension((String)imageFile.getFileName()))) || FileTypeHelper.isVideoFile((String)extension)) {
            file.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + deleteFileRevision.getfSPath());
        }
        logger.debug("file name: " + file.getFileName());
        fileElements.add(file);
    }

    public List<FileElement> getPageWiseDeleteFileImages(int cloudId, String cloudName, int pageNum, int rows, List<FileRevision> deletedRevisionsList) {
        if (pageNum == 0 && rows > 0 && deletedRevisionsList != null) {
            ArrayList<FileElement> fileElements = new ArrayList<FileElement>();
            for (int i = 0; i < rows; ++i) {
                try {
                    this.addToFileElementList(cloudId, cloudName, deletedRevisionsList.get(i), fileElements);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_GETTING_PAGE_WISE_DELETE_IMAGES + e.getMessage());
                    break;
                }
            }
            return fileElements;
        }
        if (pageNum > 0 && rows > 0 && deletedRevisionsList != null) {
            ArrayList<FileElement> fileElements = new ArrayList<FileElement>();
            for (int i = rows * pageNum; i < rows * (pageNum + 1); ++i) {
                try {
                    this.addToFileElementList(cloudId, cloudName, deletedRevisionsList.get(i), fileElements);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_GETTING_PAGE_WISE_DELETE_IMAGES + e.getMessage());
                    break;
                }
            }
            return fileElements;
        }
        ArrayList<FileElement> fileElements = new ArrayList<FileElement>();
        for (FileRevision fileRevision : deletedRevisionsList) {
            try {
                this.addToFileElementList(cloudId, cloudName, fileRevision, fileElements);
            }
            catch (IndexOutOfBoundsException e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_GETTING_PAGE_WISE_DELETE_IMAGES + e.getMessage());
                break;
            }
        }
        return fileElements;
    }

    @Override
    public List<SearchIndex> restoreResoruces(int cloudId, String cloudName, Cloud cloud, FileRevisionElement fileRevisionElement, String userName) {
        String[] params;
        ConsolidatedImage imageFile = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, fileRevisionElement.getFileCompletePath(), fileRevisionElement.getFileName());
        ArrayList<SearchIndex> searchIndexs = new ArrayList<SearchIndex>();
        if (imageFile == null || fileRevisionElement.isFolder()) {
            return null;
        }
        this.handleVersioning(cloud, cloudName, imageFile);
        imageFile.setPresent(true);
        imageFile.setCrawlStartTimestamp(System.currentTimeMillis());
        imageFile.setModifiedTime(Long.toString(System.currentTimeMillis()));
        imageFile.setRegID("0000000000");
        imageFile.setMD5(fileRevisionElement.getMd5checksum());
        imageFile.setSize(Double.valueOf(fileRevisionElement.getSize()).doubleValue());
        this.consolidatedImageDao.saveToConsolidatedImageDB(cloudId, cloudName, imageFile);
        FileRevision fileRevision = new FileRevision();
        this.convertConsolidatedImageToFileRevision(imageFile, fileRevision);
        fileRevision.setStatus(PCHelperConstant.REVISION_STATUS.RESTORED.toString());
        fileRevision.setfSPath(fileRevisionElement.getfSPath());
        fileRevision.setUserName(userName);
        if (!fileRevision.isFolder()) {
            fileRevision.setStoragePlace("ES");
        }
        this.fileRevisionDao.saveRevision(cloudId, cloudName, fileRevision);
        if (!imageFile.isFolder()) {
            FileRevision revision = new FileRevision();
            revision.setId(new ObjectId(fileRevisionElement.getFileRevisionId()));
            revision.setUserName(fileRevision.getUserName());
            this.saveCopiedFileInfoInMainSyncDB(cloud, imageFile, imageFile.getDevicePath(), revision, userName);
        }
        String tempPath = fileRevisionElement.getFileCompletePath();
        while (!tempPath.isEmpty() && tempPath != "" && (params = tempPath.split("/")).length > 1) {
            String fName = params[params.length - 1];
            String fPath = tempPath.substring(0, tempPath.length() - (fName.length() + 1));
            logger.debug("restoritng folders folderPath: " + fPath + " folderName: " + fName);
            ConsolidatedImage iFile = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, fPath, fName);
            if (iFile != null && iFile.isPresent() && !iFile.isFolder()) {
                throw new BaseException("Error: While restoring the parents, file already exists with same folder name.");
            }
            if (iFile != null && iFile.isPresent()) break;
            if (iFile != null && iFile.isFolder()) {
                logger.debug("doesnt exists, so creating directories and updaing consolidated image table");
                iFile.setPresent(true);
                iFile.setModifiedTime(Long.toString(System.currentTimeMillis()));
                iFile.setCrawlStartTimestamp(System.currentTimeMillis());
                iFile.setRegID("0000000000");
                this.consolidatedImageDao.saveToConsolidatedImageDB(cloudId, cloudName, iFile);
                FileRevision fileRevision2 = new FileRevision();
                this.convertConsolidatedImageToFileRevision(iFile, fileRevision2);
                fileRevision2.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
                fileRevision2.setfSPath(null);
                fileRevision2.setUserName(userName);
                this.fileRevisionDao.saveRevision(cloudId, cloudName, fileRevision2);
                this.searchService.updateDeleteFileIndex(cloudId, cloudName, fileRevision2.getConsolidatedImage().getId().toString(), ACTIVE);
            }
            tempPath = fPath;
        }
        this.searchService.updateDeleteFileIndex(cloudId, cloudName, fileRevision.getConsolidatedImage().getId().toString(), ACTIVE);
        return searchIndexs;
    }

    private void updateModifiedTimeStamp(int cloudId, String userName, String cloudName, String tempPath, long time) {
        String[] params;
        String path = tempPath;
        while (!path.isEmpty() && path != "" && (params = path.split("/")).length > 1) {
            String fName = params[params.length - 1];
            String fPath = path.substring(0, path.length() - (fName.length() + 1));
            ConsolidatedImage iFile = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, fPath, fName);
            if (iFile == null || !iFile.isFolder() || !iFile.isPresent()) break;
            iFile.setModifiedTime(Long.toString(time));
            this.consolidatedImageDao.saveToConsolidatedImageDB(cloudId, cloudName, iFile);
            path = fPath;
        }
    }

    @Override
    public boolean getBackUpFilesByDevice(int cloudId, String cloudName, DeviceElement deviceElement) {
        return false;
    }

    @Override
    public boolean getvalidateFilesRequests(int cloudId, String userName, String cloudName, int sizeAllowed, int filesAllowed, String path, boolean isFolder) {
        boolean allowed = true;
        if (!isFolder) {
            ConsolidatedImage consolidatedImage;
            String[] params = path.split("/");
            String fileName = "";
            String devicePath = "";
            if (params.length > 0) {
                fileName = params[params.length - 1];
                devicePath = path.replace("/" + fileName, "");
            }
            if ((consolidatedImage = this.consolidatedImageDao.getExistingDBRecordByDevicePath(cloudId, userName, cloudName, devicePath, fileName)) == null) {
                return false;
            }
            double siz = consolidatedImage.getSize() / 1024.0;
            if (sizeAllowed > 0) {
                if (siz > (double)sizeAllowed) {
                    allowed = false;
                }
            } else if (siz > 512.0) {
                allowed = false;
            }
            return allowed;
        }
        List consolidatedImageList = this.consolidatedImageDao.getAllExistingRecordsBeforeCurrentTimeStamp(cloudId, userName, cloudName, System.currentTimeMillis(), path);
        if (filesAllowed > 0) {
            if (consolidatedImageList.size() > filesAllowed) {
                allowed = false;
            }
        } else if (consolidatedImageList.size() > 500) {
            allowed = false;
        }
        double size = 0.0;
        for (ConsolidatedImage consolidatedImage : consolidatedImageList) {
            size = consolidatedImage.getSize() + size;
        }
        size /= 1024.0;
        if (sizeAllowed > 0) {
            if (size > (double)sizeAllowed) {
                allowed = false;
            }
        } else if (size > 512.0) {
            allowed = false;
        }
        return allowed;
    }

    @Override
    public ShareAndSearchDLTO moveResourceFile(int cloudId, String cloudName, Cloud cloud, FileElement file, String destinationPath, String userName, boolean isPathInsideMC, User sourceUser, User destinationUser, MiniCloud sourceMC, MiniCloud destinationMC, boolean isSearchEnabled) {
        double sizeIncremental = 0.0;
        ArrayList searchIndexs = new ArrayList();
        User syncUser = destinationUser;
        if (file == null || !file.isExists() || file.getFileName().isEmpty() || file.getFileCompletePath().isEmpty()) {
            return null;
        }
        ArrayList<String> sharedFileNameList = new ArrayList<String>();
        ArrayList<String> sharedDevicePathList = new ArrayList<String>();
        long currentTimeStamp = System.currentTimeMillis();
        String userNameVal = userName;
        User user = this.userDao.getUserByName(cloudId, userName);
        Object miniCloud = null;
        if (isPathInsideMC) {
            userNameVal = "";
        }
        BackUpImage sourceBackUpImage = null;
        sourceBackUpImage = file.isFolder() ? this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), file.getFileCompletePath(), file.getFileName(), sourceUser, sourceMC) : this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloud.getCloudId(), userNameVal, file.getFileCompletePath(), file.getFileName(), sourceUser, sourceMC);
        BackUpImage destinationBackUpImage = destinationMC != null ? this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), destinationPath, file.getFileName(), destinationUser, destinationMC) : this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userName, cloud.getCloudName(), destinationPath, file.getFileName(), destinationUser, destinationMC);
        if (sourceBackUpImage == null || destinationBackUpImage != null && destinationBackUpImage.isPresent()) {
            return null;
        }
        if (!sourceBackUpImage.isFolder()) {
            BackUpImage backUpImageMoved = new BackUpImage();
            BeanUtils.copyProperties((Object)sourceBackUpImage, (Object)backUpImageMoved, (String[])new String[]{"id"});
            backUpImageMoved.setDevicePath(destinationPath);
            backUpImageMoved.setUserName(userName);
            backUpImageMoved.setLastServerModifiedTime(currentTimeStamp);
            backUpImageMoved.setCrawlStartTimestamp(currentTimeStamp);
            backUpImageMoved.setDeviceUUID("Portal");
            backUpImageMoved.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
            if (destinationBackUpImage != null) {
                this.handleVersioning(cloud, backUpImageMoved, userName, userNameVal, destinationUser, destinationMC);
            }
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), backUpImageMoved, destinationUser, destinationMC);
            this.increaseRefCountInChunkDetail(cloudId, sourceBackUpImage.getChunkFiles(), sourceBackUpImage.getUserName());
            if (isSearchEnabled) {
                searchIndexs.addAll(SearchIndexHelper.addorUpdateIndex((int)cloudId, (String)cloudName, (BackUpImage)backUpImageMoved));
            }
            BackUpImage sourceBackUpImageLatestVersion = this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), file.getFileCompletePath(), file.getFileName(), sourceUser, sourceMC);
            BackUpImage sourceImageDelete = new BackUpImage();
            BeanUtils.copyProperties((Object)sourceBackUpImageLatestVersion, (Object)sourceImageDelete, (String[])new String[]{"id"});
            sourceImageDelete.setLastServerModifiedTime(currentTimeStamp);
            sourceImageDelete.setCrawlStartTimestamp(currentTimeStamp);
            sourceImageDelete.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
            sourceImageDelete.setDeviceUUID("Portal");
            sourceImageDelete.setPresent(false);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), sourceImageDelete, sourceUser, sourceMC);
            if (!sourceBackUpImage.isFolder() && isSearchEnabled) {
                DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                deletedSearchIndex.setId(sourceBackUpImage.getId());
                deletedSearchIndex.setSync(true);
                deletedSearchIndex.setCloudId(cloudId);
                deletedSearchIndex.setCloudName(cloudName);
                deletedSearchIndex.setUserName(userNameVal);
                deletedSearchIndex.setDevicePath(sourceBackUpImage.getDevicePath());
                this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
                this.searchService.updateDeleteFileIndex(cloudId, cloudName, sourceBackUpImage.getId().toString(), DELETED);
            }
            DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)Math.round(sizeIncremental += (double)sourceBackUpImage.getSize()));
            logger.debug("inside single file>>>>>>>>>>>>>>>");
            this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, sourceBackUpImage);
            if (isPathInsideMC) {
                this.updateModifiedTimeStamp(cloudId, null, cloudName, destinationPath, currentTimeStamp, null, destinationMC);
            } else {
                this.updateModifiedTimeStamp(cloudId, userName, cloudName, destinationPath, currentTimeStamp, destinationUser, destinationMC);
            }
            DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)Math.round(sizeIncremental));
            return new ShareAndSearchDLTO(searchIndexs, sharedFileNameList, sharedDevicePathList);
        }
        String originalSourcePath = file.getFileCompletePath();
        String newSourcePath = file.getFileCompletePath() + "/" + file.getFileName();
        logger.debug(originalSourcePath + "will move children now...." + newSourcePath);
        ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
        folderList.add(sourceBackUpImage);
        this.getChildFoldersForBaseFolder(cloudId, cloudName, userNameVal, newSourcePath, folderList, sourceUser, sourceMC, true);
        for (BackUpImage subFolder : folderList) {
            String folderDevicePath = subFolder.getDevicePath() + "/" + subFolder.getFileName();
            List fileListFromDatabase = this.syncBackUpImageDAO.getLatestExistingRecordsBeforeCurrentTimeStampForPath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), currentTimeStamp, folderDevicePath, sourceUser, sourceMC);
            for (BackUpImage sourceFile : fileListFromDatabase) {
                String newDestinationPath = this.buildDestinationDevicePath(originalSourcePath, (sourceFile = this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloudId, userNameVal, sourceFile.getDevicePath(), sourceFile.getFileName(), sourceUser, sourceMC)).getDevicePath(), destinationPath);
                if (newDestinationPath.isEmpty()) {
                    logger.error("Destination path is empty");
                    continue;
                }
                logger.debug(NEW_DESTINATION_PATH + newDestinationPath);
                BackUpImage backUpImageNewRecord = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userName, cloud.getCloudName(), newDestinationPath, sourceFile.getFileName(), destinationUser, destinationMC);
                BackUpImage childBackUpImageMoved = new BackUpImage();
                BeanUtils.copyProperties((Object)sourceFile, (Object)childBackUpImageMoved, (String[])new String[]{"id"});
                childBackUpImageMoved.setDevicePath(newDestinationPath);
                childBackUpImageMoved.setPresent(true);
                childBackUpImageMoved.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
                childBackUpImageMoved.setCrawlStartTimestamp(currentTimeStamp);
                childBackUpImageMoved.setLastServerModifiedTime(currentTimeStamp);
                childBackUpImageMoved.setUserName(userName);
                childBackUpImageMoved.setDeviceUUID("Portal");
                if (backUpImageNewRecord != null) {
                    this.handleVersioning(cloud, childBackUpImageMoved, userName, userNameVal, destinationUser, destinationMC);
                }
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), childBackUpImageMoved, destinationUser, destinationMC);
                this.increaseRefCountInChunkDetail(cloudId, sourceFile.getChunkFiles(), sourceFile.getUserName());
                if (isSearchEnabled) {
                    searchIndexs.addAll(SearchIndexHelper.addorUpdateIndex((int)cloudId, (String)cloudName, (BackUpImage)childBackUpImageMoved));
                }
                BackUpImage sourceChildImageDelete = new BackUpImage();
                BeanUtils.copyProperties((Object)sourceFile, (Object)sourceChildImageDelete, (String[])new String[]{"id"});
                sourceChildImageDelete.setLastServerModifiedTime(currentTimeStamp);
                sourceChildImageDelete.setCrawlStartTimestamp(currentTimeStamp);
                sourceChildImageDelete.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
                sourceChildImageDelete.setDeviceUUID("Portal");
                sourceChildImageDelete.setPresent(false);
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), sourceChildImageDelete, sourceUser, sourceMC);
                this.deleteSyncSharedFiles(sharedFileNameList, sharedDevicePathList, sourceFile);
                sizeIncremental += (double)childBackUpImageMoved.getSize();
            }
            BackUpImage childSubFolderMoved = new BackUpImage();
            BeanUtils.copyProperties((Object)subFolder, (Object)childSubFolderMoved, (String[])new String[]{"id"});
            String newDestinationPath = this.buildDestinationDevicePath(originalSourcePath, subFolder.getDevicePath(), destinationPath);
            childSubFolderMoved.setDevicePath(newDestinationPath);
            childSubFolderMoved.setPresent(true);
            childSubFolderMoved.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
            childSubFolderMoved.setCrawlStartTimestamp(currentTimeStamp);
            childSubFolderMoved.setLastServerModifiedTime(currentTimeStamp);
            childSubFolderMoved.setUserName(userName);
            childSubFolderMoved.setDeviceUUID("Portal");
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), childSubFolderMoved, destinationUser, destinationMC);
            BackUpImage sourceSubFolderDelete = new BackUpImage();
            BeanUtils.copyProperties((Object)subFolder, (Object)sourceSubFolderDelete);
            sourceSubFolderDelete.setLastServerModifiedTime(currentTimeStamp);
            sourceSubFolderDelete.setCrawlStartTimestamp(currentTimeStamp);
            sourceSubFolderDelete.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
            sourceSubFolderDelete.setDeviceUUID("Portal");
            sourceSubFolderDelete.setPresent(false);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), sourceSubFolderDelete, sourceUser, sourceMC);
            if (!subFolder.isFolder() || !isSearchEnabled) continue;
            DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
            deletedSearchIndex.setId(subFolder.getId());
            deletedSearchIndex.setSync(true);
            deletedSearchIndex.setFolderDelete(true);
            deletedSearchIndex.setCloudId(cloudId);
            deletedSearchIndex.setCloudName(cloudName);
            deletedSearchIndex.setUserName(userNameVal);
            deletedSearchIndex.setDevicePath(subFolder.getDevicePath());
            this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
        }
        if (isPathInsideMC) {
            syncUser = null;
        }
        this.updateModifiedTimeStamp(cloudId, userName, cloudName, destinationPath, currentTimeStamp, syncUser, destinationMC);
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)Math.round(sizeIncremental));
        for (SearchIndex searchIndex : searchIndexs) {
            searchIndex.setCloudName(cloudName);
        }
        return new ShareAndSearchDLTO(searchIndexs, sharedFileNameList, sharedDevicePathList);
    }

    @Override
    public List<FileRevisionElement> getRevisions(int cloudId, String userName, String cloudName, String fileName, String filePath) {
        ConsolidatedImage imageFile = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, filePath, fileName);
        if (imageFile == null || !imageFile.isPresent()) {
            return null;
        }
        ObjectId consoId = imageFile.getId();
        List fileRevisions = this.fileRevisionDao.getAllRevisions(cloudId, cloudName, consoId);
        if (fileRevisions == null || fileRevisions.isEmpty()) {
            return null;
        }
        ArrayList<FileRevisionElement> fileRevisionElements = new ArrayList<FileRevisionElement>();
        for (FileRevision f : fileRevisions) {
            if (f.isFolder()) continue;
            FileRevisionElement element = new FileRevisionElement();
            this.convertFileRevisionDomainToElement(cloudId, cloudName, f, element);
            element.setFileRevisionId(f.getId().toString());
            fileRevisionElements.add(element);
        }
        return fileRevisionElements;
    }

    @Override
    public List<FileRevisionElement> getRevisions(int cloudId, String userName, String cloudName, String fileName, String filePath, int noOfRevisionsTemp, boolean isPathInsideMC, User user, MiniCloud miniCloud) {
        List backUpImageVersionsList;
        SyncPolicy syncPolicy;
        int noOfRevisions = noOfRevisionsTemp;
        String userNameVal = userName;
        if (user != null && !StringUtils.isEmpty((String)user.getSyncPolicyName()) && (syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName())) != null) {
            noOfRevisions = syncPolicy.getMaxVersions();
        }
        if (isPathInsideMC) {
            userNameVal = "";
            user = null;
        }
        if ((backUpImageVersionsList = this.syncBackUpImageDAO.getBackUpImageVersionsByDevicePathAndFileName(cloudId, userNameVal, filePath, fileName, noOfRevisions, user, miniCloud)) == null || backUpImageVersionsList.isEmpty()) {
            logger.debug("--- BackUpImage versions list is null or empty ---");
            return null;
        }
        ArrayList<FileRevisionElement> fileRevisionElements = new ArrayList<FileRevisionElement>();
        for (BackUpImage revision : backUpImageVersionsList) {
            if (revision.isFolder()) continue;
            FileRevisionElement element = new FileRevisionElement();
            this.convertBackUpImageRevisionDomainToElement(cloudId, cloudName, revision, element);
            if (revision.getfSPath() != null) {
                String extension = FilenameUtils.getExtension((String)revision.getfSPath());
                if (extension != null && !"".equals(extension)) {
                    element.setFolder(false);
                } else {
                    element.setFolder(true);
                }
            }
            element.setFileRevisionId(revision.getId().toString());
            fileRevisionElements.add(element);
            Long currentTime = System.currentTimeMillis();
            BackUpImage accessedFile = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, filePath, fileName, user, miniCloud);
            if (accessedFile != null && !accessedFile.isFolder() && accessedFile.isPresent()) {
                accessedFile.setLastServerModifiedTime(currentTime.longValue());
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, accessedFile, user, miniCloud);
            }
            if (isPathInsideMC) {
                this.updateModifiedTimeStamp(cloudId, null, cloudName, filePath, currentTime, null, miniCloud);
                continue;
            }
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, filePath, currentTime, user, miniCloud);
        }
        return fileRevisionElements;
    }

    @Override
    public List<SearchIndex> copyResourceFile(int cloudId, String cloudName, Cloud cloud, FileElement file, String destinationPath, String userName, boolean isPathInsideMC, User sourceUser, User destinationUser, MiniCloud sourceMC, MiniCloud destinationMC, boolean isSearchEnabled) {
        AtomicReference<Double> sizeIncremental = new AtomicReference<Double>(0.0);
        User syncUser = destinationUser;
        ArrayList<SearchIndex> searchIndexs = new ArrayList<SearchIndex>();
        if (file == null || !file.isExists() || file.getFileName().isEmpty() || file.getFileCompletePath().isEmpty()) {
            return null;
        }
        long currentTimeStamp = System.currentTimeMillis();
        String userNameVal = userName;
        if (isPathInsideMC) {
            userNameVal = "";
        }
        BackUpImage sourceBackUpImage = null;
        sourceBackUpImage = file.isFolder() ? this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), file.getFileCompletePath(), file.getFileName(), sourceUser, sourceMC) : this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloud.getCloudId(), userNameVal, file.getFileCompletePath(), file.getFileName(), sourceUser, sourceMC);
        BackUpImage destinationBackUpImage = destinationMC != null ? this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), destinationPath, file.getFileName(), destinationUser, destinationMC) : this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userName, cloud.getCloudName(), destinationPath, file.getFileName(), destinationUser, destinationMC);
        if (sourceBackUpImage == null || destinationBackUpImage != null && destinationBackUpImage.isPresent()) {
            logger.debug(destinationBackUpImage + " Source path or destination path not present ....." + sourceBackUpImage);
            return null;
        }
        if (!sourceBackUpImage.isFolder()) {
            logger.debug("inside single file>>>>>>>>>>>>>>>");
            BackUpImage copiedBackUpImage = new BackUpImage();
            BeanUtils.copyProperties((Object)sourceBackUpImage, (Object)copiedBackUpImage, (String[])new String[]{"id"});
            copiedBackUpImage.setDevicePath(destinationPath);
            copiedBackUpImage.setUserName(userName);
            copiedBackUpImage.setLastServerModifiedTime(currentTimeStamp);
            copiedBackUpImage.setCrawlStartTimestamp(currentTimeStamp);
            copiedBackUpImage.setDeviceUUID("Portal");
            copiedBackUpImage.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
            if (destinationBackUpImage != null) {
                this.handleVersioning(cloud, copiedBackUpImage, userName, userNameVal, destinationUser, destinationMC);
            }
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), copiedBackUpImage, destinationUser, destinationMC);
            this.increaseRefCountInChunkDetail(cloudId, sourceBackUpImage.getChunkFiles(), sourceBackUpImage.getUserName());
            sizeIncremental.updateAndGet(v -> new Double(v + (double)copiedBackUpImage.getSize()));
            DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)Math.round(sizeIncremental.get()));
            if (isPathInsideMC) {
                this.updateModifiedTimeStamp(cloudId, null, cloudName, destinationPath, currentTimeStamp, null, destinationMC);
            } else {
                this.updateModifiedTimeStamp(cloudId, userName, cloudName, destinationPath, currentTimeStamp, destinationUser, destinationMC);
            }
            if (isSearchEnabled) {
                searchIndexs.addAll(SearchIndexHelper.addorUpdateIndex((int)cloudId, (String)cloudName, (BackUpImage)copiedBackUpImage));
            }
            return searchIndexs;
        }
        logger.debug("will copy children now....");
        String originalSourcePath = file.getFileCompletePath();
        String newSourcePath = file.getFileCompletePath() + "/" + file.getFileName();
        ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
        folderList.add(sourceBackUpImage);
        this.getChildFoldersForBaseFolder(cloudId, cloudName, userNameVal, newSourcePath, folderList, sourceUser, sourceMC, true);
        for (BackUpImage subFolder : folderList) {
            String folderDevicePath = subFolder.getDevicePath() + "/" + subFolder.getFileName();
            List fileListFromDatabase = this.syncBackUpImageDAO.getLatestExistingRecordsBeforeCurrentTimeStampForPath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), currentTimeStamp, folderDevicePath, sourceUser, sourceMC);
            Stream stream = null;
            if (fileListFromDatabase != null) {
                stream = fileListFromDatabase.parallelStream();
            }
            if (stream != null) {
                String finalUserNameVal = userNameVal;
                stream.forEach(sourceFile -> {
                    String newDestinationPath = this.buildDestinationDevicePath(originalSourcePath, (sourceFile = this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloudId, finalUserNameVal, sourceFile.getDevicePath(), sourceFile.getFileName(), sourceUser, sourceMC)).getDevicePath(), destinationPath);
                    if (newDestinationPath.isEmpty() || newDestinationPath == "") {
                        logger.error("New destination path is empty");
                        return;
                    }
                    logger.debug(NEW_DESTINATION_PATH + newDestinationPath);
                    BackUpImage backUpImageNewRecord = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), finalUserNameVal, cloud.getCloudName(), newDestinationPath, sourceFile.getFileName(), destinationUser, destinationMC);
                    BackUpImage childBackUpImageCopied = new BackUpImage();
                    BeanUtils.copyProperties((Object)sourceFile, (Object)childBackUpImageCopied, (String[])new String[]{"id"});
                    childBackUpImageCopied.setDevicePath(newDestinationPath);
                    childBackUpImageCopied.setPresent(true);
                    childBackUpImageCopied.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
                    childBackUpImageCopied.setCrawlStartTimestamp(currentTimeStamp);
                    childBackUpImageCopied.setLastServerModifiedTime(currentTimeStamp);
                    childBackUpImageCopied.setDeviceUUID("Portal");
                    childBackUpImageCopied.setUserName(userName);
                    if (backUpImageNewRecord != null) {
                        this.handleVersioning(cloud, childBackUpImageCopied, userName, finalUserNameVal, destinationUser, destinationMC);
                    }
                    sizeIncremental.updateAndGet(v -> new Double(v + (double)childBackUpImageCopied.getSize()));
                    this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), childBackUpImageCopied, destinationUser, destinationMC);
                    this.increaseRefCountInChunkDetail(cloudId, sourceFile.getChunkFiles(), sourceFile.getUserName());
                    logger.debug(FILE_TO_COPY + newDestinationPath + "/" + sourceFile.getFileName());
                    if (isSearchEnabled) {
                        searchIndexs.addAll(SearchIndexHelper.addorUpdateIndex((int)cloudId, (String)cloudName, (BackUpImage)childBackUpImageCopied));
                    }
                });
            }
            BackUpImage subFolderCopied = new BackUpImage();
            BeanUtils.copyProperties((Object)subFolder, (Object)subFolderCopied, (String[])new String[]{"id"});
            String newDestinationPath = this.buildDestinationDevicePath(originalSourcePath, subFolder.getDevicePath(), destinationPath);
            subFolderCopied.setDevicePath(newDestinationPath);
            subFolderCopied.setPresent(true);
            subFolderCopied.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
            subFolderCopied.setCrawlStartTimestamp(currentTimeStamp);
            subFolderCopied.setLastServerModifiedTime(currentTimeStamp);
            subFolderCopied.setDeviceUUID("Portal");
            subFolderCopied.setUserName(userName);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), cloud.getCloudName(), subFolderCopied, destinationUser, destinationMC);
            if (isPathInsideMC) {
                syncUser = null;
            }
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, destinationPath, currentTimeStamp, syncUser, destinationMC);
        }
        logger.debug("size to update in  cloud....." + sizeIncremental);
        DiskSpaceHelper.updateCloudSize((String)cloudName, (int)2, (long)Math.round(sizeIncremental.get()));
        return searchIndexs;
    }

    private void addSizetoArrayList(List<Double> arrayOfSizes, double size) {
        logger.debug("adding the sizee in array list..");
        arrayOfSizes.add(size);
    }

    private void saveCopiedFileInfoInMainSyncDB(Cloud cloud, ConsolidatedImage sourceFile, String newDestinationPath, FileRevision revision, String userName) {
        logger.debug("inside save copied file info in main DB>>>>>>>>>>>>>>>>>>>>");
        ConsolidatedImage consolidatedImageNewRecord = this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloud.getCloudId(), userName, cloud.getCloudName(), newDestinationPath, sourceFile.getFileName());
        if (consolidatedImageNewRecord != null) {
            logger.debug("consolidatedImage not Null>>>>>>>>>>>>>>>>>>>>" + consolidatedImageNewRecord.getId());
            FileRevision newFileRevision = this.fileRevisionDao.getLatestRevision(cloud.getCloudId(), cloud.getCloudName(), consolidatedImageNewRecord.getId());
            if (newFileRevision != null) {
                logger.debug("source fileRevision>>>>>>" + revision.getId() + "new file revision not null>>>>>>>>>>>>>>>>>>>>" + newFileRevision.getId().toString());
                BackupFile backupFile = this.externalStorageBackupFileDao.getSyncFile(cloud.getCloudId(), cloud.getCloudName(), revision.getUserName(), revision.getId().toString());
                if (backupFile != null) {
                    logger.debug("inside backup FileNot null>>>>>>>>>>>>>.");
                    backupFile.setId(newFileRevision.getId());
                    backupFile.setFilePath(consolidatedImageNewRecord.getDevicePath());
                    backupFile.setFileName(consolidatedImageNewRecord.getFileName());
                    if (backupFile.getDedupBackupId() == null) {
                        backupFile.setDedupBackupId(revision.getId().toString());
                    }
                    this.externalStorageBackupFileDao.saveSyncFileInfo(cloud.getCloudId(), cloud.getCloudName(), newFileRevision.getUserName(), backupFile);
                }
                logger.debug("saved to sync db successfully>>>>>>>>>>>>>>>>>>>>");
            }
        }
    }

    @Override
    public List<SearchIndex> restoreLastResources(int cloudId, String cloudName, Cloud cloud, String path, String fileName, String userName, String fileUserName, User user, MiniCloud miniCloud, boolean isFolder) {
        String[] params;
        BackUpImage backUpImage = null;
        backUpImage = isFolder ? this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePathForRestore(cloudId, fileUserName, cloudName, path, fileName, user, miniCloud) : this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloudId, fileUserName, path, fileName, user, miniCloud);
        if (backUpImage == null) {
            logger.debug(" INSIDE RESTORE LAST RESOURCE FILE imageFile null ");
            return null;
        }
        logger.debug(fileName + " INSIDE RESTORE  LAST RESOURCE " + path);
        long lastModifiedTime = System.currentTimeMillis();
        ArrayList<SearchIndex> searchIndexs = new ArrayList<SearchIndex>();
        if (!backUpImage.isFolder()) {
            BackUpImage backUpImageRestored = new BackUpImage();
            BeanUtils.copyProperties((Object)backUpImage, (Object)backUpImageRestored, (String[])new String[]{"id"});
            backUpImageRestored.setPresent(true);
            backUpImageRestored.setStatus(RESTORED);
            backUpImageRestored.setCrawlStartTimestamp(lastModifiedTime);
            backUpImageRestored.setLastServerModifiedTime(lastModifiedTime);
            backUpImageRestored.setDeviceUUID("Portal");
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, backUpImageRestored, user, miniCloud);
        } else {
            logger.debug(" INSIDE RESTORE LAST RESOURCE FILE 2 ");
            ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
            folderList.add(backUpImage);
            String folderPath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
            this.getChildFoldersForBaseFolder(cloudId, cloudName, fileUserName, folderPath, folderList, user, miniCloud, false);
            for (BackUpImage subFolder : folderList) {
                String newPath = subFolder.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + subFolder.getFileName();
                List backUpImageChildList = this.syncBackUpImageDAO.getDeletedChildrenByFolder(cloudId, fileUserName, cloudName, newPath, user, miniCloud);
                for (BackUpImage backUpImageChild : backUpImageChildList) {
                    logger.debug("Sync BackUpImage Path : " + backUpImageChild.getDevicePath() + " FileName : " + backUpImageChild.getFileName());
                    BackUpImage backUpImageChildRestored = new BackUpImage();
                    backUpImageChild = this.syncBackUpImageDAO.getLatestPresentRecordForFileNameAndDevicePath(cloudId, fileUserName, backUpImageChild.getDevicePath(), backUpImageChild.getFileName(), user, miniCloud);
                    BeanUtils.copyProperties((Object)backUpImageChild, (Object)backUpImageChildRestored, (String[])new String[]{"id"});
                    backUpImageChildRestored.setPresent(true);
                    backUpImageChildRestored.setStatus(RESTORED);
                    backUpImageChildRestored.setCrawlStartTimestamp(lastModifiedTime);
                    backUpImageChildRestored.setLastServerModifiedTime(lastModifiedTime);
                    backUpImageChildRestored.setDeviceUUID("Portal");
                    this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, backUpImageChildRestored, user, miniCloud);
                    searchIndexs.addAll(SearchIndexHelper.addorUpdateIndex((int)cloudId, (String)cloudName, (BackUpImage)backUpImageChildRestored));
                }
                BackUpImage subFolderRestored = new BackUpImage();
                BeanUtils.copyProperties((Object)subFolder, (Object)subFolderRestored);
                subFolderRestored.setPresent(true);
                subFolderRestored.setStatus(RESTORED);
                subFolderRestored.setCrawlStartTimestamp(lastModifiedTime);
                subFolderRestored.setLastServerModifiedTime(lastModifiedTime);
                subFolderRestored.setDeviceUUID("Portal");
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, subFolderRestored, user, miniCloud);
            }
        }
        logger.debug(" INSIDE RESTORE LAST RESOURCE FILE 3 ");
        String tempPath = path;
        while (!tempPath.isEmpty() && tempPath != "" && (params = tempPath.split("/")).length > 1) {
            String fName = params[params.length - 1];
            String fPath = tempPath.substring(0, tempPath.length() - (fName.length() + 1));
            logger.debug("restoritng folders folderPath: " + fPath + " folderName: " + fName);
            BackUpImage backUpImageFile = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, fileUserName, cloudName, fPath, fName, user, miniCloud);
            if (backUpImageFile != null && backUpImageFile.isPresent() && !backUpImageFile.isFolder()) {
                throw new BaseException("Error: While restoring the parents, file already exists with same folder name.");
            }
            if (backUpImageFile != null && backUpImageFile.isPresent()) break;
            if (backUpImageFile != null && backUpImageFile.isFolder()) {
                logger.debug("doesnt exists, so creating directories and updaing consolidated image table");
                BackUpImage backUpImageFileRestored = new BackUpImage();
                BeanUtils.copyProperties((Object)backUpImageFile, (Object)backUpImageFileRestored);
                backUpImageFileRestored.setPresent(true);
                backUpImageFileRestored.setStatus(RESTORED);
                backUpImageFileRestored.setCrawlStartTimestamp(lastModifiedTime);
                backUpImageFileRestored.setLastServerModifiedTime(lastModifiedTime);
                backUpImageFileRestored.setDeviceUUID("Portal");
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, backUpImageFileRestored, user, miniCloud);
            }
            tempPath = fPath;
        }
        return searchIndexs;
    }

    private void getChildFoldersForBaseFolder(int cloudId, String cloudName, String userName, String filePath, List<BackUpImage> syncFolderList, User user, MiniCloud miniCloud, boolean isPresent) {
        List backUpImageList = this.syncBackUpImageDAO.getBackUpImageDBRecordByOnlyDevicePath(cloudId, userName, cloudName, filePath, user, miniCloud, true);
        if (!CollectionUtils.isEmpty((Collection)backUpImageList)) {
            List filesList = isPresent ? backUpImageList.stream().filter(BackUpImage::isPresent).collect(Collectors.toList()) : backUpImageList.stream().filter(backUpImage -> !backUpImage.isPresent()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filesList)) {
                syncFolderList.addAll(filesList);
            }
            Stream stream = backUpImageList.parallelStream();
            stream.forEach(syncFile -> {
                String devicePath = syncFile.getDevicePath() + "/" + syncFile.getFileName();
                this.getChildFoldersForBaseFolder(cloudId, cloudName, userName, devicePath, syncFolderList, user, miniCloud, isPresent);
            });
        }
    }

    @Override
    public List<SearchIndex> restoreAllResources(int cloudId, String cloudName, Cloud cloud, List<FileRevision> filesToRestore, String userName) {
        logger.debug(" INSIDE RESTORE LAST RESOURCE FILE 5 " + filesToRestore);
        ArrayList<SearchIndex> indexs = new ArrayList<SearchIndex>();
        for (FileRevision element : filesToRestore) {
            logger.debug(" INSIDE RESTORE LAST RESOURCE FILE 6 " + element.getConsolidatedImage().getId());
            List<SearchIndex> indexs2 = this.restoreLastResources(cloudId, cloudName, cloud, element.getConsolidatedImage().getDevicePath(), element.getConsolidatedImage().getFileName(), userName, "", null, null, element.isFolder());
            if (indexs2 == null) continue;
            indexs.addAll(indexs2);
        }
        if (indexs.isEmpty()) {
            logger.debug(" INSIDE RESTORE LAST RESOURCE FILE 7 ");
            return null;
        }
        return indexs;
    }

    @Override
    public ShareAndSearchDLTO deleteMiniCloudPermanently(int cloudId, String cloudName, MiniCloudElement cloudElement, String userName) throws Exception {
        logger.debug(" INSIDE SERVICE deleteMiniCloudPermanently ... ");
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, cloudElement.getMiniCloudName());
        ShareAndSearchDLTO indexes = this.deleteResourceFilesForMC(cloudId, cloudName, cloudElement.getMiniCloudName(), "ParaBlu", userName, miniCloud);
        logger.debug(" INSIDE SERVICE deleteMiniCloudMappingForAllUsers ... ");
        this.deleteMiniCloudMappingForAllUsers(cloudId, cloudName, cloudElement);
        return indexes;
    }

    private void deleteMiniCloudMappingForAllUsers(int cloudId, String cloudName, MiniCloudElement cloudElement) {
        List list = this.miniCloudDao.getMiniCloudByName(cloudId, cloudElement.getMiniCloudName());
        for (MiniCloud miniCloud : list) {
            if (miniCloud == null) continue;
            List accessControls = this.userMiniCloudMappingDao.getAccessControlMappingsByMiniCloud(cloudId, cloudName, miniCloud.getId());
            for (UserCloudAccessControl accessControl : accessControls) {
                this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, accessControl);
            }
            this.miniCloudDao.deleteMiniCloud(cloudId, cloudName, miniCloud);
        }
    }

    private void removeAllRevisionsAndPermanentlyDeleteFiles(int cloudId, String userName, String cloudName, String miniCloudName, String folderParablu, MiniCloud miniCloud) {
        String miniCloudPath = folderParablu + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + miniCloudName;
        List miniCloudBackUpImages = this.syncBackUpImageDAO.getBackUpImageDBRecordsByDevicePathAndFileName(cloudId, userName, cloudName, folderParablu, miniCloudName, null, miniCloud);
        if (miniCloudBackUpImages == null || miniCloudBackUpImages.isEmpty()) {
            return;
        }
        List backUpImagesListMCPath = this.syncBackUpImageDAO.getBackUpImageDBRecordByOnlyDevicePath(cloudId, userName, cloudName, miniCloudPath, null, miniCloud, true);
        ArrayList<String> pathsToDelete = new ArrayList<String>();
        for (BackUpImage miniCloudBackUpImage : miniCloudBackUpImages) {
            pathsToDelete.add(miniCloudBackUpImage.getfSPath());
            this.syncBackUpImageDAO.deleteBackUpImage(cloudId, miniCloudBackUpImage, null, miniCloud);
        }
        for (BackUpImage backUpImage : backUpImagesListMCPath) {
            pathsToDelete.add(backUpImage.getfSPath());
            this.syncBackUpImageDAO.deleteBackUpImage(cloudId, backUpImage, null, miniCloud);
        }
        for (String path : pathsToDelete) {
            File file = new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + path);
            file.delete();
            file = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + path);
            file.delete();
        }
    }

    private void deleteFileRevisionPermanently(int cloudId, String cloudName, File file, FileRevision fileRevision) {
        this.fileRevisionDao.deleteRevision(cloudId, cloudName, fileRevision);
        if (fileRevision.isFolder() || file == null) {
            return;
        }
        if (!file.delete()) {
            throw new FileOperationException("coudlnt delete file", 500);
        }
    }

    @Override
    public List<SharedFileImageElement> getAllFilesSharedWithMe(int cloudId, String cloudName, String userName) {
        ArrayList<SharedFileImageElement> elements = new ArrayList<SharedFileImageElement>();
        ArrayList sharedFiles = new ArrayList();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException("User not found");
        }
        List usersSharedFileList = this.usersSharedFileDao.getUsersSharedFile(cloudId, userName);
        for (UsersSharedFile usersSharedFile : usersSharedFileList) {
        }
        if (!sharedFiles.isEmpty()) {
            List fileElements = this.fileRevisionDao.getLatestByRevisionsByConsoIds(cloudId, cloudName, sharedFiles, user.getUserName());
            elements.addAll(this.convertToSharedFileElements(fileElements, userName, ""));
        }
        return elements;
    }

    @Override
    public List<SharedFileImageElement> getAllMySharedFiles(int cloudId, String cloudName, String userName) {
        ArrayList<SharedFileImageElement> elements = new ArrayList<SharedFileImageElement>();
        ArrayList<ObjectId> sharedFiles = new ArrayList<ObjectId>();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException("User not found");
        }
        List cloudAccessControls = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
        for (UserCloudAccessControl cloudAccessControl : cloudAccessControls) {
            String folderPath;
            Object consolidatedImages;
            MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, cloudAccessControl.getMiniCloudFK());
            if (miniCloud == null || (consolidatedImages = this.consolidatedImageDao.getAllSharedFilesByDevicePath(cloudId, userName, cloudName, folderPath = "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + miniCloud.getMiniCloudName(), true)) == null) continue;
            Iterator iterator = consolidatedImages.iterator();
            while (iterator.hasNext()) {
                ConsolidatedImage consolidatedImage = (ConsolidatedImage)iterator.next();
                sharedFiles.add(consolidatedImage.getId());
            }
        }
        String base = "ParaBlu";
        List consolidatedImages = this.consolidatedImageDao.getChildrenByFolder(cloudId, userName, cloudName, base);
        if (consolidatedImages == null) {
            return elements;
        }
        List clouds = this.miniCloudDao.getAllMiniCloud(cloudId, cloudName);
        ArrayList<String> miniCloudNames = new ArrayList<String>();
        for (MiniCloud cloud : clouds) {
            miniCloudNames.add(cloud.getMiniCloudName());
        }
        for (ConsolidatedImage image : consolidatedImages) {
            if (!miniCloudNames.contains(image.getFileName()) && image.isFolder()) {
                String devicePath = "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + image.getFileName();
                List consolidatedImages1 = this.consolidatedImageDao.getAllSharedFilesByDevicePath(cloudId, userName, cloudName, devicePath, true);
                if (consolidatedImages == null) continue;
                for (ConsolidatedImage consolidatedImage : consolidatedImages1) {
                    sharedFiles.add(consolidatedImage.getId());
                }
                continue;
            }
            if (image.getSharedTimeStamp() == null || !image.isSharedByMe()) continue;
            sharedFiles.add(image.getId());
        }
        if (!sharedFiles.isEmpty()) {
            List fileElements = this.fileRevisionDao.getLatestByRevisionsByConsoIds(cloudId, cloudName, sharedFiles, user.getUserName());
            elements.addAll(this.convertToSharedFileElements(fileElements, userName, ""));
        }
        return elements;
    }

    private List<SharedFileImageElement> convertToSharedFileElements(List<FileRevision> fileRevisions, String cloudName, String minicloudName) {
        ArrayList<SharedFileImageElement> sharedFileImageElements = new ArrayList<SharedFileImageElement>();
        for (FileRevision fileRevision : fileRevisions) {
            SharedFileImageElement element = new SharedFileImageElement();
            element.setCloudName(cloudName);
            element.setMiniCloudName(minicloudName);
            element.setDevicePath(fileRevision.getConsolidatedImage().getDevicePath());
            element.setFileName(fileRevision.getConsolidatedImage().getFileName());
            element.setFileSysPath(fileRevision.getfSPath());
            element.setThumbnailPath("/t/ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileRevision.getfSPath());
            try {
                String sharedTime = fileRevision.getConsolidatedImage().getSharedTimeStamp();
                if (sharedTime != null && !"".equals(sharedTime)) {
                    long time = Long.parseLong(sharedTime);
                    element.setSharedTimeStamp(time);
                }
            }
            catch (NumberFormatException e) {
                logger.trace("" + e);
                logger.error("Exception while converting to shared file elements " + e.getMessage());
            }
            sharedFileImageElements.add(element);
        }
        return sharedFileImageElements;
    }

    @Override
    public ConsolidatedImage getConsolidatedImage(int cloudId, String userName, String cloudName, String fileName, String destinationPath) {
        return this.consolidatedImageDao.getConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, destinationPath, fileName);
    }

    @Override
    public ConsolidatedImage getExistingConsolidatedImage(int cloudId, String userName, String cloudName, String fileName, String destinationPath) {
        return this.consolidatedImageDao.getExistingConsolidatedImageDBRecordByDevicePath(cloudId, userName, cloudName, destinationPath, fileName);
    }

    @Override
    public BackUpImage getExistingSyncBackUpImage(int cloudId, String userName, String cloudName, String fileName, String destinationPath, User user, MiniCloud miniCloud) {
        return this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, destinationPath, fileName, user, miniCloud);
    }

    @Override
    public ConsolidatedImage getExistingConsolidatedImageForFolder(int cloudId, String userName, String cloudName, String fileName, String destinationPath) {
        return this.consolidatedImageDao.getExistingConsolidatedImageDBRecordByDevicePathForFolder(cloudId, userName, cloudName, destinationPath, fileName);
    }

    @Override
    public BackUpImage getExistingSyncBackUpImageForFolder(int cloudId, String userName, String cloudNameTemp, String fileName, String fileCompletePath, User user, MiniCloud miniCloud) {
        return this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePathForFolder(cloudId, userName, cloudNameTemp, fileCompletePath, fileName, user, miniCloud);
    }

    @Override
    public Boolean isDestinationPathExists(int cloudId, String userName, String cloudName, String path) {
        return this.consolidatedImageDao.isDestinationPathExists(cloudId, userName, cloudName, path);
    }

    @Override
    public boolean isSyncDestinationPathExists(int cloudId, String userName, String cloudName, String path, User user, MiniCloud miniCloud) {
        return this.syncBackUpImageDAO.isDestinationPathExists(cloudId, userName, cloudName, path, user, miniCloud);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, String fileCompletePath, boolean isPathInsideMC, String mcName) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        if (!StringUtils.isEmpty((String)mcName)) {
            if (mcName.startsWith("_mc_")) {
                mcName = mcName.replaceFirst("_mc_", "");
            }
            actionOnUser = actionOnUser + " inside minicloud " + mcName;
            audit.setMiniCloud(true);
            audit.setMcName(mcName);
        }
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setFileCompletePath(fileCompletePath);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public void updateRevisionComment(int cloudId, String cloudName, String revisionId, String comment, User user, MiniCloud miniCloud) {
        BackUpImage backUpImageVersion = this.syncBackUpImageDAO.getBackUpImageById(cloudId, revisionId, user, miniCloud);
        if (backUpImageVersion != null) {
            backUpImageVersion.setComment(comment);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, cloudName, backUpImageVersion, user, miniCloud);
        }
    }

    @Override
    public void unShareFileList(String cloudName, List<String> fileNameList, List<String> devicePathList) {
        if (fileNameList == null || fileNameList.isEmpty()) {
            return;
        }
        int size = fileNameList.size();
        for (int indexOfFile = 0; indexOfFile < size; ++indexOfFile) {
            SharedFileImage sharedFileImage = this.sharedFileImageDao.getSharedFileImageByCloud(cloudName, "", fileNameList.get(indexOfFile), devicePathList.get(indexOfFile));
            if (sharedFileImage == null) continue;
            this.usersSharedFileDao.removeUsersSharedFileBySharedFileImageId(1, sharedFileImage.getId());
            this.sharedFileImageDao.deleteFileImage(sharedFileImage);
        }
    }

    @Override
    public void updateExternalStorageStatusOfFile(int cloudId, String cloudName, ObjectId syncRevisionId, String storagePlace) {
        this.fileRevisionDao.updateExternalStorageStatusOfFile(cloudId, cloudName, syncRevisionId, storagePlace);
    }

    public static List<SearchIndex> getSearchIndexForDeleteFiles(int cloudId, List<FileRevision> fileListFromDatabase) {
        ArrayList<SearchIndex> searchIndexs = new ArrayList<SearchIndex>();
        if (fileListFromDatabase == null) {
            return searchIndexs;
        }
        for (FileRevision fileRevision : fileListFromDatabase) {
            if (fileRevision == null) continue;
            SearchIndex searchIndex = new SearchIndex();
            searchIndex.setCloudId(cloudId);
            ConsolidatedImage consolidatedImage = fileRevision.getConsolidatedImage();
            searchIndex.setConsolidatedImageId(consolidatedImage.getId());
            searchIndex.setPresent(false);
            searchIndex.setAbstractFolderUrl(consolidatedImage.getDevicePath());
            searchIndex.setFileName(consolidatedImage.getFileName());
            searchIndex.setFolder(consolidatedImage.isFolder());
            searchIndex.setSize(String.valueOf(fileRevision.getSize()));
            searchIndex.setLastModifiedTime(consolidatedImage.getModifiedTime());
            searchIndex.setFsPath(fileRevision.getfSPath());
            searchIndex.setUserName(fileRevision.getUserName());
            searchIndex.setMiniCloud(consolidatedImage.isMiniCloud());
            searchIndexs.add(searchIndex);
        }
        return searchIndexs;
    }

    @Override
    public FileRevisionElement validateResourceFileForCopy(int cloudId, String userName, String cloudName, String fileName, String destinationPath, User user, MiniCloud miniCloud) {
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, destinationPath, fileName, user, miniCloud);
        if (backUpImage == null) {
            boolean isFileNameInsideMC = false;
            try {
                String[] list = destinationPath.split("/");
                logger.debug(" !!!!!!!!!!!!!!!!!! " + list[1]);
                isFileNameInsideMC = this.syncBackUpImageDAO.isPathMiniCloud(cloudId, list[1], user, miniCloud);
                if (isFileNameInsideMC) {
                    backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, "", cloudName, destinationPath, fileName, user, miniCloud);
                }
                logger.debug("Inside minicloud check .... " + backUpImage);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception while validating resource file for copy " + e.getMessage());
            }
        }
        if (backUpImage == null || !backUpImage.isPresent()) {
            return null;
        }
        backUpImage = this.getLatestImageForDeletedFiles(cloudId, userName, backUpImage, user, miniCloud);
        FileRevisionElement fileRevisionElement = new FileRevisionElement();
        this.convertFileRevisionDomainToElement(backUpImage, fileRevisionElement);
        fileRevisionElement.setRevisionId(backUpImage.getId());
        return fileRevisionElement;
    }

    @Override
    public boolean isFilesInBlukrypt(int cloudId, String userName, String path, String fileName) {
        return this.fileRevisionDao.isFilesInBlukrypt(cloudId, userName, path, fileName);
    }

    @Override
    public boolean areSyncFilesInBlukrypt(int cloudId, String cloudName, String userName, String path, String fileName, User user, MiniCloud miniCloud) {
        boolean areSyncFilesInBlukrypt = false;
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, path, fileName, user, miniCloud);
        ArrayList<BackUpImage> folderList = new ArrayList<BackUpImage>();
        folderList.add(backUpImage);
        String newPath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
        this.getChildFoldersForBaseFolder(cloudId, cloudName, userName, newPath, folderList, user, miniCloud, true);
        long count = 0L;
        for (BackUpImage subFolder : folderList) {
            count = this.syncBackUpImageDAO.areFilesInBlukrypt(cloudId, userName, subFolder.getDevicePath(), subFolder.getFileName(), user, miniCloud);
        }
        if (count > 0L) {
            areSyncFilesInBlukrypt = true;
        }
        return areSyncFilesInBlukrypt;
    }

    @Override
    public FileRevision getLatestRevisionForConsId(int cloudId, String consId) {
        return this.fileRevisionDao.getLatestRevision(cloudId, "", new ObjectId(consId));
    }

    @Override
    public String getDeviceNameByUUID(int cloudId, String cloudName, String deviceUUID) {
        String deviceName = null;
        if (deviceUUID != null) {
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
            deviceName = device.getDeviceName();
        }
        return deviceName;
    }

    @Override
    public FileRevisionElement validateResourceFile(int cloudId, String cloudNameTemp, String backupID) {
        FileRevisionElement fileRevisionElement = new FileRevisionElement();
        BackUpImage imageFile = this.backUpImageDao.getBackupFileForIDForValidate(cloudId, backupID);
        if (imageFile == null || !imageFile.isPresent()) {
            return null;
        }
        this.convertFileRevisionDomainToElement(imageFile, fileRevisionElement);
        return fileRevisionElement;
    }

    private BackUpImage getLatestImageForDeletedFiles(int cloudId, String userName, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        if (!StringUtils.isEmpty((String)backUpImage.getStatus()) && backUpImage.getStatus().equals(RESTORED)) {
            List backUpImageList = this.syncBackUpImageDAO.getBackUpImageDBRecordsByDevicePathAndFileName(cloudId, userName, "", backUpImage.getDevicePath(), backUpImage.getFileName(), user, miniCloud);
            for (BackUpImage image : backUpImageList) {
                if (image.getStatus().equals(RESTORED) || image.getStatus().equals(DELETED)) continue;
                return image;
            }
        }
        return backUpImage;
    }
}

