/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.service.impl;

import com.parablu.bluvault.mem.MemoryStore;
import com.parablu.bluvault.sync.service.DeleteDelegate;
import com.parablu.bluvault.sync.service.ResourceSyncService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.to.StatusDetailTO;
import com.parablu.paracloud.util.CacheHelper;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.User;
import com.parablu.rf.service.DeleteTimerService;
import com.parablu.rf.service.SearchService;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteDelegateImpl
implements DeleteDelegate {
    private static Logger logger = LogManager.getLogger(DeleteDelegateImpl.class);
    @Autowired
    private DeleteTimerService deleteTimerService;
    @Autowired
    private ResourceSyncService resourceService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    private static final String KEY = "BATCHOPERATION";
    private static final String VALUE = "locked";
    private static final int DEFAULT_TIME_RANGE = 7200;
    private static final int OPERATION_SUCESS = 1;
    private static final int OPERATION_IN_PROGRESS = 2;

    private StatusDetailTO createMemoryLockForBatchProcess(String key, String value) throws IOException {
        String valueForUser = "locked:" + value;
        CacheHelper cacheHelper = new CacheHelper();
        String currentValue = cacheHelper.getValueFromCache(key);
        if (currentValue == null) {
            cacheHelper.addValueToCache(key, valueForUser, 7200);
            return new StatusDetailTO(1, value, null);
        }
        String[] values = currentValue.split(":");
        return new StatusDetailTO(2, values[1], null);
    }

    private void forceUnlockProcess(String key) throws IOException {
        CacheHelper cacheHelper = new CacheHelper();
        cacheHelper.removeKeyFromCache(key);
    }

    protected void addSearchIndexToTable(Cloud cloud, List<SearchIndex> searchIndexs) {
        if (cloud.getContentSearchEnabled() == 1) {
            this.searchService.addFilesToTable(searchIndexs, cloud.getCloudName());
        }
    }

    protected void addSearchIndexToTable(Cloud cloud, SearchIndex searchIndexs) {
        if (cloud.getContentSearchEnabled() == 1) {
            this.searchService.addFileToTable(searchIndexs, cloud.getCloudName());
        }
    }

    @Override
    public StatusDetailTO deleteAllOlderThrashResourcesAccordingToVersion(CloudLicenseTo cl, String userName) throws IOException {
        String key = cl.getCloud().getCloudName() + ":" + KEY;
        String cloudName = cl.getCloud().getCloudName();
        StatusDetailTO detailTO = this.createMemoryLockForBatchProcess(key, userName);
        if (detailTO.getStatus() != 1) {
            return detailTO;
        }
        int limit = 500;
        Long fileRevisionCount = this.deleteTimerService.getCountOfAllLatestFileRevisions(cl.getCloud().getCloudId(), cloudName, (long)cl.getCloud().getVersioningEnabled());
        int i = 0;
        while ((long)i < fileRevisionCount) {
            this.deleteTimerService.deleteOlderFileRevisionsBasedOnRevisionCount(cl.getCloud().getCloudId(), cloudName, cl.getCloud(), cl.getCloud().getVersioningEnabled(), 0, limit);
            i += limit;
        }
        this.forceUnlockProcess(key);
        return new StatusDetailTO(1, null, null);
    }

    @Override
    public StatusDetailTO deleteAllOlderThrashResourceExceptCurrent(CloudLicenseTo cl, String userName) throws IOException {
        String key = cl.getCloud().getCloudName() + ":" + KEY;
        StatusDetailTO detailTO = this.createMemoryLockForBatchProcess(key, userName);
        String cloudName = cl.getCloud().getCloudName();
        if (detailTO.getStatus() != 1) {
            return detailTO;
        }
        int limit = 500;
        Long fileRevisionCount = this.deleteTimerService.getCountOfAllLatestFileRevisions(cl.getCloud().getCloudId(), cloudName, 1L);
        int i = 0;
        while ((long)i < fileRevisionCount) {
            this.deleteTimerService.deleteAllOlderFileRevision(cl.getCloud().getCloudId(), cloudName, cl.getCloud(), 0, limit);
            i += limit;
        }
        this.forceUnlockProcess(key);
        return new StatusDetailTO(1, null, null);
    }

    @Override
    public StatusDetailTO restoreAllResources(String userName, boolean restoreSuccess, CloudLicenseTo cl, int cloudId, String cloudName, int limit, Long allDeletedRecourcesCount) throws Exception {
        logger.debug("@@@@@ restore all inside deletedelegateimpt ");
        String key = cl.getCloud().getCloudName().toLowerCase() + ":" + KEY + userName;
        if (MemoryStore.get((String)key) != null) {
            return new StatusDetailTO(2, null, null);
        }
        MemoryStore.add((String)key, (Object)userName);
        int i = 0;
        while ((long)(i * limit) < allDeletedRecourcesCount) {
            List<FileRevision> elements = this.resourceService.getAlldeletedResourceFileRevision(cloudId, cloudName, 0, limit, userName, null);
            logger.debug("@@@@@ restore all allDeletedRecourcesCount inside deletedelegateimpt " + elements);
            if (!elements.isEmpty()) {
                logger.debug("@@@@@ restore all elements.isEmpty() inside deletedelegateimpt " + elements);
                List<SearchIndex> searchIndexs2 = this.resourceService.restoreAllResources(cloudId, cloudName, cl.getCloud(), elements, userName);
                logger.debug("@@@@@ restore all resourceService.restoreAllResoruces completed " + elements);
                if (searchIndexs2 != null) {
                    this.addSearchIndexToTable(cl.getCloud(), searchIndexs2);
                    logger.debug("@@@@@ restore all else searchIndexs2  not null inside deletedelegateimpt " + elements);
                } else {
                    logger.debug("@@@@@ restore all else searchIndexs2 inside deletedelegateimpt " + elements);
                    break;
                }
            }
            ++i;
        }
        MemoryStore.delete((String)key);
        return new StatusDetailTO(1, null, null);
    }

    @Override
    public StatusDetailTO deleteThrashResources(String userName, CloudLicenseTo cl, int cloudId, boolean isSearchEnabled) throws IOException {
        int limit = 500;
        String key = cl.getCloud().getCloudName() + ":" + KEY;
        StatusDetailTO detailTO = this.createMemoryLockForBatchProcess(key, userName);
        if (detailTO.getStatus() != 1) {
            return detailTO;
        }
        String cloudName = cl.getCloud().getCloudName();
        User user = this.userDao.getUserByName(cloudId, userName);
        FileListElement fileListElement = new FileListElement();
        List<BackUpImage> deletedFiles = this.resourceService.getDeletedResourceFilesForTrash(cloudId, cloudName, userName, user);
        for (BackUpImage backUpImage : deletedFiles) {
            MiniCloud miniCloud = null;
            String userNameVal = userName;
            User userVal = null;
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, backUpImage.getDevicePath());
            if (isPathInsideMC) {
                String mcName = DeleteDelegateImpl.getMCName(backUpImage.getDevicePath());
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
                userNameVal = "";
            } else {
                userVal = user;
            }
            FileElement fileElement = new FileElement();
            fileElement.setFileCompletePath(backUpImage.getDevicePath());
            fileElement.setFileName(backUpImage.getFileName());
            this.deleteTimerService.deleteFileEntryFromTrashDirectly(cloudId, userNameVal, cloudName, cl.getCloud(), isSearchEnabled, fileElement, userVal, miniCloud);
        }
        this.forceUnlockProcess(key);
        return new StatusDetailTO(1, null, null);
    }

    private boolean isPathInsideMC(int cloudId, String path) {
        String mcNameFromPath = DeleteDelegateImpl.getMCName(path);
        if (StringUtils.isEmpty((String)mcNameFromPath)) {
            return false;
        }
        List cloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, "").getMiniClouds();
        boolean isPathInsideMC = false;
        for (MiniCloudElement miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }
}

