/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.exception.FileConflictException;
import com.parablu.bluvault.sync.exception.FileOperationException;
import com.parablu.bluvault.sync.service.DeleteDelegate;
import com.parablu.bluvault.sync.service.ResourceSyncService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.dto.ShareAndSearchDLTO;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileJsonElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.FileRevisionElement;
import com.parablu.paracloud.element.FileRevisionsListElement;
import com.parablu.paracloud.element.FolderInfoJsonElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudFileElement;
import com.parablu.paracloud.element.MiniCloudFileListElement;
import com.parablu.paracloud.element.MiniCloudFileListJsonElement;
import com.parablu.paracloud.element.MiniCloudJsonElement;
import com.parablu.paracloud.element.SharedFileImageElement;
import com.parablu.paracloud.element.response.CloudBasicElement;
import com.parablu.paracloud.to.StatusDetailTO;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import com.parablu.psc.service.DirectoryStatisticsService;
import com.parablu.rf.exception.ResourceFunnelException;
import com.parablu.rf.service.DeleteTimerService;
import com.parablu.rf.service.DownloadService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ResourceController
extends BaseController {
    private static Logger logger = LogManager.getLogger(ResourceController.class);
    @Autowired
    private ResourceSyncService resourceService;
    @Autowired
    private DirectoryStatisticsService directoryService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeleteTimerService deleteTimerService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    private DeleteDelegate deleteDelegate;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private DownloadService downloadService;
    private static final String EXCEPTION = "Exception";
    private static final String INVALID_FILE_NAME = "Invalid file name.";
    private static final String RELATIVE_PATH = " and the relative path: ";
    private static final String IS_MOBILE = "isMobile";
    private static final String RECORD_EXISTS_ERROR = "ERRROR RECORD Already exist ... ";
    private static final String INVALID_REQUEST = "Invalid request.";
    private static final String DATA_ACCESS_EXCEPTION = "DataAccessException";
    private static final String BASE_EXCEPTION = "BaseException";
    private static final String SELECTED_PATHS = "selectedPaths";
    private static final String PATH = "PATH is: ";
    private static final String BAD_PATH = "BAD PATH ";
    private static final String NULL_FILE_NAME = "FILE NAME IS NULL";
    private static final String CALLING_DELETE = "@@@@@@  Calling delete for fileName: ";
    private static final String STATUS_200 = "status: 200";
    private static final String EXCEPTION_DELETING_OLD_REVISIONS = "Exception while deleting older revision resource ";
    private static final String EXCEPTION_DELETING_ALL_OLD_REVISIONS = "Exception while deleting all older revision resource ";
    private static final String TOTAL_FILES = " TOTAL no of files .... ";
    private static final String INSIDE_SINGLE_FILE_COPY = " inside single file copy .. ";
    private static final String STATUS_NOT_FOUND = "status : not not found";
    private static final String EXCEPTION_WHILE_RESTORING = "Exception while restoring resource ";
    private static final String CALLING_THRASH_API = "calling /files/thrash/all ...";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException";
    private static final String FILES_NOT_MOVED_TO_BLUKRYPT = " There are files which are not moved to BluKrypt.....";
    private static final String EXCEPTION_WHILE_COPY = "Exception while copying resource file ";
    private static final String EXCEPTION_WHILE_CUT_PASTE = "Exception while cut paste ";
    private static final String UTF_8 = "UTF-8";
    private static final String EXCEPTION_UPDATING_REVISION_COMMENTS = "Exception while updating revision comments ";
    private static final String MOBILE_HEADER_LOG = "@@@Mobile header flag  ... ";
    private static final String DEVICE_NAME = "deviceName";

    @RequestMapping(value={"cloud/{cloudName}/files/child"}, method={RequestMethod.GET})
    public ModelAndView getChildrenForFolder(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        MiniCloudFileListElement fileListElement = new MiniCloudFileListElement();
        String cloudNameTemp = cloudName;
        String contentType = request.getHeader("contentType");
        boolean showDeletedFiles = Boolean.parseBoolean(request.getHeader("showDeletedFiles"));
        if (StringUtils.isEmpty((String)contentType)) {
            logger.debug("@@@ calling getChildrenForFolder XML_VIEW /files/child ..." + contentType);
            modelAndView.setViewName("xmlview");
        } else {
            logger.debug("@@@ calling getChildrenForFolder JSON_VIEW /files/child ..." + contentType);
            modelAndView.setViewName("jsonview");
        }
        String folderPath = request.getHeader("path");
        if (!StringUtils.isEmpty((String)folderPath)) {
            folderPath = this.decodeBase64UTFString(folderPath);
            logger.debug("@@@ after decoding ..." + folderPath);
        }
        if (!StringUtils.isEmpty((String)folderPath) && folderPath.endsWith("/")) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        logger.debug("@@@ calling getChildrenForFolder /files/child trim ..." + folderPath);
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ calling getChildrenForFolder checkLicense /files/child ...");
                return null;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                logger.error("@@@ calling getChildrenForFolder performAuthorization /files/child ...");
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            List cloudRestrictedElementList = null;
            List cloudUserElementList = null;
            String[] params = folderPath.split("/");
            if (params.length < 1) {
                response.setStatus(400);
                logger.error("@@@ calling getChildrenForFolder params.length /files/child ...");
                return null;
            }
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser().getUserName(), params)) {
                logger.error("@@@ calling getChildrenForFolder validateMiniCloudByName /files/child ...");
                return null;
            }
            if (folderPath.equalsIgnoreCase("ParaBlu")) {
                cloudRestrictedElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp).getMiniClouds();
                cloudUserElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, authorizationTokens.getUser().getUserId()).getMiniClouds();
                cloudRestrictedElementList.removeAll(cloudUserElementList);
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(authorizationTokens.getUser().getUserName() + " SKIP VALUE .................. " + skipValue);
            List<MiniCloudFileElement> fileList = this.resourceService.getChildren(cloudId, cloudNameTemp, folderPath, skipValue, cloudRestrictedElementList, cloudUserElementList, authorizationTokens.getUser().getUserName(), authorizationTokens.getUser().getUserId(), showDeletedFiles);
            Collections.sort(fileList, new Comparator<MiniCloudFileElement>(){

                @Override
                public int compare(MiniCloudFileElement m1, MiniCloudFileElement m2) {
                    return new CompareToBuilder().append(m1.isMinicloud(), m2.isMinicloud()).append(m1.isFolder(), m2.isFolder()).append((Object)m1.getFileName().toLowerCase(), (Object)m2.getFileName().toLowerCase()).toComparison();
                }
            });
            fileListElement.setFileElementList(fileList);
            modelAndView.addObject((Object)fileListElement);
            response.setStatus(200);
            logger.debug("@@@ end of calling getChildrenForFolder sorting added /files/child ..." + fileList.size());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/validatetoken"}, method={RequestMethod.GET})
    public void validateToken(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        try {
            String token;
            logger.debug("@@@@ Inside VALIDATE TOKEN ...." + cloudNameTemp);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                logger.error("@@ VALIDATE TOKEN checkLicense failed for cloud ...." + cloudNameTemp);
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                logger.error("@@ VALIDATE TOKEN performAuthorization failed for cloud ...." + cloudNameTemp);
                return;
            }
            response.setStatus(200);
            logger.debug("@@@@ End of VALIDATE TOKEN ...." + cloudNameTemp);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating token " + e.getMessage());
            response.setStatus(500);
            return;
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating token " + e.getMessage());
            response.setStatus(400);
            return;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.error("@@@@ VALIDATE TOKEN checkLicense failed for cloud ...." + cloudNameTemp);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/validate"}, method={RequestMethod.GET})
    public ModelAndView validateResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String contentType = request.getHeader("contentType");
        String productType = request.getHeader("productType");
        logger.debug("@@..Product Type::>" + productType);
        String cloudNameTemp = cloudName;
        if (StringUtils.isEmpty((String)contentType)) {
            modelAndView.setViewName("xmlview");
        } else {
            modelAndView.setViewName("jsonview");
        }
        logger.debug("calling /files/validate ...");
        String path = request.getHeader("path");
        String fileRevisionId = request.getHeader("fileRevisionId");
        logger.debug("fileRevisionId............." + fileRevisionId);
        try {
            String token;
            String relativePath = "";
            String fileName = "";
            if (!StringUtils.isEmpty((String)path)) {
                if (StringUtils.isBlank((String)path)) {
                    throw new BaseException("Invalid file path.");
                }
                String[] params = path.split("/");
                if (params.length <= 1) {
                    throw new BaseException(INVALID_FILE_NAME);
                }
                fileName = params[params.length - 1];
                if (StringUtils.isBlank((String)fileName)) {
                    throw new BaseException(INVALID_FILE_NAME);
                }
                relativePath = path.substring(0, path.length() - (fileName.length() + 1));
            }
            logger.debug("Calling validate for fileName : " + fileName + RELATIVE_PATH + relativePath);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            cloudNameTemp = cl.getCloud().getCloudName();
            MiniCloud miniCloud = null;
            User user = null;
            if (this.isPathInsideMC(cloudId, relativePath)) {
                String mcName = ResourceController.getMCName(path);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            } else {
                user = authorizationTokens.getUser();
            }
            if (StringUtils.isEmpty((String)productType)) {
                boolean isPathInsideMC;
                logger.debug("............");
                String userName = authorizationTokens.getUser().getUserName();
                FileRevisionElement file = null;
                if (!StringUtils.isEmpty((String)relativePath) && (isPathInsideMC = this.isPathInsideMC(cloudId, relativePath))) {
                    userName = "";
                }
                if (!StringUtils.isEmpty((String)fileRevisionId)) {
                    logger.debug("...fileRevisionId....." + fileRevisionId);
                    file = this.resourceService.validateResourceFileByRevId(cloudId, userName, fileRevisionId, user, miniCloud);
                } else {
                    file = this.resourceService.validateResourceFile(cloudId, userName, cloudNameTemp, fileName, relativePath, user, miniCloud);
                }
                logger.debug(fileName + " file inside validate without escaping ..... " + file);
                if (file != null && StringUtils.isNotBlank((String)file.getFileName()) && StringUtils.isNotBlank((String)file.getFileCompletePath())) {
                    file.setFileRevisionId(file.getRevisionId().toString());
                    logger.debug(file.getFileRevisionId() + "file is not null" + file.getRevisionId().toString());
                    modelAndView.addObject((Object)file);
                    response.setStatus(200);
                    return modelAndView;
                }
                logger.debug("file is null it seems");
                response.setStatus(404);
            } else {
                String backupID = request.getHeader("backupID");
                FileRevisionElement file = this.resourceService.validateResourceFile(cloudId, cloudNameTemp, backupID);
                if (file != null && StringUtils.isNotBlank((String)file.getFileName()) && StringUtils.isNotBlank((String)file.getFileCompletePath())) {
                    logger.debug(file.getBackupId() + "file is not null");
                    modelAndView.addObject((Object)file);
                    response.setStatus(200);
                    return modelAndView;
                }
                logger.debug("file is null it seems");
                response.setStatus(404);
            }
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating Resource " + e.getMessage());
            response.setStatus(500);
            return null;
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating Resource " + e.getMessage());
            response.setStatus(400);
            return null;
        }
        return null;
    }

    @RequestMapping(value={"cloud/{cloudName}/files/upload"}, method={RequestMethod.POST})
    public void uploadResource(@PathVariable(value="cloudName") String cloudName, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView modelAndView = new ModelAndView();
        String contentType = request.getHeader("contentType");
        String cloudNameTemp = cloudName;
        if (StringUtils.isEmpty((String)contentType)) {
            logger.debug("@@@ calling getChildrenForFolder XML_VIEW cloud/{cloudName}/myclouds ..." + contentType);
            modelAndView.setViewName("xmlview");
        } else {
            logger.debug("@@@ calling getChildrenForFolder JSON_VIEW cloud/{cloudName}/myclouds" + contentType);
            modelAndView.setViewName("jsonview");
        }
        logger.debug("@@@ INSIDE uploadResource calling /files/upload ...");
        String userName = request.getHeader("userName");
        boolean isCreateFolder = this.isCreateFolder(request);
        logger.debug("@@@@@@@@ calling /files/upload upload file before check License  ...  " + cloudNameTemp);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            logger.debug("@@@@@@@@ calling /files/upload upload file License failed ...  " + cloudNameTemp);
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String mobileHeader = request.getHeader(IS_MOBILE);
        logger.debug(fileElement.getFileName() + MOBILE_HEADER_LOG + mobileHeader);
        boolean isMobile = Boolean.parseBoolean(mobileHeader);
        User user = null;
        MiniCloud miniCloud = null;
        if (isCreateFolder) {
            String escapedFileName = QueryParser.escape((String)fileElement.getFileName());
            String escapedRelativePath = QueryParser.escape((String)fileElement.getFileCompletePath());
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, fileElement.getFileCompletePath());
            String userNameToCheckFolderExists = userName;
            if (isPathInsideMC) {
                userNameToCheckFolderExists = "";
                String mcName = ResourceController.getMCName(fileElement.getFileCompletePath());
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            } else {
                user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            }
            logger.debug("userNameToCheckFolderExists:" + userNameToCheckFolderExists);
            BackUpImage backUpImage = this.resourceService.getExistingSyncBackUpImageForFolder(cloudId, userNameToCheckFolderExists, cloudNameTemp, escapedFileName, escapedRelativePath, user, miniCloud);
            logger.debug("BackUpImage:" + backUpImage);
            if (backUpImage != null) {
                logger.debug(fileElement.getFileName() + RECORD_EXISTS_ERROR + fileElement.getFileCompletePath());
                response.setStatus(411);
                return;
            }
        }
        String token = request.getHeader("token");
        this.fileUpload(cloudNameTemp, fileElement, response, userName, isCreateFolder, isMobile, token, request, user, miniCloud);
    }

    @RequestMapping(value={"cloud/{cloudName}/portal/files/upload"}, method={RequestMethod.POST})
    public void uploadPortalResource(@PathVariable(value="cloudName") String cloudName, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("@@@ INSIDE uploadResource calling /portal/files/upload ...");
        String userName = request.getHeader("userName");
        String cloudNameTemp = cloudName;
        boolean isCreateFolder = this.isCreateFolder(request);
        logger.debug("@@@@@@@@ calling /files/upload upload file before check License  ...  " + cloudNameTemp);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            logger.debug("@@@@@@@@ calling /files/upload upload file License failed ...  " + cloudNameTemp);
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        String mobileHeader = request.getHeader(IS_MOBILE);
        logger.debug(fileElement.getFileName() + MOBILE_HEADER_LOG + mobileHeader);
        boolean isMobile = Boolean.parseBoolean(mobileHeader);
        if (isCreateFolder && isMobile) {
            Pattern namePattern = Pattern.compile("[A-Za-z0-9 ]+");
            Matcher matcher = namePattern.matcher(fileElement.getFileName());
            if (!matcher.matches()) {
                response.setStatus(406);
                return;
            }
            ConsolidatedImage consolidatedImage = this.resourceService.getExistingConsolidatedImage(cloudId, userName, cloudNameTemp, fileElement.getFileName(), fileElement.getFileCompletePath());
            if (consolidatedImage != null) {
                logger.debug(fileElement.getFileName() + RECORD_EXISTS_ERROR + fileElement.getFileCompletePath());
                response.setStatus(411);
                return;
            }
        }
        ServletInputStream inputStream = request.getInputStream();
        logger.debug(" input stream  ..... " + inputStream);
        String token = request.getHeader("token");
        this.fileUpload(cloudNameTemp, fileElement, response, userName, isCreateFolder, isMobile, token, request, null, null);
    }

    private void fileUpload(String cloudName, FileElement fileElement, HttpServletResponse response, String userName, boolean isCreateFolder, boolean isMobile, String token, HttpServletRequest request, User user, MiniCloud miniCloud) {
        try {
            List<SearchIndex> searchIndexs;
            String[] params;
            if (StringUtils.isBlank((String)fileElement.getFileName()) || StringUtils.isBlank((String)fileElement.getFileCompletePath()) || StringUtils.isBlank((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            logger.debug("Calling upload for fileName: " + fileElement.getFileName() + RELATIVE_PATH + fileElement.getFileCompletePath());
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
            if (!this.checkLicense(cl, response)) {
                File f = new File(PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileElement.getFileName());
                if (f.exists()) {
                    f.delete();
                }
                return;
            }
            if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            String mcName = "";
            boolean isPathInsideMiniCoud = this.isPathInsideMC(cloudId, fileElement.getFileCompletePath());
            if (isPathInsideMiniCoud) {
                mcName = ResourceController.getMCName(fileElement.getFileCompletePath());
            }
            if ((params = fileElement.getFileCompletePath().split("/")).length < 1) {
                response.setStatus(400);
                return;
            }
            if (!this.validateMiniCloudByName(response, cloudId, cloudName, userName, params)) {
                return;
            }
            try {
                searchIndexs = this.resourceService.uploadResourceFile(cloudId, cloudName, cl.getCloud(), fileElement, userName, false, user, miniCloud, isPathInsideMiniCoud);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
                throw new BaseException(e.getMessage());
            }
            if (searchIndexs != null) {
                response.setStatus(200);
                String action = "uploaded";
                int actionType = PCActionTypes.FILE_UPLOAD.getActionTypeValue();
                if (isCreateFolder) {
                    action = "created a Folder in " + fileElement.getFileCompletePath();
                    actionType = PCActionTypes.FOLDER_CREATE.getActionTypeValue();
                }
                String deviceName = "Portal";
                if (isMobile) {
                    deviceName = request.getHeader(DEVICE_NAME);
                }
                this.auditHistoryService.saveStatisticToDatabaseForMC(cloudId, cloudName, action, userName, fileElement.getFileName(), deviceName, System.currentTimeMillis(), fileElement.getFileCompletePath(), actionType, mcName);
            } else {
                logger.debug(" ............... searchIndexs null ............... ");
                response.setStatus(500);
            }
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        catch (FileConflictException e) {
            logger.trace("FileConflictException :" + (Object)((Object)e));
            logger.error("FileConflictException :" + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/delete"}, method={RequestMethod.DELETE})
    public void deleteResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String path = request.getHeader("path");
        this.deleteFilesInCloud(cloudName, path, request, response, false);
    }

    @RequestMapping(value={"cloud/{cloudName}/mobile/files/delete"}, method={RequestMethod.POST})
    public void deleteResourceForMobiles(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String path = request.getHeader("path");
        this.deleteFilesInCloud(cloudName, path, request, response, true);
    }

    @RequestMapping(value={"cloud/{cloudName}/selected/files/delete"}, method={RequestMethod.DELETE})
    public void deleteSelectedResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String selectedPaths = request.getHeader(SELECTED_PATHS);
        selectedPaths = this.decodeBase64UTFString(selectedPaths);
        logger.debug("after decoding pathss..." + selectedPaths);
        ArrayList<String> pathsList = new ArrayList<String>(Arrays.asList(selectedPaths.split("\\|")));
        int i = 0;
        for (String path : pathsList) {
            logger.debug(" !@!#@!#!@#!@#!@   " + path);
            ++i;
            String mobileHeader = request.getHeader(IS_MOBILE);
            logger.debug(" Mobile header flag  ... " + mobileHeader);
            boolean isMobile = Boolean.parseBoolean(mobileHeader);
            this.deleteFilesInCloud(cloudName, path, request, response, isMobile);
        }
        logger.debug(" Total no of files to delete " + i);
    }

    @RequestMapping(value={"cloud/{cloudName}/mobile/selected/files/delete"}, method={RequestMethod.POST})
    public void deleteSelectedResourceForMobile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String selectedPaths = request.getHeader(SELECTED_PATHS);
        selectedPaths = this.decodeBase64UTFString(selectedPaths);
        logger.debug("after decoding pathss..." + selectedPaths);
        ArrayList<String> pathsList = new ArrayList<String>(Arrays.asList(selectedPaths.split("\\|")));
        int i = 0;
        for (String path : pathsList) {
            logger.debug(" !@!#@!#!@#!@#!@  " + path);
            ++i;
            path = path.replace("\\", "");
            this.deleteFilesInCloud(cloudName, path, request, response, false);
        }
        logger.debug(" Total no of files to delete " + i);
    }

    private void deleteFilesInCloud(String cloudName, String path, HttpServletRequest request, HttpServletResponse response, boolean isMobile) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /files/delete ...");
        String userName = request.getHeader("userName");
        ShareAndSearchDLTO shareAndSearchDLTO = null;
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/delete ..." + path);
        try {
            SyncPolicy syncPolicy;
            AuthorizationTokens authorizationTokens;
            String token;
            if (StringUtils.isBlank((String)path) || StringUtils.isBlank((String)userName)) {
                logger.debug(PATH + path + " username: " + userName);
                throw new BaseException(INVALID_REQUEST);
            }
            String[] params = path.split("/");
            if (params.length <= 1) {
                logger.debug(BAD_PATH);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String fileName = params[params.length - 1];
            if (StringUtils.isBlank((String)fileName)) {
                logger.debug(NULL_FILE_NAME);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String relativePath = path.substring(0, path.length() - (fileName.length() + 1));
            logger.debug(CALLING_DELETE + fileName + RELATIVE_PATH + relativePath);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@@@@  performAuthorization checkLicense failed during delete  ");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                logger.debug(" @@@@@@ performAuthorization failed during delete  ");
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, (authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token)).getUser(), params)) {
                logger.debug(" @@@@@@ validateMiniCloudByName failed during delete  ");
                return;
            }
            String userNameVal = authorizationTokens.getUser().getUserName();
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, relativePath);
            User user = null;
            MiniCloud miniCloud = null;
            if (isPathInsideMC) {
                userNameVal = "";
                String mcName = ResourceController.getMCName(relativePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            } else {
                user = authorizationTokens.getUser();
            }
            BackUpImage backUpImage = this.resourceService.getExistingSyncBackUpImage(cloudId, userNameVal, cloudNameTemp, fileName, relativePath, user, miniCloud);
            if (backUpImage == null) {
                logger.debug(fileName + "@@@@@@  RECORD does not exist ... " + relativePath);
                response.setStatus(403);
                return;
            }
            Cloud cloud = cl.getCloud();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.managementService.getSyncPolicyByPolicyName(cloudId, authorizationTokens.getUser().getSyncPolicyName())) != null && syncPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            try {
                shareAndSearchDLTO = this.resourceService.deleteResourceFile(cloudId, cloudNameTemp, fileName, relativePath, userName, isPathInsideMC, isSearchEnabled, user, miniCloud, backUpImage.isFolder());
            }
            catch (Exception e) {
                logger.trace("Exception :" + e);
                logger.error("Exception :" + e.getMessage());
                logger.debug(" @@@@@@ validateMiniCloudByName failed during delete  " + e);
                throw new BaseException(e.getMessage());
            }
            String deviceName = "Portal";
            if (isMobile) {
                deviceName = request.getHeader(DEVICE_NAME);
            }
            if (shareAndSearchDLTO != null) {
                this.addSearchIndexToTable(cl.getCloud(), shareAndSearchDLTO.getSearchIndexs());
                this.resourceService.unShareFileList(cloudNameTemp, shareAndSearchDLTO.getSharedFileNames(), shareAndSearchDLTO.getSharedDevicePaths());
                String mcNameFromPath = ResourceController.getMCName(path);
                logger.debug("......ispath..." + isPathInsideMC + "...." + path);
                if (!isPathInsideMC) {
                    mcNameFromPath = "";
                }
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "deleted", userName, path, deviceName, System.currentTimeMillis(), PCActionTypes.FILE_DELETE.getActionTypeValue(), isPathInsideMC, mcNameFromPath);
                logger.debug(STATUS_200);
                response.setStatus(200);
            } else {
                logger.error(" @@@@@@ Record not found  failed during delete  ");
                response.setStatus(404);
            }
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while deleting file in cloud " + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while deleting file in cloud " + e.getMessage());
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.debug(" @@@@@@ Record not found  failed during delete  " + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/revisions/delete/older"}, method={RequestMethod.DELETE})
    public void deleteOlderRevisionsResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        try {
            String token;
            User user = new User();
            String cloudNameTemp = cloudName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return;
            }
            if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            if (!authorizationTokens.getUser().isAdmin()) {
                response.setStatus(401);
                return;
            }
            StatusDetailTO status = this.deleteDelegate.deleteAllOlderThrashResourcesAccordingToVersion(cl, user.getUserName());
            if (status.getStatus() == 1) {
                response.setStatus(200);
            } else {
                response.setStatus(425);
                response.setHeader("user", status.getBasicInfo());
            }
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_DELETING_OLD_REVISIONS + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException | IOException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_DELETING_OLD_REVISIONS + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/revisions/delete/all"}, method={RequestMethod.DELETE})
    public void deleteAllOlderRevisionsResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        try {
            String token;
            String cloudNameTemp = cloudName;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            User user = new User();
            if (!this.checkLicense(cl, response)) {
                return;
            }
            if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            if (!authorizationTokens.getUser().isAdmin()) {
                response.setStatus(401);
                return;
            }
            StatusDetailTO status = this.deleteDelegate.deleteAllOlderThrashResourceExceptCurrent(cl, user.getUserName());
            if (status.getStatus() == 1) {
                response.setStatus(200);
            } else {
                response.setStatus(425);
                response.setHeader("user", status.getBasicInfo());
            }
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_DELETING_ALL_OLD_REVISIONS + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException | IOException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_DELETING_ALL_OLD_REVISIONS + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/restore"}, method={RequestMethod.POST})
    public void restoreLatestResource(@PathVariable(value="cloudName") String cloudName, @RequestBody List<String> selectedPaths, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Selected paths>>>>>>>>>>>" + selectedPaths);
        ArrayList<FileRevisionElement> fileElements = new ArrayList<FileRevisionElement>();
        int i = 0;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        Cloud cloud = cl.getCloud();
        int cloudId = cloud.getCloudId();
        for (String string : selectedPaths) {
            FileRevisionElement file;
            String string2 = this.decodeBase64UTFString(string);
            ++i;
            if (StringUtils.isBlank((String)string2)) {
                logger.debug(PATH + string2);
                throw new BaseException(INVALID_REQUEST);
            }
            String[] params = string2.split("/");
            if (params.length <= 1) {
                logger.debug(BAD_PATH);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String fileName = params[params.length - 1];
            if (StringUtils.isBlank((String)fileName)) {
                logger.debug(NULL_FILE_NAME);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String relativePath = string2.substring(0, string2.length() - (fileName.length() + 1));
            logger.debug(CALLING_DELETE + fileName + RELATIVE_PATH + relativePath);
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            String fileUserName = authorizationTokens.getUser().getUserName();
            User fileUser = authorizationTokens.getUser();
            MiniCloud miniCloud = null;
            if (params.length > 2 && !StringUtils.isEmpty((String)params[1])) {
                List cloudRestrictedElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudName).getMiniClouds();
                for (MiniCloudElement element : cloudRestrictedElementList) {
                    if (!element.getMiniCloudName().equalsIgnoreCase(params[1])) continue;
                    miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, element.getMiniCloudName());
                    fileUserName = "";
                    fileUser = null;
                    break;
                }
            }
            if ((file = this.resourceService.validateResourceFileForRestore(cloudId, fileUserName, cloudName, fileName, relativePath, fileUser, miniCloud)) == null) continue;
            logger.debug("File path : " + file.getFileCompletePath() + " file name : " + file.getFileName());
            fileElements.add(file);
        }
        logger.debug(TOTAL_FILES + i);
        for (FileElement fileElement : fileElements) {
            logger.debug("Going to restore file : " + fileElement.getFileName());
            this.restoreFile(cloudName, fileElement, request, response);
        }
    }

    private void restoreFile(String cloudName, FileElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        String path = fileElement.getFileCompletePath() + "/" + fileElement.getFileName();
        String userName = request.getHeader("userName");
        logger.debug(" @@@@@ calling /files/restore ..." + path);
        try {
            String token;
            if (StringUtils.isBlank((String)path) || StringUtils.isBlank((String)userName)) {
                logger.debug(" @@@@@ PATH is: " + path + " username: " + userName);
                throw new BaseException(INVALID_REQUEST);
            }
            String[] params = path.split("/");
            if (params.length <= 1) {
                logger.debug(" @@@@@BAD PATH ");
                throw new BaseException(INVALID_FILE_NAME);
            }
            String fileName = params[params.length - 1];
            if (StringUtils.isBlank((String)fileName)) {
                logger.debug(" @@@@@ FILE NAME IS NULL");
                throw new BaseException(INVALID_FILE_NAME);
            }
            String relativePath = path.substring(0, path.length() - (fileName.length() + 1));
            logger.debug("@@@@@ Calling restore for fileName: " + fileName + RELATIVE_PATH + relativePath);
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@@@ INVALID LICENSE During restore ");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                logger.debug("@@@@@ INVALID LICENSE performAuthorization restore ");
                return;
            }
            User user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            cloudNameTemp = cl.getCloud().getCloudName();
            String fileUserName = userName;
            User fileUser = user;
            MiniCloud miniCloud = null;
            if (params.length > 2 && !StringUtils.isEmpty((String)params[1])) {
                List cloudRestrictedElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudName).getMiniClouds();
                for (MiniCloudElement element : cloudRestrictedElementList) {
                    if (!element.getMiniCloudName().equalsIgnoreCase(params[1])) continue;
                    miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, element.getMiniCloudName());
                    fileUser = null;
                    fileUserName = "";
                    break;
                }
            }
            logger.debug("@@@@@ BEFORE CALLING restore last resource  validateMiniCloudByName restore ");
            List<SearchIndex> searchIndexs = this.resourceService.restoreLastResources(cloudId, cloudNameTemp, cl.getCloud(), relativePath, fileName, userName, fileUserName, fileUser, miniCloud, fileElement.isFolder());
            if (searchIndexs != null) {
                this.addSearchIndexToTable(cl.getCloud(), searchIndexs);
                String mcName = null;
                if (miniCloud != null) {
                    mcName = miniCloud.getMiniCloudName();
                }
                this.auditHistoryService.saveStatisticToDatabaseForMC(cloudId, cloudNameTemp, "restored", userName, path, "Portal", System.currentTimeMillis(), PCActionTypes.FILE_RESTORE.getActionTypeValue(), mcName);
                logger.debug(STATUS_200);
                response.setStatus(200);
            } else {
                logger.debug(STATUS_NOT_FOUND);
                response.setStatus(404);
            }
        }
        catch (DataAccessException e) {
            logger.error(" DataAccessException .. " + (Object)((Object)e));
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.error(" BaseException .. " + (Object)((Object)e));
            response.setStatus(409);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.error(" EXception .. " + e);
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/restore/revision"}, method={RequestMethod.POST})
    public void restoreResource(@PathVariable(value="cloudName") String cloudName, @RequestBody FileRevisionElement fileRevisionElement, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/restore  ...");
        String userName = request.getHeader("userName");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return;
            }
            String[] params = fileRevisionElement.getFileCompletePath().split("/");
            if (params.length < 1) {
                response.setStatus(400);
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser(), params)) {
                return;
            }
            List<SearchIndex> searchIndexs = this.resourceService.restoreResoruces(cloudId, cloudNameTemp, cl.getCloud(), fileRevisionElement, userName);
            if (searchIndexs != null) {
                this.addSearchIndexToTable(cl.getCloud(), searchIndexs);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "restored", userName, fileRevisionElement.getFileName(), "Portal", System.currentTimeMillis(), PCActionTypes.FILE_RESTORE.getActionTypeValue());
                logger.debug(STATUS_200);
                response.setStatus(200);
            } else {
                logger.debug(STATUS_NOT_FOUND);
                response.setStatus(404);
            }
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_WHILE_RESTORING + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_WHILE_RESTORING + e.getMessage());
            response.setStatus(409);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_RESTORING + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/restore/all"}, method={RequestMethod.POST})
    public void restoreAllResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/restore/all ...");
        String userName = request.getHeader("userName");
        boolean restoreSuccess = true;
        try {
            String token;
            if (StringUtils.isBlank((String)userName)) {
                throw new BaseException("Invalid request user name empty .");
            }
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                logger.error("@@@@@@@@@@@@@@@@@@@@@  failed in validateLicenseAndStorageRestrictions  for restore all files ");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                logger.error("@@@@@@@@@@@@@@@@@@@@@  Calling restore performAuthorization all files ");
                return;
            }
            int limit = 500;
            Long allDeletedRecourcesCount = this.resourceService.getCountOfAlldeletedResourceFiles(cloudId, cloudNameTemp);
            logger.debug(allDeletedRecourcesCount + "@@@@@@@@@@@@@@@@@@@@@  Calling restore allDeletedRecourcesCount for all files " + allDeletedRecourcesCount);
            StatusDetailTO status = this.deleteDelegate.restoreAllResources(userName, restoreSuccess, cl, cloudId, cloudNameTemp, limit, allDeletedRecourcesCount);
            logger.debug(userName + "@@@@@@@@@@@@@@@@@@@@@  Calling restore for all files " + status.getStatus());
            if (status.getStatus() == 1 && allDeletedRecourcesCount != 0L) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "restored", userName, "all files", "Portal", System.currentTimeMillis(), PCActionTypes.FILE_RESTORE.getActionTypeValue());
                logger.debug(STATUS_200);
                response.setStatus(200);
            } else if (status.getStatus() == 2) {
                response.setStatus(425);
                response.setHeader("user", status.getBasicInfo());
            } else {
                logger.debug(STATUS_NOT_FOUND);
                response.setStatus(404);
            }
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            logger.error(" BaseException  " + (Object)((Object)e));
            response.setStatus(409);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.error(" Exception  " + e);
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/thrash"}, method={RequestMethod.DELETE})
    public void deleteThrashResources(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug(CALLING_THRASH_API);
        String cloudNameTemp = cloudName;
        String userName = request.getHeader("userName");
        logger.debug(CALLING_THRASH_API);
        try {
            StatusDetailTO status;
            SyncPolicy syncPolicy;
            String token;
            logger.debug("username:" + userName);
            if (StringUtils.isBlank((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            logger.debug("Calling thrash for all files ");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            Cloud cloud = cl.getCloud();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.managementService.getSyncPolicyByPolicyName(cloudId, authorizationTokens.getUser().getSyncPolicyName())) != null && syncPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if ((status = this.deleteDelegate.deleteThrashResources(userName, cl, cloudId, isSearchEnabled)).getStatus() == 1) {
                response.setStatus(200);
            } else {
                response.setStatus(425);
                response.setHeader("user", status.getBasicInfo());
            }
            logger.debug(STATUS_200);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/file/delete/permanent"}, method={RequestMethod.DELETE})
    public void deleteThrashResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String selectedPaths = request.getHeader(SELECTED_PATHS);
        selectedPaths = this.decodeBase64UTFString(selectedPaths);
        ArrayList<FileRevisionElement> fileElements = new ArrayList<FileRevisionElement>();
        ArrayList<String> pathsList = new ArrayList<String>(Arrays.asList(selectedPaths.split("\\|")));
        int i = 0;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        Cloud cloud = cl.getCloud();
        int cloudId = cloud.getCloudId();
        for (String string : pathsList) {
            FileRevisionElement file;
            ++i;
            if (StringUtils.isBlank((String)string)) {
                logger.debug(PATH + string);
                throw new BaseException(INVALID_REQUEST);
            }
            String[] params = string.split("/");
            if (params.length <= 1) {
                logger.debug(BAD_PATH);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String fileName = params[params.length - 1];
            if (StringUtils.isBlank((String)fileName)) {
                logger.debug(NULL_FILE_NAME);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String relativePath = string.substring(0, string.length() - (fileName.length() + 1));
            logger.debug(CALLING_DELETE + fileName + RELATIVE_PATH + relativePath);
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = null;
            MiniCloud miniCloud = null;
            String userNameVal = authorizationTokens.getUser().getUserName();
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, relativePath);
            if (isPathInsideMC) {
                String mcName = ResourceController.getMCName(relativePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
                userNameVal = "";
            } else {
                user = this.managementService.getUserDetails(cloudId, cloudName, authorizationTokens.getUser().getUserName());
            }
            if ((file = this.resourceService.validateResourceFileForDelete(cloudId, userNameVal, cloudName, fileName, relativePath, user, miniCloud)) == null) continue;
            fileElements.add(file);
        }
        logger.debug(TOTAL_FILES + fileElements.size());
        for (FileElement fileElement : fileElements) {
            logger.debug(INSIDE_SINGLE_FILE_COPY + fileElement.getFileName());
            this.deleteFileFromTrash(cloudName, fileElement, request, response);
        }
    }

    private void deleteFileFromTrash(String cloudName, FileElement fileElement2, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        String path = fileElement2.getFileCompletePath() + "/" + fileElement2.getFileName();
        String userName = request.getHeader("userName");
        logger.debug(CALLING_THRASH_API);
        try {
            SyncPolicy syncPolicy;
            String token;
            logger.debug("username:" + userName);
            if (StringUtils.isBlank((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            logger.debug("Calling thrash for all files ");
            String[] params = path.split("/");
            if (params.length <= 1) {
                logger.debug(BAD_PATH);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String fileName = params[params.length - 1];
            if (StringUtils.isBlank((String)fileName)) {
                logger.debug(NULL_FILE_NAME);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String relativePath = path.substring(0, path.length() - (fileName.length() + 1));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            User user = authorizationTokens.getUser();
            MiniCloud miniCloud = null;
            String userNameVal = authorizationTokens.getUser().getUserName();
            User userVal = null;
            String mcName = "";
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, relativePath);
            if (isPathInsideMC) {
                mcName = ResourceController.getMCName(relativePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
                userNameVal = "";
            } else {
                userVal = user;
            }
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, user, params)) {
                return;
            }
            Cloud cloud = cl.getCloud();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.managementService.getSyncPolicyByPolicyName(cloudId, authorizationTokens.getUser().getSyncPolicyName())) != null && syncPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            FileElement fileElement = new FileElement();
            fileElement.setFileName(fileName);
            fileElement.setFileCompletePath(relativePath);
            fileElement.setFolder(fileElement2.isFolder());
            logger.debug(fileName + "#$@#$@#$@#$@# " + relativePath);
            this.deleteTimerService.deleteFileEntryFromTrashDirectly(cloudId, userNameVal, cloudNameTemp, cl.getCloud(), isSearchEnabled, fileElement, userVal, miniCloud);
            if (isPathInsideMC) {
                this.resourceService.updateModifiedTimeStamp(cloudId, null, cloudName, relativePath, System.currentTimeMillis(), null, miniCloud);
            } else {
                this.resourceService.updateModifiedTimeStamp(cloudId, userName, cloudName, relativePath, System.currentTimeMillis(), user, miniCloud);
            }
            logger.debug(STATUS_200);
            String deviceName = "Portal";
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "deleted permanently", userName, relativePath + "/" + fileName, deviceName, System.currentTimeMillis(), PCActionTypes.FILE_DELETE_PERMANENT.getActionTypeValue(), isPathInsideMC, mcName);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while deleting file from trash " + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while deleting file from trash " + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/revisions"}, method={RequestMethod.GET})
    public ModelAndView getVersions(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/version ...");
        String devicePath = request.getHeader("filePath");
        String fileName = request.getHeader("fileName");
        devicePath = this.decodeBase64UTFString(devicePath);
        fileName = this.decodeBase64UTFString(fileName);
        User user = new User();
        MiniCloud miniCloud = null;
        FileRevisionsListElement fileRevisionsListElement = new FileRevisionsListElement();
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            User userObj = authorizationTokens.getUser();
            String[] params = devicePath.split("/");
            if (params.length < 1) {
                response.setStatus(400);
                return null;
            }
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, user.getUserName(), params)) {
                return null;
            }
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, devicePath);
            if (isPathInsideMC) {
                String mcName = ResourceController.getMCName(devicePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            }
            List<FileRevisionElement> elements = this.resourceService.getRevisions(cloudId, userObj.getUserName(), cloudNameTemp, fileName, devicePath, cl.getCloud().getVersioningEnabled(), isPathInsideMC, user, miniCloud);
            fileRevisionsListElement.setFileElementList(elements);
            modelAndView.addObject((Object)fileRevisionsListElement);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting versions " + e.getMessage());
            response.setStatus(500);
            return null;
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting versions " + e.getMessage());
            response.setStatus(400);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/files/delete"}, method={RequestMethod.GET})
    public ModelAndView getdeletedResources(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String token;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        FileListElement fileListElement = new FileListElement();
        logger.debug("calling get /files/delete ...");
        String device = request.getHeader(DEVICE_NAME);
        int pagNum = 0;
        int rowsPerPage = 0;
        try {
            String pagNumber = request.getHeader("pageNumber");
            pagNum = Integer.parseInt(pagNumber);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        try {
            String rows = request.getHeader("rows");
            rowsPerPage = Integer.parseInt(rows);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
            return null;
        }
        try {
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            User userObj = authorizationTokens.getUser();
            String user = userObj.getUserName();
            List<FileElement> fileList = this.resourceService.getDeletedResourceFiles(cloudId, cloudNameTemp, pagNum, rowsPerPage, user, device, fileListElement, userObj);
            fileListElement.setFileElementList(fileList);
            modelAndView.addObject((Object)fileListElement);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting deleted resources " + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting deleted resources " + e.getMessage());
            response.setStatus(400);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/files/rename"}, method={RequestMethod.POST})
    public void renameResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/rename ...");
        String path = request.getHeader("path");
        path = this.decodeBase64UTFString(path);
        String newFileName = request.getHeader("newFileName");
        newFileName = this.decodeBase64UTFString(newFileName);
        if (StringUtils.isBlank((String)path) || StringUtils.isBlank((String)newFileName)) {
            logger.debug("PATH IS NULL");
            throw new BaseException("Invalid file path.");
        }
        String[] params = path.split("/");
        if (params.length <= 1) {
            logger.debug(BAD_PATH);
            throw new BaseException(INVALID_FILE_NAME);
        }
        String fileName = params[params.length - 1];
        if (StringUtils.isBlank((String)fileName)) {
            logger.debug(NULL_FILE_NAME);
            throw new BaseException(INVALID_FILE_NAME);
        }
        String relativePath = path.substring(0, path.length() - (fileName.length() + 1));
        logger.debug("Calling delete for fileName: " + fileName + RELATIVE_PATH + relativePath + " : " + newFileName);
        try {
            BackUpImage existingBackUpImage;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser(), params)) {
                return;
            }
            String userName = authorizationTokens.getUser().getUserName();
            User user = null;
            MiniCloud miniCloud = null;
            String userNameVal = userName;
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, relativePath);
            if (isPathInsideMC) {
                String mcName = ResourceController.getMCName(relativePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
                userNameVal = "";
            } else {
                user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            }
            BackUpImage backUpImage = this.resourceService.getExistingSyncBackUpImage(cloudId, userNameVal, cloudNameTemp, fileName, relativePath, user, miniCloud);
            if (backUpImage == null) {
                logger.debug(fileName + " RECORD does not exist ... " + path);
                response.setStatus(403);
                return;
            }
            boolean areFilesInBlukrypt = false;
            if (backUpImage.isFolder() || backUpImage.isFolder() && isPathInsideMC) {
                String pathVal = relativePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
                areFilesInBlukrypt = this.resourceService.areSyncFilesInBlukrypt(cloudId, cloudName, userNameVal, backUpImage.getDevicePath(), backUpImage.getFileName(), user, miniCloud);
            }
            if (areFilesInBlukrypt) {
                logger.error(FILES_NOT_MOVED_TO_BLUKRYPT);
                response.setStatus(445);
                return;
            }
            String mobileHeader = request.getHeader(IS_MOBILE);
            logger.debug(isPathInsideMC + " Mobile header flag  ... " + mobileHeader);
            boolean isMobile = Boolean.parseBoolean(mobileHeader);
            String deviceName = "Portal";
            if (isMobile) {
                deviceName = request.getHeader(DEVICE_NAME);
            }
            if ((existingBackUpImage = this.resourceService.getExistingSyncBackUpImageForFolder(cloudId, userName, cloudNameTemp, newFileName, relativePath, user, miniCloud)) != null) {
                logger.debug(newFileName + RECORD_EXISTS_ERROR + relativePath);
                response.setStatus(411);
                return;
            }
            ShareAndSearchDLTO shareAndSearchDLTO = this.resourceService.renameResourceFile(cloudId, cloudNameTemp, cl.getCloud(), relativePath, fileName, newFileName, userName, deviceName, isPathInsideMC, backUpImage.isFolder());
            if (shareAndSearchDLTO != null) {
                this.addSearchIndexToTable(cl.getCloud(), shareAndSearchDLTO.getSearchIndexs());
                this.resourceService.unShareFileList(cloudNameTemp, shareAndSearchDLTO.getSharedFileNames(), shareAndSearchDLTO.getSharedDevicePaths());
                response.setStatus(200);
            } else {
                response.setStatus(500);
            }
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        catch (FileOperationException e) {
            logger.trace("FileOperationException" + (Object)((Object)e));
            logger.error("FileOperationException" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
    }

    public void moveResource() {
    }

    @RequestMapping(value={"cloud/{cloudName}/files/copy"}, method={RequestMethod.POST})
    public void copyResource(@PathVariable(value="cloudName") String cloudName, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(INSIDE_SINGLE_FILE_COPY);
        String mobileHeader = request.getHeader(IS_MOBILE);
        logger.debug(MOBILE_HEADER_LOG + mobileHeader);
        boolean isMobile = Boolean.parseBoolean(mobileHeader);
        this.copyResourceFile(cloudName, fileElement, request, response, isMobile);
    }

    @RequestMapping(value={"cloud/{cloudName}/selected/files/copy"}, method={RequestMethod.POST})
    public void copySelectedResource(@PathVariable(value="cloudName") String cloudName, @RequestBody List<String> selectedPaths, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" inside multiple  file copy .. ");
        ArrayList<FileRevisionElement> fileElements = new ArrayList<FileRevisionElement>();
        int i = 0;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        Cloud cloud = cl.getCloud();
        int cloudId = cloud.getCloudId();
        boolean isFilesInBlukrypt = false;
        for (String path : selectedPaths) {
            path = this.decodeBase64UTFString(path);
            logger.debug("Decoded path : " + path);
            if (StringUtils.isBlank((String)path)) {
                logger.debug(PATH + path);
                throw new BaseException(INVALID_REQUEST);
            }
            String[] params = path.split("/");
            if (params.length <= 1) {
                logger.debug(BAD_PATH);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String string = params[params.length - 1];
            if (StringUtils.isBlank((String)string)) {
                logger.debug(NULL_FILE_NAME);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            String relativePath = path.substring(0, path.length() - (string.length() + 1));
            logger.debug("@@@@@@  Calling selected/files/copy: " + string + RELATIVE_PATH + relativePath);
            String userName = authorizationTokens.getUser().getUserName();
            User user = null;
            MiniCloud miniCloud = null;
            logger.debug("@@@@@@  ispathinsidemc........" + path);
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, path);
            if (isPathInsideMC) {
                userName = "";
                String mcName = ResourceController.getMCName(path);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            } else {
                user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            }
            logger.debug("@@@@@@ after ispathinsidemc........" + userName);
            FileRevisionElement file = this.resourceService.validateResourceFileForCopy(cloudId, userName, cloudName, string, relativePath, user, miniCloud);
            String pathVal = relativePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + string;
            logger.debug("@@@@@@  Calling validateResourceFileForCopy  " + file.isFolder() + " with path and file name : " + pathVal);
            if (file.isFolder() || file.isFolder() && isPathInsideMC) {
                isFilesInBlukrypt = this.resourceService.areSyncFilesInBlukrypt(cloudId, cloudName, userName, file.getFileCompletePath(), file.getFileName(), user, miniCloud);
            }
            if (isFilesInBlukrypt) break;
            fileElements.add(file);
            ++i;
        }
        if (isFilesInBlukrypt) {
            logger.error(FILES_NOT_MOVED_TO_BLUKRYPT);
            response.setStatus(445);
            return;
        }
        logger.debug(TOTAL_FILES + i);
        String mobileHeader = request.getHeader(IS_MOBILE);
        logger.debug(MOBILE_HEADER_LOG + mobileHeader);
        boolean isMobile = Boolean.parseBoolean(mobileHeader);
        for (FileElement fileElement : fileElements) {
            if (fileElement == null) continue;
            logger.debug(INSIDE_SINGLE_FILE_COPY + fileElement.getFileName());
            this.copyResourceFile(cloudName, fileElement, request, response, isMobile);
        }
    }

    private void copyResourceFile(String cloudName, FileElement fileElement, HttpServletRequest request, HttpServletResponse response, boolean isMobile) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling copyResourceFile ...");
        String destinationPath = request.getHeader("destinationPath");
        destinationPath = this.decodeBase64UTFString(destinationPath);
        try {
            String sourcePath = fileElement.getFileCompletePath();
            String sourceFileName = fileElement.getFileName();
            if (sourcePath.length() > 0 && sourceFileName.length() > 0) {
                List<SearchIndex> searchIndexs;
                SyncPolicy syncPolicy;
                String token;
                CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
                if (!this.checkLicense(cl, response)) {
                    return;
                }
                int cloudId = cl.getCloud().getCloudId();
                if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                    return;
                }
                cloudNameTemp = cl.getCloud().getCloudName();
                AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
                String[] sourceParams = sourcePath.split("/");
                String[] destinationParams = destinationPath.split("/");
                if (sourceParams.length < 1 || destinationParams.length < 1) {
                    response.setStatus(400);
                    return;
                }
                if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser(), sourceParams)) {
                    return;
                }
                if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser(), destinationParams)) {
                    return;
                }
                if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
                    return;
                }
                User user = authorizationTokens.getUser();
                User sourceUser = null;
                User destinationUser = null;
                logger.debug(sourcePath + " ...... before checking  ........... " + sourceFileName);
                String userName = user.getUserName();
                MiniCloud sourceMiniCloud = null;
                MiniCloud destinationMiniCloud = null;
                boolean isSourcePathInsideMC = this.isPathInsideMC(cloudId, sourcePath);
                String mcName = "";
                if (isSourcePathInsideMC) {
                    userName = "";
                    mcName = ResourceController.getMCName(sourcePath);
                    sourceMiniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
                } else {
                    sourceUser = user;
                }
                boolean isDestPathInsideMC = this.isPathInsideMC(cloudId, destinationPath);
                logger.debug("...destpath...." + isDestPathInsideMC);
                if (isDestPathInsideMC) {
                    mcName = ResourceController.getMCName(destinationPath);
                    if (!StringUtils.isEmpty((String)mcName) && (destinationMiniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName)) != null && !destinationMiniCloud.isAllowUpload()) {
                        response.setStatus(405);
                        logger.error(mcName + "..minicloud upload limit reached...");
                        return;
                    }
                } else {
                    destinationUser = user;
                }
                logger.debug(isSourcePathInsideMC + " ...... Path and user  ........... " + userName);
                BackUpImage image = this.resourceService.getExistingSyncBackUpImage(cloudId, userName, cloudNameTemp, fileElement.getFileName(), fileElement.getFileCompletePath(), sourceUser, sourceMiniCloud);
                if (image == null) {
                    logger.debug(fileElement.getFileName() + " RECORD does not copy exist ... " + destinationPath);
                    response.setStatus(403);
                    return;
                }
                image = this.checkValidSyncFileOrNot(destinationPath, cloudId, cloudNameTemp, userName, destinationUser, destinationMiniCloud);
                if (image == null) {
                    logger.debug(sourceFileName + " RECORD destination does not exist ... " + destinationPath);
                    response.setStatus(403);
                    return;
                }
                BackUpImage existingSyncBackUpImage = destinationMiniCloud != null ? this.resourceService.getExistingSyncBackUpImage(cloudId, userName, cloudName, fileElement.getFileName(), destinationPath, destinationUser, destinationMiniCloud) : this.resourceService.getExistingSyncBackUpImage(cloudId, user.getUserName(), cloudName, fileElement.getFileName(), destinationPath, destinationUser, destinationMiniCloud);
                if (existingSyncBackUpImage != null) {
                    logger.debug(fileElement.getFileName() + RECORD_EXISTS_ERROR + destinationPath);
                    response.setStatus(411);
                    return;
                }
                boolean isSearchEnabled = false;
                Cloud cloud = cl.getCloud();
                if (cloud != null && cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.managementService.getSyncPolicyByPolicyName(cloudId, authorizationTokens.getUser().getSyncPolicyName())) != null && syncPolicy.isContentIndexEnabled()) {
                    isSearchEnabled = true;
                }
                if ((searchIndexs = this.resourceService.copyResourceFile(cloudId, cloudNameTemp, cl.getCloud(), fileElement, destinationPath, authorizationTokens.getUser().getUserName(), isSourcePathInsideMC, sourceUser, destinationUser, sourceMiniCloud, destinationMiniCloud, isSearchEnabled)) != null) {
                    this.addSearchIndexToTable(cl.getCloud(), searchIndexs);
                    userName = authorizationTokens.getUser().getUserName();
                    String action = "copied";
                    String additionalInfo = " from " + sourcePath + " to " + destinationPath;
                    String ip = request.getHeader("ip");
                    String osType = request.getHeader("osType");
                    String browser = request.getHeader("browser");
                    logger.debug(" ip ostype, browser .................. " + ip + ".. " + osType + "...." + browser);
                    if (!(StringUtils.isEmpty((String)ip) && StringUtils.isEmpty((String)osType) && StringUtils.isEmpty((String)browser))) {
                        additionalInfo = additionalInfo + " from the ip address " + ip + " using the domain Name " + browser + " and the OS Type was " + osType;
                    }
                    String deviceName = "Portal";
                    if (isMobile) {
                        deviceName = request.getHeader(DEVICE_NAME);
                    }
                    if (!StringUtils.isEmpty((String)mcName)) {
                        this.auditHistoryService.saveStatisticToDatabaseForMC(cloudId, cloudNameTemp, action, userName, sourceFileName, deviceName, System.currentTimeMillis(), sourcePath, additionalInfo, PCActionTypes.FILE_COPY.getActionTypeValue(), mcName);
                    } else {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, action, userName, sourceFileName, deviceName, System.currentTimeMillis(), sourcePath, additionalInfo, PCActionTypes.FILE_COPY.getActionTypeValue());
                    }
                    response.setStatus(200);
                } else {
                    response.setStatus(500);
                }
            }
        }
        catch (FileOperationException | DataAccessException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_COPY + ((Throwable)e).getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_WHILE_COPY + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/cut"}, method={RequestMethod.POST})
    public void cutPasteResource(@PathVariable(value="cloudName") String cloudName, @RequestBody FileElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        String mobileHeader = request.getHeader(IS_MOBILE);
        logger.debug(MOBILE_HEADER_LOG + mobileHeader);
        boolean isMobile = Boolean.parseBoolean(mobileHeader);
        this.cutPasteResourceFile(cloudName, fileElement, request, response, false, isMobile);
    }

    @RequestMapping(value={"cloud/{cloudName}/selected/files/cut"}, method={RequestMethod.POST})
    public void cutPasteSelectedResource(@PathVariable(value="cloudName") String cloudName, @RequestBody List<String> selectedPaths, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" inside multiple file cut .. ");
        ArrayList<FileRevisionElement> fileElements = new ArrayList<FileRevisionElement>();
        int i = 0;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        Cloud cloud = cl.getCloud();
        int cloudId = cloud.getCloudId();
        boolean isPathInsideMC = false;
        boolean isFilesInBlukrypt = false;
        for (String path : selectedPaths) {
            path = this.decodeBase64UTFString(path);
            logger.debug("Decoded path : " + path);
            ++i;
            if (StringUtils.isBlank((String)path)) {
                logger.debug(PATH + path);
                throw new BaseException(INVALID_REQUEST);
            }
            String[] params = path.split("/");
            if (params.length <= 1) {
                logger.debug(BAD_PATH);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String string = params[params.length - 1];
            if (StringUtils.isBlank((String)string)) {
                logger.debug(NULL_FILE_NAME);
                throw new BaseException(INVALID_FILE_NAME);
            }
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            String relativePath = path.substring(0, path.length() - (string.length() + 1));
            logger.debug(CALLING_DELETE + string + RELATIVE_PATH + relativePath);
            isPathInsideMC = this.isPathInsideMC(cloudId, relativePath);
            String userName = authorizationTokens.getUser().getUserName();
            MiniCloud miniCloud = null;
            User user = null;
            if (isPathInsideMC) {
                userName = "";
                String mcName = ResourceController.getMCName(relativePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            } else {
                user = authorizationTokens.getUser();
            }
            FileRevisionElement file = this.resourceService.validateResourceFile(cloudId, userName, cloudName, string, relativePath, user, miniCloud);
            if (file.isFolder() || file.isFolder() && isPathInsideMC) {
                String pathVal = relativePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + string;
                isFilesInBlukrypt = this.resourceService.areSyncFilesInBlukrypt(cloudId, cloudName, userName, file.getFileCompletePath(), file.getFileName(), user, miniCloud);
            }
            if (isFilesInBlukrypt) break;
            fileElements.add(file);
        }
        logger.debug(TOTAL_FILES + i);
        if (isFilesInBlukrypt) {
            logger.error(FILES_NOT_MOVED_TO_BLUKRYPT);
            response.setStatus(445);
            return;
        }
        String mobileHeader = request.getHeader(IS_MOBILE);
        logger.debug(MOBILE_HEADER_LOG + mobileHeader);
        boolean isMobile = Boolean.parseBoolean(mobileHeader);
        for (FileElement fileElement : fileElements) {
            logger.debug(" cutpaste  .... " + i);
            this.cutPasteResourceFile(cloudName, fileElement, request, response, isPathInsideMC, isMobile);
        }
    }

    private void cutPasteResourceFile(String cloudName, FileElement fileElement, HttpServletRequest request, HttpServletResponse response, boolean isPathInsideMC, boolean isMobile) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/cut ...");
        ShareAndSearchDLTO shareAndSearchDLTO = null;
        String destinationPath = request.getHeader("destinationPath");
        destinationPath = this.decodeBase64UTFString(destinationPath);
        try {
            String sourcePath = fileElement.getFileCompletePath();
            String sourceFileName = fileElement.getFileName();
            logger.debug(sourcePath + " filepath and filename ........ " + sourceFileName);
            if (sourcePath.length() > 0 && sourceFileName.length() > 0) {
                SyncPolicy syncPolicy;
                String userName;
                String token;
                CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
                if (!this.checkLicense(cl, response)) {
                    return;
                }
                int cloudId = cl.getCloud().getCloudId();
                if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                    return;
                }
                cloudNameTemp = cl.getCloud().getCloudName();
                AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
                String[] sourceParams = fileElement.getFileCompletePath().split("/");
                String[] destinationParams = destinationPath.split("/");
                if (sourceParams.length < 1 || destinationParams.length < 1) {
                    response.setStatus(400);
                    return;
                }
                if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser(), sourceParams)) {
                    return;
                }
                if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, authorizationTokens.getUser(), destinationParams)) {
                    return;
                }
                User sourceUser = null;
                User destinationUser = null;
                MiniCloud sourceMiniCloud = null;
                MiniCloud destinationMiniCloud = null;
                String userNameVal = userName = authorizationTokens.getUser().getUserName();
                if (isPathInsideMC) {
                    userNameVal = "";
                    String mcName = ResourceController.getMCName(sourcePath);
                    sourceMiniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
                } else {
                    sourceUser = authorizationTokens.getUser();
                }
                boolean isDestPathInsideMC = this.isPathInsideMC(cloudId, destinationPath);
                logger.debug("...destpath...." + isDestPathInsideMC);
                String mcName = "";
                if (isPathInsideMC) {
                    mcName = ResourceController.getMCName(fileElement.getFileCompletePath());
                }
                if (isDestPathInsideMC) {
                    mcName = ResourceController.getMCName(destinationPath);
                    if (!StringUtils.isEmpty((String)mcName) && (destinationMiniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName)) != null && !destinationMiniCloud.isAllowUpload()) {
                        response.setStatus(405);
                        logger.error(mcName + "..minicloud upload limit reached...");
                        return;
                    }
                } else {
                    destinationUser = authorizationTokens.getUser();
                }
                BackUpImage backUpImage = this.checkValidSyncFileOrNot(destinationPath, cloudId, cloudNameTemp, userName, destinationUser, destinationMiniCloud);
                boolean isNotValidPath = this.isDestinationAndSourcePathSame(destinationPath, fileElement);
                if (backUpImage == null || isNotValidPath) {
                    logger.debug(fileElement.getFileName() + " RECORD does not cutPasteResource exist ... " + destinationPath + " .... image..." + backUpImage);
                    response.setStatus(403);
                    return;
                }
                BackUpImage existingSyncBackUpImage = destinationMiniCloud != null ? this.resourceService.getExistingSyncBackUpImage(cloudId, userNameVal, cloudNameTemp, fileElement.getFileName(), destinationPath, destinationUser, destinationMiniCloud) : this.resourceService.getExistingSyncBackUpImage(cloudId, userName, cloudNameTemp, fileElement.getFileName(), destinationPath, destinationUser, destinationMiniCloud);
                if (existingSyncBackUpImage != null) {
                    logger.debug(fileElement.getFileName() + RECORD_EXISTS_ERROR + destinationPath);
                    response.setStatus(411);
                    return;
                }
                boolean isSearchEnabled = false;
                Cloud cloud = cl.getCloud();
                if (cloud != null && cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.managementService.getSyncPolicyByPolicyName(cloudId, authorizationTokens.getUser().getSyncPolicyName())) != null && syncPolicy.isContentIndexEnabled()) {
                    isSearchEnabled = true;
                }
                if ((shareAndSearchDLTO = this.resourceService.moveResourceFile(cloudId, cloudNameTemp, cl.getCloud(), fileElement, destinationPath, userName, isPathInsideMC, sourceUser, destinationUser, sourceMiniCloud, destinationMiniCloud, isSearchEnabled)) != null) {
                    this.resourceService.unShareFileList(cloudNameTemp, shareAndSearchDLTO.getSharedFileNames(), shareAndSearchDLTO.getSharedDevicePaths());
                    String action = "cut/paste";
                    String additionalInfo = " from " + sourcePath + " to " + destinationPath;
                    String ip = request.getHeader("ip");
                    String osType = request.getHeader("osType");
                    String browser = request.getHeader("browser");
                    logger.debug(" ip ostype, browser .................. " + ip + ".. " + osType + "...." + browser);
                    if (!(StringUtils.isEmpty((String)ip) && StringUtils.isEmpty((String)osType) && StringUtils.isEmpty((String)browser))) {
                        additionalInfo = additionalInfo + " from the ip address " + ip + " using the domain Name " + browser + " and the OS Type was " + osType;
                    }
                    String deviceName = "Portal";
                    if (isMobile) {
                        deviceName = request.getHeader(DEVICE_NAME);
                    }
                    if (!StringUtils.isEmpty((String)mcName)) {
                        this.auditHistoryService.saveStatisticToDatabaseForMC(cloudId, cloudNameTemp, action, userName, sourceFileName, deviceName, System.currentTimeMillis(), sourcePath, additionalInfo, PCActionTypes.FILE_CUT_PASTE.getActionTypeValue(), mcName);
                    } else {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, action, userName, fileElement.getFileName(), deviceName, System.currentTimeMillis(), destinationPath, additionalInfo, PCActionTypes.FILE_CUT_PASTE.getActionTypeValue());
                    }
                    response.setStatus(200);
                } else {
                    response.setStatus(500);
                }
            }
        }
        catch (FileOperationException | DataAccessException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_CUT_PASTE + ((Throwable)e).getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_WHILE_CUT_PASTE + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
    }

    private boolean isDestinationAndSourcePathSame(String destinationPath, FileElement fileElement) {
        if (!StringUtils.isEmpty((String)destinationPath)) {
            String sourcePath = fileElement.getFileCompletePath() + "/" + fileElement.getFileName();
            logger.debug(sourcePath + "  CUT PASTE SOURCE AND DESTINATION " + destinationPath);
            if (destinationPath.equals(sourcePath)) {
                return true;
            }
        }
        return false;
    }

    @RequestMapping(value={"cloud/{cloudName}/files/root"}, method={RequestMethod.GET})
    public ModelAndView getRootFileDirectoryDetails(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/root ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            String token = request.getHeader("token");
            logger.debug("calling /files/root  token ..." + token);
            if (!this.performAuthorization(cloud.getCloudId(), cloud.getCloudName(), token, response)) {
                return null;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            String params = request.getParameter("cloudParams");
            if (params == null || params == "") {
                params = "home";
            }
            String[] getParams = params.split(",");
            CloudBasicElement cloudInfo = this.directoryService.getCloudParentDirectoryDetails(cloud.getCloudId(), cloudNameTemp, cloud, getParams);
            List list = cloud.getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                if (!"Share within Organization".equalsIgnoreCase(customisableDetails.getName())) continue;
                cloudInfo.getLiscenseElement().setShareWithinOrgEnabled(true);
            }
            logger.error("cloudInfo ............ " + cloudInfo.getSpaceUsed());
            modelAndView.addObject((Object)cloudInfo);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting root file directory details " + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while getting root file directory details " + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/files/operation/validate"}, method={RequestMethod.GET})
    public void validateFilesRequest(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String cloudNameTemp = cloudName;
        modelAndView.setViewName("xmlview");
        logger.debug("/files/operation/validate ...");
        try {
            boolean isfolder;
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            Cloud cloud = cl.getCloud();
            cloudNameTemp = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloud.getCloudId(), cloudNameTemp, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloud.getCloudId(), cloudNameTemp, token);
            String path = request.getHeader("path");
            String type = request.getHeader("fileType");
            if (StringUtils.isBlank((String)path) || StringUtils.isBlank((String)type)) {
                response.setStatus(400);
                return;
            }
            if ("folder".equalsIgnoreCase(type)) {
                isfolder = true;
            } else if ("file".equalsIgnoreCase(type)) {
                isfolder = false;
            } else {
                response.setStatus(400);
                return;
            }
            String sizeLimit = request.getHeader("sizeLimit");
            String filesLimit = request.getHeader("filesLimit");
            if (StringUtils.isEmpty((String)filesLimit)) {
                filesLimit = "0";
            }
            int sizeAllowed = -1;
            int filesAllowed = -1;
            try {
                sizeAllowed = Integer.parseInt(sizeLimit);
            }
            catch (NumberFormatException e) {
                logger.trace(NUMBER_FORMAT_EXCEPTION + e);
                logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
            try {
                filesAllowed = Integer.parseInt(filesLimit);
            }
            catch (NumberFormatException e) {
                logger.trace(NUMBER_FORMAT_EXCEPTION + e);
                logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
            boolean allowed = this.resourceService.getvalidateFilesRequests(cloud.getCloudId(), authorizationTokens.getUser().getUserName(), cloudNameTemp, sizeAllowed, filesAllowed, path, isfolder);
            if (allowed) {
                response.setStatus(200);
            } else {
                response.setStatus(406);
            }
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating file request " + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating file request " + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/child/mobile"}, method={RequestMethod.GET})
    public ModelAndView getChildrenForFolderForMobile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudNameTemp = cloudName;
        logger.trace("calling /files/child ...");
        User user = new User();
        String folderPath = request.getHeader("path");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
            List cloudRestrictedElementList = null;
            List cloudUserElementList = null;
            String[] params = folderPath.split("/");
            if (params.length < 1) {
                response.setStatus(400);
                return null;
            }
            if (!this.validateMiniCloudByName(response, cloudId, cloudNameTemp, user.getUserName(), params)) {
                return null;
            }
            if (folderPath.equalsIgnoreCase("ParaBlu")) {
                cloudRestrictedElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp).getMiniClouds();
                cloudUserElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, authorizationTokens.getUser().getUserId()).getMiniClouds();
                cloudRestrictedElementList.removeAll(cloudUserElementList);
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(" SKIP VALUE .................. " + skipValue);
            List<MiniCloudFileElement> fileList = this.resourceService.getChildren(cloudId, cloudNameTemp, folderPath, skipValue, cloudRestrictedElementList, cloudUserElementList, authorizationTokens.getUser().getUserName(), authorizationTokens.getUser().getUserId(), false);
            MiniCloudFileListJsonElement miniCloudFileListElement = this.createMiniCloudElementList(fileList);
            modelAndView.addObject((Object)miniCloudFileListElement);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting children for folder for mobile " + e.getMessage());
            response.setStatus(500);
            return null;
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting children for folder for mobile " + e.getMessage());
            response.setStatus(400);
            return null;
        }
        return modelAndView;
    }

    private MiniCloudFileListJsonElement createMiniCloudElementList(List<MiniCloudFileElement> fileList) {
        ArrayList<MiniCloudJsonElement> miniCloudElements = new ArrayList<MiniCloudJsonElement>();
        ArrayList<FileJsonElement> fileElements = new ArrayList<FileJsonElement>();
        ArrayList<FolderInfoJsonElement> folderElements = new ArrayList<FolderInfoJsonElement>();
        int miniCloudSize = 0;
        int fileSize = 0;
        int folderSize = 0;
        for (MiniCloudFileElement miniCloudFileElement : fileList) {
            if (miniCloudFileElement.isMinicloud()) {
                MiniCloudJsonElement cloudElement = new MiniCloudJsonElement();
                cloudElement.setId("MC-" + ++miniCloudSize);
                cloudElement.setFileName(miniCloudFileElement.getFileName());
                miniCloudElements.add(cloudElement);
                continue;
            }
            if (!miniCloudFileElement.isFolder() && !miniCloudFileElement.isMinicloud()) {
                FileJsonElement fileElement = new FileJsonElement();
                fileElement.setId("File-" + ++fileSize);
                fileElement.setFileName(miniCloudFileElement.getFileName());
                fileElement.setUserName(miniCloudFileElement.getFileUserOwner());
                Date date = new Date(miniCloudFileElement.getLastModifiedTimestamp());
                SimpleDateFormat date1 = new SimpleDateFormat("dd-MMM-yyyy HH:mm a");
                String lastModifiedDate = date1.format(date);
                fileElement.setLastModifiedTimestamp(lastModifiedDate);
                fileElements.add(fileElement);
            }
            if (!miniCloudFileElement.isFolder()) continue;
            FolderInfoJsonElement folderInfoElement = new FolderInfoJsonElement();
            folderInfoElement.setId("Folder-" + ++folderSize);
            folderInfoElement.setFileName(miniCloudFileElement.getFileName());
            folderElements.add(folderInfoElement);
        }
        MiniCloudFileListJsonElement miniCloudFileListJsonElement = new MiniCloudFileListJsonElement();
        Collections.sort(fileElements, new Comparator<FileJsonElement>(){

            @Override
            public int compare(FileJsonElement m1, FileJsonElement m2) {
                return new CompareToBuilder().append((Object)m1.getFileName().toLowerCase(), (Object)m2.getFileName().toLowerCase()).toComparison();
            }
        });
        miniCloudFileListJsonElement.setFiles(fileElements);
        Collections.sort(folderElements, new Comparator<FolderInfoJsonElement>(){

            @Override
            public int compare(FolderInfoJsonElement m1, FolderInfoJsonElement m2) {
                return new CompareToBuilder().append((Object)m1.getFileName().toLowerCase(), (Object)m2.getFileName().toLowerCase()).toComparison();
            }
        });
        miniCloudFileListJsonElement.setFolders(folderElements);
        Collections.sort(miniCloudElements, new Comparator<MiniCloudJsonElement>(){

            @Override
            public int compare(MiniCloudJsonElement m1, MiniCloudJsonElement m2) {
                return new CompareToBuilder().append((Object)m1.getFileName().toLowerCase(), (Object)m2.getFileName().toLowerCase()).toComparison();
            }
        });
        miniCloudFileListJsonElement.setMiniclouds(miniCloudElements);
        return miniCloudFileListJsonElement;
    }

    @RequestMapping(value={"cloud/{cloudName}/files/mobile/upload"}, method={RequestMethod.POST})
    public void uploadFileForMobile(@PathVariable(value="cloudName") String cloudName, @RequestParam(value="file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) throws IllegalStateException, IOException {
        logger.debug("@@@@@@@@ calling /files/child ... upload file ");
        String deviceUUID = request.getParameter("deviceID");
        String devicePath = request.getParameter("uploadPath");
        String userName = request.getParameter("userName");
        InputStream input = file.getInputStream();
        String md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)input)));
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName);
        String destinationPath = this.writeFileToTempUploadlocation(file, path);
        FileElement fileElement = new FileElement();
        fileElement.setFileName(URLDecoder.decode(file.getOriginalFilename(), UTF_8));
        fileElement.setFileCompletePath(URLDecoder.decode(devicePath, UTF_8));
        fileElement.setMd5checksum(URLDecoder.decode(md5, UTF_8));
        fileElement.setFileDeviceOwner(URLDecoder.decode(userName, UTF_8));
        fileElement.setExists(true);
        boolean isCreateFolder = this.isCreateFolder(request);
        String token = request.getParameter("token");
        this.fileUpload(cloudName, fileElement, response, userName, isCreateFolder, true, token, request, null, null);
        logger.debug(destinationPath + "  @@@@@@@@ end /files/child ... upload file " + deviceUUID);
    }

    private String writeFileToTempUploadlocation(MultipartFile file, String path) throws IOException {
        File fileToUpload;
        String destinationPath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + URLDecoder.decode(file.getOriginalFilename(), UTF_8);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(fileToUpload = new File(destinationPath)).exists()) {
            fileToUpload.createNewFile();
        }
        file.transferTo(fileToUpload);
        return destinationPath;
    }

    private boolean isCreateFolder(HttpServletRequest request) {
        String createFolderStr = request.getHeader("isCreateFolder");
        boolean isCreateFolder = false;
        if (!StringUtils.isEmpty((String)createFolderStr)) {
            isCreateFolder = Boolean.parseBoolean(createFolderStr);
        }
        return isCreateFolder;
    }

    private ConsolidatedImage checkValidFileOrNot(String path, int cloudId, String cloudName, String userName) {
        String userNameVal = userName;
        if (path == null) {
            return null;
        }
        String[] params = path.split("/");
        if (params.length == 1) {
            boolean isRecordExists;
            String finalPath = path;
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, finalPath);
            if (isPathInsideMC) {
                userNameVal = "";
            }
            if ((isRecordExists = this.resourceService.isDestinationPathExists(cloudId, userNameVal, cloudName, finalPath).booleanValue()) || "ParaBlu".equalsIgnoreCase(finalPath)) {
                return new ConsolidatedImage();
            }
            logger.debug("  !!!!!!!!!!!!!!!!!!!!!!! ...root folder null.." + finalPath);
            return null;
        }
        File f = new File(path);
        String finalFileName = f.getPath().substring(path.lastIndexOf(47) + 1, f.getPath().length());
        String finalPath = f.getPath().substring(0, f.getPath().lastIndexOf(47));
        boolean isPathInsideMC = this.isPathInsideMC(cloudId, path);
        if (isPathInsideMC) {
            userNameVal = "";
        }
        logger.debug(" checkvalidfileornot ....." + path);
        ConsolidatedImage consolidatedImage = this.resourceService.getExistingConsolidatedImage(cloudId, userNameVal, cloudName, finalFileName, finalPath);
        return consolidatedImage;
    }

    private BackUpImage checkValidSyncFileOrNot(String path, int cloudId, String cloudName, String userName, User user, MiniCloud miniCloud) {
        String userNameVal = userName;
        if (path == null) {
            return null;
        }
        String[] params = path.split("/");
        if (params.length == 1) {
            boolean isRecordExists;
            String finalPath = path;
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, finalPath);
            if (isPathInsideMC) {
                userNameVal = "";
            }
            if ((isRecordExists = this.resourceService.isSyncDestinationPathExists(cloudId, userNameVal, cloudName, finalPath, user, miniCloud)) || "ParaBlu".equalsIgnoreCase(finalPath)) {
                return new BackUpImage();
            }
            logger.debug("  !!!!!!!!!!!!!!!!!!!!!!! ...root folder null.." + finalPath);
            return null;
        }
        File f = new File(path);
        String finalFileName = f.getPath().substring(path.lastIndexOf(47) + 1, f.getPath().length());
        String finalPath = f.getPath().substring(0, f.getPath().lastIndexOf(47));
        boolean isPathInsideMC = this.isPathInsideMC(cloudId, path);
        if (isPathInsideMC) {
            userNameVal = "";
        }
        logger.debug(" checkvalidfileornot ....." + path);
        BackUpImage backUpImage = this.resourceService.getExistingSyncBackUpImage(cloudId, userNameVal, cloudName, finalFileName, finalPath, user, miniCloud);
        return backUpImage;
    }

    @RequestMapping(value={"/download/externalfile/"}, method={RequestMethod.GET})
    public synchronized void downloadFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("  INSIDE DOWNLOAD FILE  STARTED ....");
        String fileName = request.getHeader("file-name");
        String folderPath = request.getHeader("file-path");
        String deviceUUID = request.getHeader("deviceUUID");
        String cloudName = request.getHeader("cloudName");
        String userName = request.getHeader("userName");
        String backupId = request.getHeader("backupId");
        logger.debug(fileName + "  DOWNLOAD FILE folderPath Completed ...." + folderPath);
        logger.debug(userName + "  DOWNLOAD FILE " + deviceUUID + " Completed ...." + backupId);
        try {
            RestTemplate restTemplate = new RestTemplate();
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new MarshallingHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add("userName", userName);
            headers.add("file-name", fileName);
            headers.add("file-path", folderPath);
            headers.add("deviceUUID", deviceUUID);
            headers.add("cloudName", cloudName);
            headers.add("backupId", backupId);
            HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
            String azureGatewayPath = "NEED TO CLEAN";
            String url = "https://" + azureGatewayPath + "/PrivacyGateway/ping1";
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, SharedFileImageElement.class, new Object[0]);
            SharedFileImageElement sharedFileImageElement = (SharedFileImageElement)result.getBody();
            logger.debug("RESPONSE VALUE >>>>>>>>>>>>>>>>>>>>>>>>>>>>  " + sharedFileImageElement);
            this.shareDownloadFile(cloudName, sharedFileImageElement, response);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.error(" Trying to Download ..... ");
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/validate/minicloud/{miniCloudName}/"}, method={RequestMethod.GET})
    public void validateMiniCloud(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="miniCloudName") String miniCloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("/files/validate/minicloudName ...");
        Boolean isValidMiniCloud = false;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            Cloud cloud = cl.getCloud();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloud.getCloudId(), cloudNameTemp, token, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            if (!StringUtils.isEmpty((String)miniCloudName)) {
                isValidMiniCloud = this.miniCloudAccessControlService.isMiniCloud(cloud.getCloudId(), cloudNameTemp, miniCloudName);
            }
            if (isValidMiniCloud.booleanValue()) {
                response.setStatus(200);
            } else {
                response.setStatus(400);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" ERROR trying to validate minicloud ..... " + e.getMessage());
            response.setStatus(404);
        }
        response.setHeader("isValidMiniCloud", isValidMiniCloud.toString());
    }

    @RequestMapping(value={"cloud/{cloudName}/externalfiles/delete/"}, method={RequestMethod.DELETE})
    public void deleteExternalFileResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(200);
    }

    public void shareDownloadFile(String cloudName, SharedFileImageElement sharedFileImageElement, HttpServletResponse response) {
        logger.debug("INSIDE shareDownloadFile ..");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            response.setStatus(500);
            logger.error(" File is not shared ...");
            return;
        }
        catch (DataAccessException e) {
            response.setStatus(500);
            logger.trace("" + (Object)((Object)e));
            logger.error(" Data Access Exception  ..." + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(400);
            logger.trace("" + (Object)((Object)e));
            logger.error(" Bad Request Exception  ..." + e.getMessage());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.error(" exception Request Exception  ..." + e);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/files/update/revision/comment"}, method={RequestMethod.POST})
    public void updateRevisionComment(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /files/revision/comment  ...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                return;
            }
            String encodedFilePath = request.getHeader("filePath");
            String filePath = this.decodeBase64UTFString(encodedFilePath);
            if (StringUtils.isBlank((String)filePath)) {
                logger.debug(PATH + filePath);
                throw new BaseException(INVALID_REQUEST);
            }
            User user = null;
            MiniCloud miniCloud = null;
            if (this.isPathInsideMC(cloudId, filePath)) {
                String mcName = ResourceController.getMCName(filePath);
                miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            } else {
                AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
                user = authorizationTokens.getUser();
            }
            String revisionId = request.getHeader("revisionId");
            String comment = request.getHeader("comment");
            if (revisionId == null) {
                response.setStatus(400);
                return;
            }
            this.resourceService.updateRevisionComment(cloudId, cloudNameTemp, revisionId, comment, user, miniCloud);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_UPDATING_REVISION_COMMENTS + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_UPDATING_REVISION_COMMENTS + e.getMessage());
            response.setStatus(409);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_UPDATING_REVISION_COMMENTS + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/backup/download/mobile/file"}, method={RequestMethod.GET})
    public void downloadMobileFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        String fileName = request.getHeader("file-name");
        String folderPath = request.getHeader("file-path");
        String token = request.getHeader("token");
        String deviceUUID = request.getHeader("deviceUUID");
        boolean requestSuccess = false;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudNameTemp, token);
        if (authorizationTokens == null) {
            response.setStatus(401);
            return;
        }
        User user = authorizationTokens.getUser();
        ConsolidatedImage consolidatedImage = this.resourceService.getExistingConsolidatedImage(cloudId, user.getUserName(), cloudNameTemp, fileName, folderPath);
        if (consolidatedImage == null) {
            logger.debug(fileName + " RECORD does not exist ... " + folderPath);
            response.setStatus(403);
            return;
        }
        try (BufferedInputStream inputStream = this.downloadService.downloadFile(cloudId, user.getUserName(), cloudNameTemp, folderPath, fileName);){
            String mobileDownloadDir = "/var/www/portal/public/mobile";
            String downloadFilePath = mobileDownloadDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
            File downloadFile = new File(downloadFilePath);
            logger.debug(" FILE DOWNLOAD PATH ... " + downloadFilePath);
            if (!downloadFile.exists()) {
                downloadFile.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(downloadFile);
            this.copy(inputStream, os);
            requestSuccess = true;
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while downloading mobile file " + e.getMessage());
            response.setHeader("errorMessage", e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (IOException ex) {
            response.setHeader("errorMessage", ex.getMessage());
            response.setStatus(500);
            logger.trace("IOException" + ex);
            logger.error("IOException" + ex.getMessage());
        }
        if (requestSuccess) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "download started in mobile", user.getUserName(), fileName, deviceUUID, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"cloud/{cloudName}/sync/portal/blukrypt/upload"}, method={RequestMethod.POST})
    public void insertEntryFromBlukrypt(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("INSIDE ResourceController sync1/upload ");
        Object renamedConflictedOriginalFileName = null;
        String cloudNameTemp = cloudName;
        boolean requestSuccess = false;
        Object inputStream = null;
        FileElement fileElement = new FileElement();
        String token = request.getParameter("token");
        boolean miniCloudId = false;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        Cloud cloud = cl.getCloud();
        cloudNameTemp = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        String filePath = "";
        String fileName = "";
        String fileMetadata = "";
        boolean isFileInfected = false;
        try {
            logger.debug(token + "!!!!! ..... " + request.getParameter("file-name"));
            fileElement.setFileName(this.decodeBase64UTFString(request.getParameter("file-name")));
            logger.debug(token + "getFileName..... " + fileElement.getFileName());
            fileElement.setMetaData(request.getParameter("meta-data"));
            fileElement.setFileCompletePath(this.decodeBase64UTFString(request.getParameter("file-path")));
            fileElement.setExists(Boolean.valueOf(request.getParameter("is-exists")).booleanValue());
            fileElement.setFolder(Boolean.valueOf(request.getParameter("is-folder")).booleanValue());
            fileElement.setMd5checksum(request.getParameter("fileMD5"));
            fileElement.setSize(request.getParameter("file-size"));
            String gatewayName = request.getParameter("gatewayName");
            fileElement.setGatewayName(gatewayName);
            String osType = "Android";
            String deviceUUID = request.getParameter("deviceUUID");
            String userName = request.getParameter("userName");
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, fileElement.getFileCompletePath());
            String isFileInfected1 = request.getParameter("isFileInfected");
            if (StringUtils.isNotEmpty((String)isFileInfected1)) {
                isFileInfected = Boolean.valueOf(isFileInfected1);
            }
            logger.debug("..............isFileInfected.............." + isFileInfected);
            String revisionId = this.resourceService.insertSyncEntryForFileUsingPortal(cloudId, cloudNameTemp, cloud, fileElement, userName, isPathInsideMC, deviceUUID, isFileInfected);
            logger.debug(gatewayName + " REVISION IDs ............... " + revisionId);
            response.setHeader("syncRevisionId", revisionId);
            response.setHeader("isFileUnderMiniCloud", Boolean.toString(isPathInsideMC));
            response.setStatus(200);
            String action = "uploaded";
            String deviceName = "Portal".equals(deviceUUID) ? "Portal" : this.resourceService.getDeviceNameByUUID(cloudId, cloudNameTemp, deviceUUID);
            String mcName = "";
            if (isPathInsideMC) {
                mcName = ResourceController.getMCName(fileElement.getFileCompletePath());
            }
            logger.debug(mcName + "..... mcname and deviceName ............... " + deviceName);
            if (!StringUtils.isEmpty((String)mcName)) {
                this.auditHistoryService.saveStatisticToDatabaseForMC(cloudId, cloudNameTemp, action, userName, fileElement.getFileName(), deviceName, System.currentTimeMillis(), fileElement.getFileCompletePath(), PCActionTypes.FILE_UPLOAD.getActionTypeValue(), mcName);
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, action, userName, fileElement.getFileName(), deviceName, System.currentTimeMillis(), fileElement.getFileCompletePath(), PCActionTypes.FILE_UPLOAD.getActionTypeValue());
            }
            requestSuccess = true;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        finally {
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.debug("IOException ", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/sync/portal/upload/audit"}, method={RequestMethod.POST})
    public void insertEntryForAUditFromBlukrypt(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("INSIDE ResourceController /sync/portal/upload/audit");
        String cloudNameTemp = cloudName;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            logger.debug("INside lice");
            return;
        }
        Cloud cloud = cl.getCloud();
        cloudNameTemp = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        try {
            logger.debug("INside try");
            String action = request.getParameter("action");
            action = "Failed to upload";
            String token = request.getParameter("token");
            String userName = request.getParameter("userName");
            String fileName = request.getParameter("fileName");
            String deviceName = request.getParameter(DEVICE_NAME);
            String filePath = request.getParameter("filePath");
            filePath = filePath.replace("\\", "/");
            String additionalInfo = " Infected file detected ";
            this.auditHistoryService.saveStatisticToDatabaseForSyncFailedFiles(cloudId, cloudNameTemp, action, userName, fileName, deviceName, System.currentTimeMillis(), filePath, PCActionTypes.FILE_UPLOAD_FAILED.getActionTypeValue(), additionalInfo);
            logger.debug("INside try" + action + userName + fileName + filePath + deviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("INside lice", (Throwable)e);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), UTF_8);
            logger.debug("UnsupportedEncodingException");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        int i;
        byte[] b = new byte[1024];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
        is.close();
        os.close();
    }

    @RequestMapping(value={"cloud/{cloudName}/update/sync/table"}, method={RequestMethod.POST})
    public void updateUploadStatusBackupTable(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        logger.debug("calling /update/sync/table ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudNameTemp = cl.getCloud().getCloudName();
            String syncRevisionId = request.getHeader("syncRevisionId");
            String storagePlace = request.getHeader("storage-place");
            logger.debug("Sync revision ID from header:" + syncRevisionId + "storag place:" + storagePlace);
            this.resourceService.updateExternalStorageStatusOfFile(cloudId, cloudNameTemp, new ObjectId(syncRevisionId), storagePlace);
            logger.debug("status: 200 For Update external storage file status");
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while updating upload status backup table " + e.getMessage());
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while updating upload status backup table " + e.getMessage());
            response.setStatus(400);
        }
    }

    private boolean isPathInsideMC(int cloudId, String path) {
        String mcNameFromPath = ResourceController.getMCName(path);
        if (StringUtils.isEmpty((String)mcNameFromPath)) {
            return false;
        }
        List cloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, "").getMiniClouds();
        boolean isPathInsideMC = false;
        for (MiniCloudElement miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    @RequestMapping(value={"cloud/{cloudName}/synRevisionId/"}, method={RequestMethod.GET})
    public void getSyncRevisionId(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        try {
            logger.debug("@@@@ Inside getSyncRevisionId ...." + cloudNameTemp);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                logger.error("@@ VALIDATE TOKEN checkLicense failed for cloud ...." + cloudNameTemp);
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String consId = request.getHeader("consId");
            String revisionId = "";
            String gatewayName = "";
            FileRevision revision = this.resourceService.getLatestRevisionForConsId(cloudId, consId);
            if (revision != null) {
                revisionId = revision.getId().toString();
                gatewayName = revision.getGatewayName();
            }
            response.setHeader("revisionId", revisionId);
            response.setHeader("gatewayName", gatewayName);
            response.setStatus(200);
            logger.debug(consId + "@@@@ End ofgetSyncRevisionId ...." + revisionId);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting sync revision id " + e.getMessage());
            response.setStatus(500);
            return;
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting sync revision id " + e.getMessage());
            response.setStatus(400);
            return;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            logger.error("@@@@ getSyncRevisionId failed for cloud ...." + cloudNameTemp);
        }
    }
}

