/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.service.ResourceSyncService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.dto.ShareAndSearchDLTO;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.User;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MinicloudController
extends BaseController {
    private static Logger logger = LogManager.getLogger(MinicloudController.class);
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    private ResourceSyncService resourceService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private CloudMailService cloudMailService;
    private static final String DATA_ACCESS_EXCEPTION = "EmptyResultDataAccessException";
    private static final String USER_NOT_FOUND = "User not found.";
    private static final String EXCEPTION = "Exception";
    private static final String EXCEPTION_GETTING_MINICLOUDS = "Exception while getting miniclouds ";
    private static final String EXCEPTION_GETTING_ALL_MINICLOUDS = "Exception while getting all miniclouds ";
    private static final String IS_MOBILE = "isMobile";
    private static final String MOBILE = "Mobile";

    @RequestMapping(value={"cloud/{cloudName}/myclouds"}, method={RequestMethod.POST})
    public void createMiniCloud(@PathVariable(value="cloudName") String cloudName, @RequestBody MiniCloudElement miniCloudElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling mini cloud...:");
        ModelAndView modelAndView = new ModelAndView();
        String contentType = request.getHeader("contentType");
        String cloudNameTemp = cloudName;
        if (StringUtils.isEmpty((Object)contentType)) {
            logger.debug("@@@ calling getChildrenForFolder XML_VIEW cloud/{cloudName}/myclouds ..." + contentType);
            modelAndView.setViewName("xmlview");
        } else {
            logger.debug("@@@ calling getChildrenForFolder JSON_VIEW cloud/{cloudName}/myclouds" + contentType);
            modelAndView.setViewName("jsonview");
        }
        User user = new User();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            int code = this.deviceAndUserSecurityService.validateMiniCloudRestrictions(cloudId, cloudNameTemp, cl.getCloud());
            if (!this.checkLicense(code, response)) {
                return;
            }
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudNameTemp, token, user, response)) {
                return;
            }
            String userName = user.getUserName();
            String mobileHeader = request.getHeader(IS_MOBILE);
            logger.debug("@@@Mobile header flag  ... " + mobileHeader);
            boolean isMobile = Boolean.parseBoolean(mobileHeader);
            if (user.isAdmin()) {
                miniCloudElement.setCreationTimeStamp(System.currentTimeMillis());
                MiniCloud miniCloudCreated = this.miniCloudAccessControlService.createMiniCloud(cloudId, userName, cloudNameTemp, miniCloudElement);
                if (miniCloudCreated == null) {
                    response.setStatus(403);
                    return;
                }
                response.setStatus(200);
                FileElement fileElement = new FileElement();
                fileElement.setExists(true);
                fileElement.setFileCompletePath("ParaBlu");
                fileElement.setFileName(miniCloudElement.getMiniCloudName());
                fileElement.setFolder(true);
                fileElement.setLastModifiedTimestamp(System.currentTimeMillis());
                List<SearchIndex> searchIndexs = this.resourceService.uploadMCResourceFile(cl.getCloud(), userName, fileElement, miniCloudCreated);
                String deviceName = "Portal";
                if (isMobile) {
                    deviceName = MOBILE;
                }
                if (searchIndexs != null) {
                    response.setStatus(200);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "created mini cloud", userName, fileElement.getFileName(), deviceName, System.currentTimeMillis(), PCActionTypes.CLOUD_CREATE.getActionTypeValue());
                }
            } else {
                response.setStatus(401);
            }
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace("EmptyResultDataAccessException :" + (Object)((Object)e));
            logger.error("EmptyResultDataAccessException :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
        }
        catch (DataAccessException e) {
            logger.trace("DataAccessException :" + (Object)((Object)e));
            logger.error("DataAccessException :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("BaseException :" + (Object)((Object)e));
            logger.error("BaseException :" + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.debug("Exception in minicloudcontroller : ", (Throwable)e);
            logger.trace("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        logger.debug(" END OF SAVE MINICLOUD ... ");
    }

    @RequestMapping(value={"cloud/{cloudName}/mcupdate"}, method={RequestMethod.PUT})
    public void edditCloudCredentials(@PathVariable(value="cloudName") String cloudName1, @RequestBody MiniCloudElement miniCloudElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling cloud/{cloudName}/mcupdate...:");
        ModelAndView modelAndView = new ModelAndView();
        String contentType = request.getHeader("contentType");
        String cloudNameTemp = cloudName1;
        if (StringUtils.isEmpty((Object)contentType)) {
            logger.debug("@@@ calling getChildrenForFolder XML_VIEW cloud/{cloudName}/myclouds ..." + contentType);
            modelAndView.setViewName("xmlview");
        } else {
            logger.debug("@@@ calling getChildrenForFolder JSON_VIEW cloud/{cloudName}/myclouds" + contentType);
            modelAndView.setViewName("jsonview");
        }
        User user = new User();
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return;
            }
            String userName = user.getUserName();
            String mobileHeader = request.getHeader(IS_MOBILE);
            logger.debug("@@@Mobile header flag  ... " + mobileHeader);
            boolean isMobile = Boolean.parseBoolean(mobileHeader);
            if (user.isAdmin()) {
                this.miniCloudAccessControlService.updateMiniCloud(cloudId, miniCloudElement, userName);
                response.setStatus(200);
                String deviceName = "Portal";
                if (isMobile) {
                    deviceName = MOBILE;
                }
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "updated ownership of mini cloud", userName, miniCloudElement.getMiniCloudName(), deviceName, System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_UPDATE.getActionTypeValue(), true, miniCloudElement.getMiniCloudName());
            } else {
                response.setStatus(401);
            }
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace("EmptyResultDataAccessException :" + (Object)((Object)e));
            logger.error("EmptyResultDataAccessException :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
        }
        catch (DataAccessException e) {
            logger.trace("DataAccessException :" + (Object)((Object)e));
            logger.error("DataAccessException :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("BaseException :" + (Object)((Object)e));
            logger.error("BaseException :" + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.trace("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        logger.debug(" END OF update MINICLOUD ... ");
    }

    @RequestMapping(value={"cloud/{cloudName}/myclouds/delete"}, method={RequestMethod.POST})
    public void deleteMiniCloud(@PathVariable(value="cloudName") String cloudName, @RequestBody MiniCloudElement miniCloudElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" BEFORE deleting minicloud ... ");
        User user = new User();
        String cloudNameTemp = cloudName;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        int cloudId = 0;
        String userName = "";
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            userName = user.getUserName();
            if (user.isAdmin()) {
                logger.debug(" BEFORE deleting minicloud user.isAdmin() ... ");
                ShareAndSearchDLTO shareAndSearchIndexes = this.resourceService.deleteMiniCloudPermanently(cloudId, cloudNameTemp, miniCloudElement, "");
                if (shareAndSearchIndexes != null) {
                    this.addSearchIndexToTable(cl.getCloud(), shareAndSearchIndexes.getSearchIndexs());
                    this.resourceService.unShareFileList(cloudNameTemp, shareAndSearchIndexes.getSharedFileNames(), shareAndSearchIndexes.getSharedDevicePaths());
                    response.setStatus(200);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "deleted mini cloud", userName, miniCloudElement.getMiniCloudName(), "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_DELETE.getActionTypeValue(), true, miniCloudElement.getMiniCloudName());
                } else {
                    response.setStatus(500);
                }
            } else {
                response.setStatus(401);
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("EmptyResultDataAccessException :" + (Object)((Object)e));
            logger.error("EmptyResultDataAccessException :" + e.getMessage());
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while deleting minicloud " + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
            logger.error("Exception :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/myclouds/{mcName}/"}, method={RequestMethod.GET})
    public ModelAndView getMiniCloud(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="mcName") String mcName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(mcName + "....calling cloud/{cloudName}/myclouds/{mcName}/..." + request.getHeader("userEditProfile"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudNameTemp = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser = new User(), response)) {
                return null;
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((Object)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            MiniCloud miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, mcName);
            MiniCloudElement element = new MiniCloudElement();
            BeanUtils.copyProperties((Object)element, (Object)miniCloud);
            modelAndView.addObject((Object)element);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            modelAndView.addObject(null);
            response.setStatus(400);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/myclouds/user/{userName}/"}, method={RequestMethod.GET})
    public ModelAndView getMiniClouds(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling get mini cloud...:" + userName);
        ModelAndView modelAndView = new ModelAndView();
        String cloudNameTemp = cloudName;
        modelAndView.setViewName("xmlview");
        try {
            String token;
            if (!StringUtils.hasText((String)userName)) {
                throw new BaseException("Invalid Request.");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
                return null;
            }
            UserElement ue = this.managementService.getUserInfo(cloudId, cloudNameTemp, userName);
            MiniCloudElementList cloudElementList = ue.getMiniCloudElementList();
            modelAndView.addObject((Object)cloudElementList);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/myclouds/all"}, method={RequestMethod.GET})
    public ModelAndView getAllMiniClouds(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling cloud/{cloudName}/myclouds/all..." + request.getHeader("userEditProfile"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudNameTemp = cloudName;
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudNameTemp = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser = new User(), response)) {
                return null;
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((Object)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            MiniCloudElementList cloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp);
            if (!(currentUser == null || validAdmin || StringUtils.isEmpty((Object)currentUser.getUserName()) || cloudElementList == null || CollectionUtils.isEmpty((Collection)cloudElementList.getMiniClouds()))) {
                List miniCloudList = cloudElementList.getMiniClouds().stream().filter(miniCloud -> Objects.nonNull(miniCloud.getOwner()) && miniCloud.getOwner().equalsIgnoreCase(currentUser.getUserName())).collect(Collectors.toList());
                cloudElementList.setMiniClouds(miniCloudList);
            }
            modelAndView.addObject((Object)cloudElementList);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
        }
        catch (DataAccessException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error(EXCEPTION_GETTING_ALL_MINICLOUDS + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/update/minicloud/"}, method={RequestMethod.POST})
    public void updateOwnershipForMC(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling update mini cloud...:");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        User user = new User();
        String cloudNameTemp = cloudName;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return;
            }
            String userName = request.getHeader("userName");
            String miniCloudName = request.getHeader("miniCloudName");
            if (!user.isAdmin() || StringUtils.isEmpty((Object)userName) || StringUtils.isEmpty((Object)miniCloudName)) {
                response.setStatus(400);
                return;
            }
            if (user.isAdmin()) {
                MiniCloud miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, miniCloudName);
                if (miniCloud == null) {
                    return;
                }
                User oldMCUser = this.managementService.getUserDetails(cloudId, "", miniCloud.getOwner());
                User newMCUser = this.managementService.getUserDetails(cloudId, "", userName);
                this.miniCloudAccessControlService.updateOwnershipForMC(cloudId, userName, miniCloudName);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "updated ownership of mini cloud", user.getUserName(), miniCloudName + " to " + userName, "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_UPDATE.getActionTypeValue(), true, miniCloud.getMiniCloudName());
                response.setStatus(200);
                String action = "mc-change-ownership";
                this.sendEmailForMCOwnerShip(cloudId, miniCloudName, user, newMCUser, action);
                action = "mc-revoke-ownership";
                this.sendEmailForMCOwnerShip(cloudId, miniCloudName, user, oldMCUser, action);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        logger.debug(" end of update minicloud ... ");
    }

    @RequestMapping(value={"cloud/{cloudName}/assign/minicloud/users/"}, method={RequestMethod.POST})
    public void assignAccessForMC(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling assign mini cloud...:");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        User user = new User();
        String cloudNameTemp = cloudName;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudNameTemp = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                return;
            }
            String userNames = request.getHeader("userNames");
            String miniCloudName = request.getHeader("miniCloudName");
            MiniCloud miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, miniCloudName);
            boolean isLoggedInUserMCOwner = false;
            if (miniCloud != null) {
                isLoggedInUserMCOwner = user.getUserName().equals(miniCloud.getOwner());
                logger.debug(miniCloud.getMiniCloudName() + " MC name  .....................  " + miniCloud.getOwner() + ".... val ...." + isLoggedInUserMCOwner);
            } else {
                logger.debug(" Minicloud info .................  ");
            }
            if (!isLoggedInUserMCOwner || StringUtils.isEmpty((Object)miniCloudName)) {
                response.setStatus(400);
                return;
            }
            if (StringUtils.isEmpty((Object)userNames)) {
                this.miniCloudAccessControlService.deleteUserAccessForMinicloud(cloudId, miniCloud.getId());
                ArrayList<String> list = new ArrayList<String>();
                list.add(miniCloud.getOwner());
                this.miniCloudAccessControlService.createAccessControlMapping(cloudId, list, miniCloudName);
                List existingUsers = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloudNameTemp, miniCloudName);
                for (User user1 : existingUsers) {
                    if (user1.getUserName().equalsIgnoreCase(user.getUserName())) continue;
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "revoked access of Minicloud", user.getUserName(), "(" + miniCloudName + ") for " + user1.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_REVOKED.getActionTypeValue(), true, miniCloudName);
                }
                response.setStatus(200);
                return;
            }
            logger.debug(user.getUserName() + " user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            logger.debug(" total size .... " + list.size());
            ArrayList<String> list1 = new ArrayList<String>();
            list1.addAll(list);
            HashSet<String> existingUserNames = new HashSet<String>();
            List existingUsers = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloudNameTemp, miniCloudName);
            for (User userObj : existingUsers) {
                if (userObj == null) continue;
                existingUserNames.add(userObj.getUserName());
                list1.remove(userObj.getUserName());
            }
            existingUserNames.removeAll(removeSet);
            existingUserNames.remove(user.getUserName());
            logger.debug(" removed user size .... " + list1.size());
            this.miniCloudAccessControlService.createAccessControlMapping(cloudId, list, miniCloudName);
            for (String userName : list1) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "assigned minicloud", user.getUserName(), miniCloudName + " to " + userName, "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_ASSIGN.getActionTypeValue(), true, miniCloudName);
            }
            for (String userName : existingUserNames) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "revoked access of Minicloud", user.getUserName(), "(" + miniCloudName + ") for " + userName, "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_REVOKED.getActionTypeValue(), true, miniCloudName);
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        logger.debug(" end of calling assign mini cloud... ");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/miniClouds/createExcel/"}, method={RequestMethod.POST})
    void createExcelForMiniclouds(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        User currentUser;
        String cloudName = cloudName1;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        int cloudId = cl.getCloud().getCloudId();
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid Cloud Name.....");
            return;
        }
        String token = request.getHeader("token");
        if (!this.performAuthorization(cloudId, cloudName, token, currentUser = new User(), response)) {
            return;
        }
        try {
            boolean isExcelCreated;
            MiniCloudElementList cloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudName);
            if (!(currentUser == null || currentUser.isAdmin() || StringUtils.isEmpty((Object)currentUser.getUserName()) || cloudElementList == null || CollectionUtils.isEmpty((Collection)cloudElementList.getMiniClouds()))) {
                List miniCloudList = cloudElementList.getMiniClouds().stream().filter(miniCloud -> Objects.nonNull(miniCloud.getOwner()) && miniCloud.getOwner().equalsIgnoreCase(currentUser.getUserName())).collect(Collectors.toList());
                cloudElementList.setMiniClouds(miniCloudList);
            }
            if (isExcelCreated = this.miniCloudAccessControlService.createExcelForMiniClouds(cloudElementList)) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            response.setStatus(500);
        }
    }

    private void sendEmailForMCOwnerShip(int cloudId, String mcName, User adminUser, User assignedToUser, String action) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(assignedToUser.getUserName());
        emailRecipent.setEmail(assignedToUser.getEmailId());
        emailRecipents.add(emailRecipent);
        List users = this.managementService.getAllAdmins(cloudId, "");
        for (User user : users) {
            if (!user.isActive() || user.getUserName().equalsIgnoreCase(assignedToUser.getUserName())) continue;
            emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(user.getUserName());
            emailRecipent.setEmail(user.getEmailId());
            emailRecipents.add(emailRecipent);
        }
        email.setActionOn(assignedToUser.getUserName());
        email.setMcName(mcName);
        email.setUserName(assignedToUser.getUserName());
        email.setActionBy(adminUser.getUserName());
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }
}

